/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.hausdorff;

import java.util.Arrays;
import lu.uni.minus.utils.hausdorff.SemanticTags;

public class Distribution {
    private double[] probabilities;
    private static final double distanceThreshold = 0.5;

    public Distribution(double[] someProbabilities) {
        this.probabilities = someProbabilities;
    }

    public Distribution() {
        this.probabilities = new double[SemanticTags.values().length];
    }

    public double[] getProbabilites() {
        return this.probabilities;
    }

    public String toString() {
        return Arrays.toString(this.probabilities);
    }

    public boolean isLSsimilar(Distribution anotherDistribution) {
        return this.calculateDistance(anotherDistribution) <= 0.5;
    }

    public Distribution merge(Distribution anotherDistribution) {
        Distribution newDistribution = new Distribution();
        int index = 0;
        while (index < SemanticTags.values().length) {
            newDistribution.getProbabilites()[index] = (this.probabilities[index] + anotherDistribution.getProbabilites()[index]) / 2.0;
            ++index;
        }
        return newDistribution;
    }

    public double relativeEntropy(Distribution anotherDistribution) {
        double sum = 0.0;
        int index = 0;
        while (index < this.probabilities.length) {
            sum += this.probabilities[index] * Math.log(this.probabilities[index] / anotherDistribution.getProbabilites()[index]);
            ++index;
        }
        return sum;
    }

    public double calculateDistance(Distribution anotherDistribution) {
        return (this.relativeEntropy(anotherDistribution) + anotherDistribution.relativeEntropy(this)) / 2.0;
    }

    public double calculateHellingerDistance(Distribution anotherDistribution) {
        double BhattacharyyaCoefficient = 0.0;
        int i = 0;
        while (i < this.probabilities.length) {
            BhattacharyyaCoefficient += Math.sqrt(this.probabilities[i] * anotherDistribution.getProbabilites()[i]);
            ++i;
        }
        if (BhattacharyyaCoefficient - 1.0 <= Math.pow(10.0, -10.0) && BhattacharyyaCoefficient - 1.0 >= -Math.pow(10.0, -10.0)) {
            return 0.0;
        }
        return Math.sqrt(1.0 - BhattacharyyaCoefficient);
    }

    public double calculateTotalVariationDistance(Distribution anotherDistribution) {
        double sum = 0.0;
        int i = 0;
        while (i < this.probabilities.length) {
            sum += Math.abs(this.probabilities[i] - anotherDistribution.getProbabilites()[i]);
            ++i;
        }
        return sum / 2.0;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null) {
            return false;
        }
        if (!(anObject instanceof Distribution)) {
            return false;
        }
        return Arrays.equals(this.probabilities, ((Distribution)anObject).getProbabilites());
    }

    public int hashCode() {
        double hashcode = 0.0;
        int i = 0;
        while (i < this.probabilities.length) {
            hashcode += this.probabilities[i] * (double)(0x1F ^ i);
            ++i;
        }
        return (int)hashcode;
    }
}

