/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.hausdorff;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import lu.uni.minus.utils.hausdorff.Distribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequentPattern {
    private LinkedList<Distribution> distributions;
    private double relativeSupport;
    private int absoluteSupport;

    public FrequentPattern() {
        this.distributions = new LinkedList();
        this.relativeSupport = 0.0;
        this.absoluteSupport = 0;
    }

    public FrequentPattern(LinkedList<Distribution> someDistributions, double aRelativeSupport, int anAbsoluteSupport) {
        this.distributions = someDistributions;
        this.relativeSupport = aRelativeSupport;
        this.absoluteSupport = anAbsoluteSupport;
    }

    public double calculateHellingerDistance(FrequentPattern anotherFrequentPattern) {
        if (this.distributions.size() != anotherFrequentPattern.getDistributions().size()) {
            System.out.println("Error: cannot calculate the distance between two patterns of different lengths");
            System.exit(0);
        }
        double sumOfDistances = 0.0;
        Iterator iterator1 = this.distributions.iterator();
        Iterator iterator2 = anotherFrequentPattern.getDistributions().iterator();
        try {
            while (iterator1.hasNext()) {
                Distribution distribution1 = (Distribution)iterator1.next();
                Distribution distribution2 = (Distribution)iterator2.next();
                sumOfDistances += distribution1.calculateHellingerDistance(distribution2);
            }
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        return sumOfDistances / (double)this.distributions.size();
    }

    public double calculateHellingerDistance2(FrequentPattern anotherFrequentPattern) {
        double sumOfDistances = 0.0;
        if (this.distributions.size() < anotherFrequentPattern.getDistributions().size()) {
            Iterator iterator1 = this.distributions.iterator();
            Iterator iterator2 = anotherFrequentPattern.getDistributions().iterator();
            try {
                while (iterator1.hasNext()) {
                    Distribution distribution1 = (Distribution)iterator1.next();
                    Distribution distribution2 = (Distribution)iterator2.next();
                    sumOfDistances += distribution1.calculateHellingerDistance(distribution2);
                }
                while (iterator2.hasNext()) {
                    iterator2.next();
                    sumOfDistances += 1.0;
                }
            }
            catch (NoSuchElementException e) {
                e.printStackTrace();
            }
            return sumOfDistances / (double)anotherFrequentPattern.getDistributions().size();
        }
        Iterator iterator1 = this.distributions.iterator();
        Iterator iterator2 = anotherFrequentPattern.getDistributions().iterator();
        try {
            while (iterator2.hasNext()) {
                Distribution distribution1 = (Distribution)iterator1.next();
                Distribution distribution2 = (Distribution)iterator2.next();
                sumOfDistances += distribution1.calculateHellingerDistance(distribution2);
            }
            while (iterator1.hasNext()) {
                iterator1.next();
                sumOfDistances += 1.0;
            }
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        return sumOfDistances / (double)this.distributions.size();
    }

    public double calculateTotalVariationDistance(FrequentPattern anotherFrequentPattern) {
        if (this.distributions.size() != anotherFrequentPattern.getDistributions().size()) {
            System.out.println("Error: cannot calculate the distance between two patterns of different lengths");
            System.exit(0);
        }
        double sumOfDistances = 0.0;
        Iterator iterator1 = this.distributions.iterator();
        Iterator iterator2 = anotherFrequentPattern.getDistributions().iterator();
        try {
            while (iterator1.hasNext()) {
                Distribution distribution1 = (Distribution)iterator1.next();
                Distribution distribution2 = (Distribution)iterator2.next();
                sumOfDistances += distribution1.calculateTotalVariationDistance(distribution2);
            }
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        return sumOfDistances / (double)this.distributions.size();
    }

    public double calculateTotalVariationDistance2(FrequentPattern anotherFrequentPattern) {
        double sumOfDistances = 0.0;
        if (this.distributions.size() < anotherFrequentPattern.getDistributions().size()) {
            Iterator iterator1 = this.distributions.iterator();
            Iterator iterator2 = anotherFrequentPattern.getDistributions().iterator();
            try {
                while (iterator1.hasNext()) {
                    Distribution distribution1 = (Distribution)iterator1.next();
                    Distribution distribution2 = (Distribution)iterator2.next();
                    sumOfDistances += distribution1.calculateTotalVariationDistance(distribution2);
                }
                while (iterator2.hasNext()) {
                    iterator2.next();
                    sumOfDistances += 1.0;
                }
            }
            catch (NoSuchElementException e) {
                e.printStackTrace();
            }
            return sumOfDistances / (double)anotherFrequentPattern.getDistributions().size();
        }
        Iterator iterator1 = this.distributions.iterator();
        Iterator iterator2 = anotherFrequentPattern.getDistributions().iterator();
        try {
            while (iterator2.hasNext()) {
                Distribution distribution1 = (Distribution)iterator1.next();
                Distribution distribution2 = (Distribution)iterator2.next();
                sumOfDistances += distribution1.calculateTotalVariationDistance(distribution2);
            }
            while (iterator1.hasNext()) {
                iterator1.next();
                sumOfDistances += 1.0;
            }
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        return sumOfDistances / (double)this.distributions.size();
    }

    public String toString() {
        String aString = "";
        for (Distribution aDistribution : this.distributions) {
            aString = String.valueOf(aString) + aDistribution.toString() + " ";
        }
        aString = String.valueOf(aString) + ": " + this.relativeSupport;
        aString = String.valueOf(aString) + " " + this.absoluteSupport + "\n";
        return aString;
    }

    public LinkedList<Distribution> getDistributions() {
        return this.distributions;
    }

    public double getRelativeSupport() {
        return this.relativeSupport;
    }

    public int getAbsoluteSupport() {
        return this.absoluteSupport;
    }

    public void setRelativeSupport(double aRelativeSupport) {
        this.relativeSupport = aRelativeSupport;
    }

    public FrequentPattern merge(FrequentPattern anotherFrequentPattern) {
        if (this.distributions.size() != anotherFrequentPattern.getDistributions().size()) {
            System.out.println("The two patterns which are to be merged are not of the same length.");
            System.exit(0);
        }
        LinkedList<Distribution> newDistributions = new LinkedList<Distribution>();
        Iterator iterator1 = this.distributions.iterator();
        Iterator iterator2 = anotherFrequentPattern.getDistributions().iterator();
        while (iterator1.hasNext()) {
            newDistributions.add(((Distribution)iterator1.next()).merge((Distribution)iterator2.next()));
        }
        return new FrequentPattern(newDistributions, this.relativeSupport + anotherFrequentPattern.getRelativeSupport(), this.absoluteSupport + anotherFrequentPattern.getAbsoluteSupport());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLSsimilar(FrequentPattern anotherFrequentPattern) {
        if (this.distributions.size() != anotherFrequentPattern.getDistributions().size()) {
            return false;
        }
        Iterator iterator1 = this.distributions.iterator();
        Iterator iterator2 = anotherFrequentPattern.getDistributions().iterator();
        try {
            Distribution distribution2;
            Distribution distribution1;
            do {
                if (iterator1.hasNext()) continue;
                return true;
            } while ((distribution1 = (Distribution)iterator1.next()).isLSsimilar(distribution2 = (Distribution)iterator2.next()));
            return false;
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        return true;
    }

    public double calculateDistance(FrequentPattern anotherFrequentPattern) {
        if (this.distributions.size() != anotherFrequentPattern.getDistributions().size()) {
            System.out.println("The two patterns are not of the same length. Cannot calculate their distance.");
            System.exit(0);
        }
        double sum = 0.0;
        Iterator iterator1 = this.distributions.iterator();
        Iterator iterator2 = anotherFrequentPattern.getDistributions().iterator();
        try {
            while (iterator1.hasNext()) {
                Distribution distribution1 = (Distribution)iterator1.next();
                Distribution distribution2 = (Distribution)iterator2.next();
                sum += distribution1.calculateDistance(distribution2);
            }
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        return sum / (double)this.distributions.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null) {
            return false;
        }
        if (!(anObject instanceof FrequentPattern)) {
            return false;
        }
        FrequentPattern anotherFrequentPattern = (FrequentPattern)anObject;
        if (this.distributions.size() != anotherFrequentPattern.getDistributions().size()) {
            return false;
        }
        Iterator iterator1 = this.distributions.iterator();
        Iterator iterator2 = anotherFrequentPattern.getDistributions().iterator();
        try {
            Distribution distribution2;
            Distribution distribution1;
            do {
                if (iterator1.hasNext()) continue;
                return true;
            } while ((distribution1 = (Distribution)iterator1.next()).equals(distribution2 = (Distribution)iterator2.next()));
            return false;
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        for (Distribution aDistribution : this.distributions) {
            hashcode += aDistribution.hashCode();
        }
        return hashcode;
    }
}

