/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.lcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lu.uni.minus.utils.lcs.Cell;
import lu.uni.minus.utils.lcs.TimeRange;
import lu.uni.minus.utils.lcs.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongestCommonSubsequenceForCells {
    public static Cell[][] computeTable(int[] inputSequenceA, int[] inputSequenceB) {
        int j;
        int aIndex = inputSequenceA.length + 1;
        int bIndex = inputSequenceB.length + 1;
        Cell[][] sequenceTable = new Cell[aIndex][bIndex];
        int i = 0;
        while (i < aIndex) {
            j = 0;
            while (j < bIndex) {
                sequenceTable[i][j] = new Cell();
                sequenceTable[0][j].seqLength = 0;
                ++j;
            }
            sequenceTable[i][0].seqLength = 0;
            ++i;
        }
        i = 1;
        while (i < aIndex) {
            j = 1;
            while (j < bIndex) {
                int A = inputSequenceA[i - 1];
                int B = inputSequenceB[j - 1];
                sequenceTable[i][j].seqLength = A == B ? sequenceTable[i - 1][j - 1].seqLength + 1 : Math.max(sequenceTable[i][j - 1].seqLength, sequenceTable[i - 1][j].seqLength);
                ++j;
            }
            ++i;
        }
        return sequenceTable;
    }

    public static Cell[][] computeTableLS(int[] inputSequenceA, int[] inputSequenceB, double distance, HashMap<String, double[]> distributionOfRegions) throws Exception {
        int j;
        int aIndex = inputSequenceA.length + 1;
        int bIndex = inputSequenceB.length + 1;
        Cell[][] sequenceTable = new Cell[aIndex][bIndex];
        int i = 0;
        while (i < aIndex) {
            j = 0;
            while (j < bIndex) {
                sequenceTable[i][j] = new Cell();
                sequenceTable[0][j].seqLength = 0;
                ++j;
            }
            sequenceTable[i][0].seqLength = 0;
            ++i;
        }
        i = 1;
        while (i < aIndex) {
            j = 1;
            while (j < bIndex) {
                int A = inputSequenceA[i - 1];
                int B = inputSequenceB[j - 1];
                double distanceBetweenAB = LongestCommonSubsequenceForCells.VectorDistance(A, B, distributionOfRegions);
                sequenceTable[i][j].seqLength = distanceBetweenAB <= distance ? sequenceTable[i - 1][j - 1].seqLength + 1 : Math.max(sequenceTable[i][j - 1].seqLength, sequenceTable[i - 1][j].seqLength);
                ++j;
            }
            ++i;
        }
        return sequenceTable;
    }

    public static Cell[][] computeTableLSYing(int[] inputSequenceA, int[] inputSequenceB, HashMap<String, double[]> distributionOfRegions) {
        int j;
        int aIndex = inputSequenceA.length + 1;
        int bIndex = inputSequenceB.length + 1;
        Cell[][] sequenceTable = new Cell[aIndex][bIndex];
        int i = 0;
        while (i < aIndex) {
            j = 0;
            while (j < bIndex) {
                sequenceTable[i][j] = new Cell();
                sequenceTable[0][j].seqLength = 0;
                ++j;
            }
            sequenceTable[i][0].seqLength = 0;
            ++i;
        }
        i = 1;
        while (i < aIndex) {
            j = 1;
            while (j < bIndex) {
                int A = inputSequenceA[i - 1];
                int B = inputSequenceB[j - 1];
                int count = LongestCommonSubsequenceForCells.intersectionOfRoITags(A, B, distributionOfRegions);
                int temp = sequenceTable[i - 1][j - 1].seqLength + count;
                if (temp > sequenceTable[i][j - 1].seqLength && temp > sequenceTable[i - 1][j].seqLength) {
                    sequenceTable[i][j].seqLength = temp;
                    sequenceTable[i][j].ratioA = sequenceTable[i - 1][j - 1].ratioA + (double)count / LongestCommonSubsequenceForCells.countTags(A, distributionOfRegions);
                    sequenceTable[i][j].ratioB = sequenceTable[i - 1][j - 1].ratioB + (double)count / LongestCommonSubsequenceForCells.countTags(B, distributionOfRegions);
                } else if (sequenceTable[i][j - 1].seqLength > sequenceTable[i - 1][j].seqLength) {
                    sequenceTable[i][j].seqLength = sequenceTable[i][j - 1].seqLength;
                    sequenceTable[i][j].ratioA = sequenceTable[i][j - 1].ratioA;
                    sequenceTable[i][j].ratioB = sequenceTable[i][j - 1].ratioB;
                } else {
                    sequenceTable[i][j].seqLength = sequenceTable[i - 1][j].seqLength;
                    sequenceTable[i][j].ratioA = sequenceTable[i - 1][j].ratioA;
                    sequenceTable[i][j].ratioB = sequenceTable[i - 1][j].ratioB;
                }
                ++j;
            }
            ++i;
        }
        return sequenceTable;
    }

    public static double countTags(int A, HashMap<String, double[]> distributionOfRegions) {
        double[] distributionA = distributionOfRegions.get(Integer.toString(A));
        double count = 0.0;
        double[] dArray = distributionA;
        int n = distributionA.length;
        int n2 = 0;
        while (n2 < n) {
            double prob = dArray[n2];
            if (prob != 0.0) {
                count += 1.0;
            }
            ++n2;
        }
        return count;
    }

    public static int intersectionOfRoITags(int A, int B, HashMap<String, double[]> distributionOfRegions) {
        double[] distributionA = distributionOfRegions.get(Integer.toString(A));
        double[] distributionB = distributionOfRegions.get(Integer.toString(B));
        int count = 0;
        int i = 0;
        while (i < distributionA.length) {
            if (distributionA[i] != 0.0 && distributionB[i] != 0.0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static double VectorDistance(int A, int B, HashMap<String, double[]> distributionOfRegions) throws Exception {
        double[] distributionA = distributionOfRegions.get(Integer.toString(A));
        double[] distributionB = distributionOfRegions.get(Integer.toString(B));
        if (distributionA == null || distributionB == null) {
            throw new Exception();
        }
        double distanceAB = LongestCommonSubsequenceForCells.RelativeEntropy(distributionA, distributionB);
        double distanceBA = LongestCommonSubsequenceForCells.RelativeEntropy(distributionB, distributionA);
        return (distanceAB + distanceBA) / 2.0;
    }

    public static double RelativeEntropy(double[] distA, double[] distB) {
        double entropy = 0.0;
        int i = 0;
        while (i < distA.length) {
            entropy += distA[i] * (Math.log(distA[i] / distB[i]) / Math.log(2.0));
            ++i;
        }
        return entropy;
    }

    public static ArrayList<ArrayList<Cell>> backtrackAll(Cell[][] C, int[] inputSequenceA, int[] inputSequenceB, int i, int j, TimeRange[] timeRangeA, TimeRange[] timeRangeB) {
        if (i == 0 || j == 0) {
            return new ArrayList<ArrayList<Cell>>();
        }
        if (inputSequenceA[i - 1] == inputSequenceB[j - 1]) {
            ArrayList<ArrayList<Cell>> R = LongestCommonSubsequenceForCells.backtrackAll(C, inputSequenceA, inputSequenceB, i - 1, j - 1, timeRangeA, timeRangeB);
            ArrayList<ArrayList<Cell>> new_set = new ArrayList<ArrayList<Cell>>();
            for (ArrayList<Cell> Z : R) {
                Cell lastCell = Z.get(Z.size() - 1);
                if (lastCell.timeRangeForUserA == null) {
                    lastCell.timeRangeForUserA = new TimeRange(0, 0);
                }
                if (lastCell.timeRangeForUserB == null) {
                    lastCell.timeRangeForUserB = new TimeRange(0, 0);
                }
                int inputStartSum = 0;
                int inputEndSum = 0;
                int inputAIndex = lastCell.inputAIndex;
                while (inputAIndex < i - 1) {
                    if (timeRangeA[inputAIndex] == null) {
                        inputStartSum += 0;
                        inputEndSum += 0;
                    } else {
                        inputStartSum += timeRangeA[inputAIndex].getStartTime();
                        inputEndSum += timeRangeA[inputAIndex].getEndTime();
                    }
                    ++inputAIndex;
                }
                lastCell.timeRangeForUserA.setStartTime(inputStartSum);
                lastCell.timeRangeForUserA.setEndTime(inputEndSum);
                inputStartSum = 0;
                inputEndSum = 0;
                int inputBIndex = lastCell.inputBIndex;
                while (inputBIndex < j - 1) {
                    if (timeRangeB[inputBIndex] == null) {
                        inputStartSum += 0;
                        inputEndSum += 0;
                    } else {
                        inputStartSum += timeRangeB[inputBIndex].getStartTime();
                        inputEndSum += timeRangeB[inputBIndex].getEndTime();
                    }
                    ++inputBIndex;
                }
                lastCell.timeRangeForUserB.setStartTime(inputStartSum);
                lastCell.timeRangeForUserB.setEndTime(inputEndSum);
                TimeRange ZTimeRangeA = null;
                TimeRange ZTimeRangeB = null;
                if (i - 1 <= timeRangeA.length - 1 && j - 1 <= timeRangeB.length - 1) {
                    ZTimeRangeA = timeRangeA[i - 1];
                    ZTimeRangeB = timeRangeB[j - 1];
                }
                Z.add(new Cell(inputSequenceA[i - 1], i - 1, j - 1, ZTimeRangeA, ZTimeRangeB));
                new_set.add(Z);
            }
            if (R.isEmpty()) {
                ArrayList<Cell> subSequence = new ArrayList<Cell>();
                subSequence.add(new Cell(inputSequenceA[i - 1], i - 1, j - 1, timeRangeA[i - 1], timeRangeB[j - 1]));
                new_set.add(subSequence);
            }
            return new_set;
        }
        ArrayList<ArrayList<Cell>> R = new ArrayList();
        if (C[i][j - 1].seqLength >= C[i - 1][j].seqLength) {
            R = LongestCommonSubsequenceForCells.backtrackAll(C, inputSequenceA, inputSequenceB, i, j - 1, timeRangeA, timeRangeB);
        }
        if (C[i - 1][j].seqLength >= C[i][j - 1].seqLength) {
            R.addAll(LongestCommonSubsequenceForCells.backtrackAll(C, inputSequenceA, inputSequenceB, i - 1, j, timeRangeA, timeRangeB));
        }
        return R;
    }

    public static void printoutSequenceMatrix(Cell[][] sequenceTable, int[] inputSequenceA, int[] inputSequenceB) {
        System.out.println("     " + Arrays.toString(inputSequenceB));
        System.out.println("  " + Arrays.toString(sequenceTable[0]));
        int i = 1;
        while (i < sequenceTable.length) {
            System.out.print(String.valueOf(inputSequenceA[i - 1]) + " ");
            System.out.println(Arrays.toString(sequenceTable[i]));
            ++i;
        }
    }

    public static ArrayList<ArrayList<Cell>> fillInTimeRanges(ArrayList<ArrayList<Cell>> lcSequences, TimeRange[] timeRangeA, TimeRange[] timeRangeB) {
        ArrayList<ArrayList<Cell>> timeAnnotatedLCSequences = new ArrayList<ArrayList<Cell>>(lcSequences);
        for (ArrayList<Cell> LcSequence : timeAnnotatedLCSequences) {
            int index = 1;
            while (index <= LcSequence.size() - 2) {
                ++index;
            }
        }
        return timeAnnotatedLCSequences;
    }

    public static int calcRangeOverlap(int rangeAStart, int rangeAEnd, int rangeBStart, int rangeBEnd) {
        assert (rangeAStart <= rangeAEnd && rangeBStart <= rangeBEnd);
        if (rangeAStart > rangeBStart) {
            int temp = rangeAStart;
            rangeAStart = rangeBStart;
            rangeBStart = temp;
            temp = rangeAEnd;
            rangeAEnd = rangeBEnd;
            rangeBEnd = temp;
        }
        System.out.println("A: " + rangeAStart + "-" + rangeAEnd);
        System.out.println("B: " + rangeBStart + "-" + rangeBEnd);
        if (rangeBEnd <= rangeAEnd) {
            return rangeBEnd - rangeBStart;
        }
        if (rangeAEnd < rangeBStart) {
            return 0;
        }
        return rangeAEnd - rangeBStart;
    }

    public static double calcRangeOverlapFactor(int rangeAStart, int rangeAEnd, int rangeBStart, int rangeBEnd) {
        assert (rangeAStart <= rangeAEnd && rangeBStart <= rangeBEnd);
        if (rangeAStart > rangeBStart) {
            int temp = rangeAStart;
            rangeAStart = rangeBStart;
            rangeBStart = temp;
            temp = rangeAEnd;
            rangeAEnd = rangeBEnd;
            rangeBEnd = temp;
        }
        if (rangeBEnd <= rangeAEnd) {
            if (rangeAEnd - rangeAStart == 0) {
                return 0.0;
            }
            return (double)(rangeBEnd - rangeBStart) / (double)(rangeAEnd - rangeAStart);
        }
        if (rangeAEnd < rangeBStart) {
            return 0.0;
        }
        return (double)(rangeAEnd - rangeBStart) / (double)(rangeBEnd - rangeAStart);
    }

    public static Set<ArrayList<Cell>> purgeNonMaximumLengthPaths(List<ArrayList<Cell>> subSequences) {
        HashSet<ArrayList<Cell>> maximumLengthSequences = new HashSet<ArrayList<Cell>>(subSequences);
        int maxLength = 0;
        for (ArrayList<Cell> sequence : subSequences) {
            if (sequence.size() > maxLength) {
                maxLength = sequence.size();
                continue;
            }
            if (sequence.size() >= maxLength) continue;
            maximumLengthSequences.remove(sequence);
        }
        return maximumLengthSequences;
    }

    public static double calculateAverageOverlapFactorForSingleLCS(ArrayList<Cell> longestCommonSequence, int[] inputASequence, int[] inputBSequence) {
        double numberOfLinksForLCS = longestCommonSequence.size() - 1;
        if (numberOfLinksForLCS == 0.0) {
            return 0.0;
        }
        double overlapfactorSum = 0.0;
        for (Cell cell : longestCommonSequence) {
            TimeRange TimeRangeA = cell.timeRangeForUserA;
            TimeRange TimeRangeB = cell.timeRangeForUserB;
            if (TimeRangeA == null || TimeRangeB == null) continue;
            overlapfactorSum += LongestCommonSubsequenceForCells.calcRangeOverlapFactor(TimeRangeA.getStartTime(), TimeRangeA.getEndTime(), TimeRangeB.getStartTime(), TimeRangeB.getEndTime());
        }
        return overlapfactorSum / numberOfLinksForLCS;
    }

    public static double calculateAverageOverLapFactorForLCSList(Set<ArrayList<Cell>> longestCommonSequences, int[] inputASequence, int[] inputBSequence) {
        double overlapfactorSum = 0.0;
        for (ArrayList<Cell> lcSequence : longestCommonSequences) {
            TimeRange[] TimeRangesForA = LongestCommonSubsequenceForCells.extractTimeRangesForUserAFromCells(lcSequence);
            TimeRange[] TimeRangesForB = LongestCommonSubsequenceForCells.extractTimeRangesForUserBFromCells(lcSequence);
            if (lcSequence.size() == 1 || Arrays.equals(inputASequence, inputBSequence) && LongestCommonSubsequenceForCells.isTimeRangeEmpty(TimeRangesForA) && LongestCommonSubsequenceForCells.isTimeRangeEmpty(TimeRangesForB)) {
                overlapfactorSum += 1.0;
                continue;
            }
            overlapfactorSum += LongestCommonSubsequenceForCells.calculateAverageOverlapFactorForSingleLCS(lcSequence, inputASequence, inputBSequence);
        }
        return overlapfactorSum / (double)longestCommonSequences.size();
    }

    public static double calculatePatternSimularity(Set<ArrayList<Cell>> longestCommonSequences, int[] inputASequence, int[] inputBSequence) {
        if (longestCommonSequences.isEmpty() || inputASequence.length == 0 || inputBSequence.length == 0) {
            return 0.0;
        }
        double lengthOfLCS = longestCommonSequences.iterator().next().size();
        double firstOperand = 2.0 * lengthOfLCS / (double)(inputASequence.length + inputBSequence.length);
        double secondOperand = LongestCommonSubsequenceForCells.calculateAverageOverLapFactorForLCSList(longestCommonSequences, inputASequence, inputBSequence);
        return firstOperand * secondOperand;
    }

    public static double calculatePatternSimularityWithoutTimeOverlap(double lengthOfLCS, int[] inputASequence, int[] inputBSequence) {
        if (inputASequence.length == 0 || inputBSequence.length == 0) {
            return 0.0;
        }
        return 2.0 * lengthOfLCS / (double)(inputASequence.length + inputBSequence.length);
    }

    public static double calculatePatternSimularityWithoutTimeOverlapYing(int[] inputASequence, int[] inputBSequence, HashMap<String, double[]> distributionOfRegions) {
        if (inputASequence.length == 0 || inputBSequence.length == 0) {
            return 0.0;
        }
        Cell[][] table = LongestCommonSubsequenceForCells.computeTableLSYing(inputASequence, inputBSequence, distributionOfRegions);
        return (table[inputASequence.length][inputBSequence.length].ratioA / (double)inputASequence.length + table[inputASequence.length][inputBSequence.length].ratioB / (double)inputBSequence.length) / 2.0;
    }

    public static Set<ArrayList<Cell>> calculateLongestCommonSequences(int[] inputASequence, int[] inputBSequence, TimeRange[] inputATransitionTimes, TimeRange[] inputBTransitionTimes) {
        Cell[][] table = LongestCommonSubsequenceForCells.computeTable(inputASequence, inputBSequence);
        ArrayList<ArrayList<Cell>> lCSequences = LongestCommonSubsequenceForCells.backtrackAll(table, inputASequence, inputBSequence, inputASequence.length, inputBSequence.length, inputATransitionTimes, inputBTransitionTimes);
        return LongestCommonSubsequenceForCells.purgeNonMaximumLengthPaths(lCSequences);
    }

    public static int calculateLCSlength(int[] inputASequence, int[] inputBSequence) {
        Cell[][] table = LongestCommonSubsequenceForCells.computeTable(inputASequence, inputBSequence);
        if (table != null && table[0] != null) {
            return table[inputASequence.length][inputBSequence.length].seqLength;
        }
        return 0;
    }

    public static int calculateLCSlengthLS(int[] inputASequence, int[] inputBSequence, double distance, HashMap<String, double[]> distributionOfRegions) throws Exception {
        Cell[][] table = LongestCommonSubsequenceForCells.computeTableLS(inputASequence, inputBSequence, distance, distributionOfRegions);
        if (table != null && table[0] != null) {
            return table[inputASequence.length][inputBSequence.length].seqLength;
        }
        return 0;
    }

    public static double calculateWeightForInputSequencePair(double supportForInputSequenceA, double supportForInputSequenceB) {
        return (supportForInputSequenceA + supportForInputSequenceB) / 2.0;
    }

    public static double calculateSimularityBetweenTwoUsersVersion1(User userU, User userV) {
        double weightSum = 0.0;
        double weightedSum = 0.0;
        int indexUserU = 0;
        while (indexUserU < userU.inputSequences.size()) {
            int indexUserV = 0;
            while (indexUserV < userV.inputSequences.size()) {
                Set<ArrayList<Cell>> longestCommonSequences = LongestCommonSubsequenceForCells.calculateLongestCommonSequences(userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV), userU.inputSequenceTransitionTimes.get(indexUserU), userV.inputSequenceTransitionTimes.get(indexUserV));
                double weigth = LongestCommonSubsequenceForCells.calculateWeightForInputSequencePair(userU.supportValuesForInputSequences.get(indexUserU), userV.supportValuesForInputSequences.get(indexUserV));
                weightedSum += weigth * LongestCommonSubsequenceForCells.calculatePatternSimularity(longestCommonSequences, userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV));
                weightSum += weigth;
                ++indexUserV;
            }
            ++indexUserU;
        }
        return weightedSum / weightSum;
    }

    public static double calculateSimularityBetweenTwoUsersVersion2(User userU, User userV) {
        double weightSum = 0.0;
        double weightedSum = 0.0;
        int indexUserU = 0;
        while (indexUserU < userU.inputSequences.size()) {
            int indexUserV = 0;
            while (indexUserV < userV.inputSequences.size()) {
                double lengthOfLCS = LongestCommonSubsequenceForCells.calculateLCSlength(userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV));
                double weigth = LongestCommonSubsequenceForCells.calculateWeightForInputSequencePair(userU.supportValuesForInputSequences.get(indexUserU), userV.supportValuesForInputSequences.get(indexUserV));
                weightedSum += weigth * LongestCommonSubsequenceForCells.calculatePatternSimularityWithoutTimeOverlap(lengthOfLCS, userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV));
                weightSum += weigth;
                ++indexUserV;
            }
            ++indexUserU;
        }
        return weightedSum / weightSum;
    }

    public static double calculateSimularityBetweenTwoUsersVersionYing(User userU, User userV, HashMap<String, double[]> distributionOfRegions) {
        double weightSum = 0.0;
        double weightedSum = 0.0;
        int indexUserU = 0;
        while (indexUserU < userU.inputSequences.size()) {
            int indexUserV = 0;
            while (indexUserV < userV.inputSequences.size()) {
                double weigth = LongestCommonSubsequenceForCells.calculateWeightForInputSequencePair(userU.supportValuesForInputSequences.get(indexUserU), userV.supportValuesForInputSequences.get(indexUserV));
                weightedSum += weigth * LongestCommonSubsequenceForCells.calculatePatternSimularityWithoutTimeOverlapYing(userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV), distributionOfRegions);
                weightSum += weigth;
                ++indexUserV;
            }
            ++indexUserU;
        }
        return weightedSum / weightSum;
    }

    public static double calculateSimularityBetweenTwoUsersVersion3(User userU, User userV) {
        double similarityUserUAndUserV = LongestCommonSubsequenceForCells.calculateSimularityBetweenTwoUsersHelperVersion3(userU, userV);
        double similarityUserVAndUserU = LongestCommonSubsequenceForCells.calculateSimularityBetweenTwoUsersHelperVersion3(userV, userU);
        return (similarityUserUAndUserV + similarityUserVAndUserU) / 2.0;
    }

    private static double calculateSimularityBetweenTwoUsersHelperVersion3(User userU, User userV) {
        double weightSum = 0.0;
        double weightedSum = 0.0;
        int indexUserU = 0;
        while (indexUserU < userU.inputSequences.size()) {
            double userSimilarity;
            double weight = LongestCommonSubsequenceForCells.calculateWeightForInputSequencePair(userU.supportValuesForInputSequences.get(indexUserU), userV.supportValuesForInputSequences.get(0));
            Set<ArrayList<Cell>> longestCommonSequences = LongestCommonSubsequenceForCells.calculateLongestCommonSequences(userU.inputSequences.get(indexUserU), userV.inputSequences.get(0), userU.inputSequenceTransitionTimes.get(indexUserU), userV.inputSequenceTransitionTimes.get(0));
            double maxSimilarityValue = userSimilarity = LongestCommonSubsequenceForCells.calculatePatternSimularity(longestCommonSequences, userU.inputSequences.get(indexUserU), userV.inputSequences.get(0));
            double maxSimilarityWeight = weight;
            int indexUserV = 1;
            while (indexUserV < userV.inputSequences.size()) {
                weight = LongestCommonSubsequenceForCells.calculateWeightForInputSequencePair(userU.supportValuesForInputSequences.get(indexUserU), userV.supportValuesForInputSequences.get(indexUserV));
                longestCommonSequences = LongestCommonSubsequenceForCells.calculateLongestCommonSequences(userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV), userU.inputSequenceTransitionTimes.get(indexUserU), userV.inputSequenceTransitionTimes.get(indexUserV));
                userSimilarity = LongestCommonSubsequenceForCells.calculatePatternSimularity(longestCommonSequences, userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV));
                if (userSimilarity > maxSimilarityValue) {
                    maxSimilarityValue = userSimilarity;
                    maxSimilarityWeight = weight;
                }
                ++indexUserV;
            }
            weightedSum += maxSimilarityValue * maxSimilarityWeight;
            weightSum += maxSimilarityWeight;
            ++indexUserU;
        }
        if (weightSum == 0.0 || weightedSum == 0.0) {
            return 0.0;
        }
        return weightedSum / weightSum;
    }

    public static double calculateSimularityBetweenTwoUsersVersion4(User userU, User userV) {
        double similarityUserUAndUserV = LongestCommonSubsequenceForCells.calculateSimularityBetweenTwoUsersHelperVersion4(userU, userV);
        double similarityUserVAndUserU = LongestCommonSubsequenceForCells.calculateSimularityBetweenTwoUsersHelperVersion4(userV, userU);
        return (similarityUserUAndUserV + similarityUserVAndUserU) / 2.0;
    }

    private static double calculateSimularityBetweenTwoUsersHelperVersion4(User userU, User userV) {
        double weightSum = 0.0;
        double weightedSum = 0.0;
        double weight = 0.0;
        int indexUserU = 0;
        while (indexUserU < userU.inputSequences.size()) {
            double lengthOfLCS = 0.0;
            double userSimilarity = 0.0;
            double maxSimilarity = 0.0;
            int indexUserV = 0;
            while (indexUserV < userV.inputSequences.size()) {
                lengthOfLCS = LongestCommonSubsequenceForCells.calculateLCSlength(userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV));
                userSimilarity = LongestCommonSubsequenceForCells.calculatePatternSimularityWithoutTimeOverlap(lengthOfLCS, userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV));
                if (userSimilarity > maxSimilarity) {
                    maxSimilarity = userSimilarity;
                    weight = LongestCommonSubsequenceForCells.calculateWeightForInputSequencePair(userU.supportValuesForInputSequences.get(indexUserU), userV.supportValuesForInputSequences.get(indexUserV));
                }
                ++indexUserV;
            }
            weightedSum += maxSimilarity * weight;
            weightSum += weight;
            ++indexUserU;
        }
        if (weightSum == 0.0 || weightedSum == 0.0) {
            return 0.0;
        }
        return weightedSum / weightSum;
    }

    public static double calculateSimularityBetweenTwoUsersVersion5(User userU, User userV) {
        double simUV = LongestCommonSubsequenceForCells.similarity2users(userU, userV);
        double simVU = LongestCommonSubsequenceForCells.similarity2users(userV, userU);
        return (simUV + simVU) / 2.0;
    }

    private static double similarity2users(User userU, User userV) {
        double weightSum = 0.0;
        double weightedSum = 0.0;
        double weight = 0.0;
        double maxSimilarity = 0.0;
        int indexUserU = 0;
        while (indexUserU < userU.inputSequences.size()) {
            int lengthOfLCS = 0;
            maxSimilarity = 0.0;
            int indexUserV = 0;
            while (indexUserV < userV.inputSequences.size()) {
                lengthOfLCS = LongestCommonSubsequenceForCells.calculateLCSlength(userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV));
                double userSimilarity = LongestCommonSubsequenceForCells.calculatePatternSimularityWithoutTimeOverlap(lengthOfLCS, userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV));
                if (userSimilarity >= maxSimilarity) {
                    maxSimilarity = userSimilarity;
                    weight = LongestCommonSubsequenceForCells.calculateWeightForInputSequencePair(userU.supportValuesForInputSequences.get(indexUserU), userV.supportValuesForInputSequences.get(indexUserV));
                }
                ++indexUserV;
            }
            weightedSum += maxSimilarity * weight;
            weightSum += weight;
            ++indexUserU;
        }
        if (weightSum == 0.0 || weightedSum == 0.0) {
            return 0.0;
        }
        return weightedSum / weightSum;
    }

    public static double calculateSimularityBetweenTwoUsersVersion5Ying(User userU, User userV, HashMap<String, double[]> distributionOfRegions) {
        double simUV = LongestCommonSubsequenceForCells.similarity2usersYing(userU, userV, distributionOfRegions);
        double simVU = LongestCommonSubsequenceForCells.similarity2usersYing(userV, userU, distributionOfRegions);
        return (simUV + simVU) / 2.0;
    }

    private static double similarity2usersYing(User userU, User userV, HashMap<String, double[]> distributionOfRegions) {
        double weightSum = 0.0;
        double weightedSum = 0.0;
        double weight = 0.0;
        double maxSimilarity = 0.0;
        int indexUserU = 0;
        while (indexUserU < userU.inputSequences.size()) {
            maxSimilarity = 0.0;
            int indexUserV = 0;
            while (indexUserV < userV.inputSequences.size()) {
                double userSimilarity = LongestCommonSubsequenceForCells.calculatePatternSimularityWithoutTimeOverlapYing(userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV), distributionOfRegions);
                if (userSimilarity >= maxSimilarity) {
                    maxSimilarity = userSimilarity;
                    weight = LongestCommonSubsequenceForCells.calculateWeightForInputSequencePair(userU.supportValuesForInputSequences.get(indexUserU), userV.supportValuesForInputSequences.get(indexUserV));
                }
                ++indexUserV;
            }
            weightedSum += maxSimilarity * weight;
            weightSum += weight;
            ++indexUserU;
        }
        if (weightSum == 0.0 || weightedSum == 0.0) {
            return 0.0;
        }
        return weightedSum / weightSum;
    }

    public static double userSimilarityWithLocationSemantics(User userU, User userV, double distance, HashMap<String, double[]> distributionOfRegions) throws Exception {
        double simUV = LongestCommonSubsequenceForCells.similarity2usersLS(userU, userV, distance, distributionOfRegions);
        double simVU = LongestCommonSubsequenceForCells.similarity2usersLS(userV, userU, distance, distributionOfRegions);
        return (simUV + simVU) / 2.0;
    }

    private static double similarity2usersLS(User userU, User userV, double distance, HashMap<String, double[]> distributionOfRegions) throws Exception {
        double weightSum = 0.0;
        double weightedSum = 0.0;
        double weight = 0.0;
        int indexUserU = 0;
        while (indexUserU < userU.inputSequences.size()) {
            double lengthOfLCS = 0.0;
            double userSimilarity = 0.0;
            double maxSimilarity = 0.0;
            int indexUserV = 0;
            while (indexUserV < userV.inputSequences.size()) {
                lengthOfLCS = LongestCommonSubsequenceForCells.calculateLCSlengthLS(userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV), distance, distributionOfRegions);
                userSimilarity = LongestCommonSubsequenceForCells.calculatePatternSimularityWithoutTimeOverlap(lengthOfLCS, userU.inputSequences.get(indexUserU), userV.inputSequences.get(indexUserV));
                if (userSimilarity >= maxSimilarity) {
                    maxSimilarity = userSimilarity;
                    weight = LongestCommonSubsequenceForCells.calculateWeightForInputSequencePair(userU.supportValuesForInputSequences.get(indexUserU), userV.supportValuesForInputSequences.get(indexUserV));
                }
                ++indexUserV;
            }
            weightedSum += maxSimilarity * weight;
            weightSum += weight;
            ++indexUserU;
        }
        if (weightSum == 0.0 || weightedSum == 0.0) {
            return 0.0;
        }
        return weightedSum / weightSum;
    }

    private static boolean isTimeRangeEmpty(TimeRange[] timeRange) {
        TimeRange[] timeRangeArray = timeRange;
        int n = timeRange.length;
        int n2 = 0;
        while (n2 < n) {
            TimeRange tr = timeRangeArray[n2];
            if (tr != null && tr.getStartTime() != 0 && tr.getEndTime() != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static TimeRange[] extractTimeRangesForUserAFromCells(ArrayList<Cell> cells) {
        TimeRange[] timeRanges = new TimeRange[cells.size()];
        int index = 0;
        for (Cell cell : cells) {
            timeRanges[index++] = cell.timeRangeForUserB;
        }
        return timeRanges;
    }

    private static TimeRange[] extractTimeRangesForUserBFromCells(ArrayList<Cell> cells) {
        TimeRange[] timeRanges = new TimeRange[cells.size()];
        int index = 0;
        for (Cell cell : cells) {
            timeRanges[index++] = cell.timeRangeForUserB;
        }
        return timeRanges;
    }
}

