/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.roi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.utils.TextPaneWorker;
import lu.uni.minus.utils.roi.Cluster;
import lu.uni.minus.utils.roi.DataPoint;
import lu.uni.minus.utils.roi.LOF;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPClusteringWorker
extends TextPaneWorker {
    private final DataSet dataset;
    private final List<String> users;
    private int done;
    private final int percentage;
    private final int lowerK;
    private final int upperK;
    private double minLatitude = Double.MAX_VALUE;
    private double minLongitude = Double.MAX_VALUE;
    private double maxLatitude = Double.MIN_VALUE;
    private double maxLongitude = Double.MIN_VALUE;
    private final String selectedPara;

    public SPClusteringWorker(DataSet ds, List<String> aUsers, int aPercentage, int aLowerK, int aUpperK, String aSelectedPara) {
        this.dataset = ds;
        this.users = aUsers;
        this.percentage = aPercentage;
        this.lowerK = aLowerK;
        this.upperK = aUpperK;
        this.selectedPara = aSelectedPara;
    }

    @Override
    protected Integer doInBackground() throws Exception {
        Instances wekaDataset;
        List<DataPoint> dataPoints = this.loadData();
        if (dataPoints != null && (dataPoints = this.removeOutliersUsingLOF(wekaDataset = this.toWekaFormat(dataPoints))) != null) {
            this.publish(this.formatMessage("Clustering GPS points."));
            List<Cluster> clusters = this.cluster(150, dataPoints);
            this.publish(this.formatOK("The number of clusters is: " + clusters.size() + "\n"));
            clusters = this.multiPointClusters(clusters);
            if (clusters != null) {
                int noRoI = clusters.size();
                this.publish(this.formatOK("The number of clusters that contain more than one point each is:" + noRoI + "\n"));
                if (noRoI > 0) {
                    StringBuilder sbStats = new StringBuilder();
                    sbStats.append(String.valueOf(this.minLatitude) + "\n" + this.minLongitude + "\n" + this.maxLatitude + "\n" + this.maxLongitude + "\n" + clusters.size());
                    this.outputRegionFromCluster(clusters, sbStats.toString());
                    this.publish(this.formatOK("Done."));
                } else {
                    this.publish(this.formatMessage("There are no valid RoI to output"));
                }
                this.setProgress(100);
                return new Integer(0);
            }
        }
        return new Integer(-1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DataPoint> loadData() {
        this.done = 0;
        this.setProgress(this.done);
        ArrayList<DataPoint> result = new ArrayList<DataPoint>();
        this.publish(this.formatMessage("Reading source data..."));
        int i = 0;
        try {
            for (String user : this.users) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(this.dataset.getSPFile(this.selectedPara, user)));
                while ((line = br.readLine()) != null) {
                    String[] fields = line.split(" ");
                    int j = 0;
                    while (j < Integer.parseInt(fields[1])) {
                        double lat = Double.parseDouble(fields[4 + 3 * j]);
                        double lngt = Double.parseDouble(fields[5 + 3 * j]);
                        result.add(new DataPoint(lat, lngt));
                        if (lat < this.minLatitude) {
                            this.minLatitude = lat;
                        }
                        if (lat > this.maxLatitude) {
                            this.maxLatitude = lat;
                        }
                        if (lngt < this.minLongitude) {
                            this.minLongitude = lngt;
                        }
                        if (lngt > this.maxLongitude) {
                            this.maxLongitude = lngt;
                        }
                        ++j;
                    }
                }
                br.close();
                if (this.isCancelled()) {
                    this.publish(this.formatError("Cancelled"));
                    return null;
                }
                this.done = 10 * ++i / this.users.size();
                this.setProgress(this.done);
            }
            this.publish(this.formatOK("Finished reading data. Number of loaded GPS points: " + result.size()));
            this.done = 10;
            this.setProgress(this.done);
            return result;
        }
        catch (FileNotFoundException e) {
            this.publish(this.formatError(e.getMessage()));
            return null;
        }
        catch (NumberFormatException e) {
            this.publish(this.formatError(e.getMessage()));
            return null;
        }
        catch (IOException e) {
            this.publish(this.formatError(e.getMessage()));
        }
        return null;
    }

    private Instances toWekaFormat(List<DataPoint> dataPoints) {
        ArrayList<Attribute> att = new ArrayList<Attribute>();
        att.add(new Attribute("Latitude"));
        att.add(new Attribute("Longitude"));
        Instances result = new Instances("generatedByMinUS", att, dataPoints.size());
        for (DataPoint point : dataPoints) {
            double[] values = new double[]{point.getLatitude(), point.getLongitude()};
            DenseInstance inst = new DenseInstance(1.0, values);
            inst.setDataset(result);
            result.add(inst);
        }
        ++this.done;
        this.setProgress(this.done);
        return result;
    }

    private List<DataPoint> removeOutliersUsingLOF(Instances wekaDataset) {
        this.publish(this.formatMessage("Removing outliers."));
        ArrayList<DataPoint> result = new ArrayList<DataPoint>();
        LOF lofFilter = new LOF(this);
        lofFilter.setMinPointsLowerBound(new Integer(this.lowerK).toString());
        lofFilter.setMinPointsUpperBound(new Integer(this.upperK).toString());
        try {
            lofFilter.setInputFormat(wekaDataset);
            Instances resultInstances = null;
            resultInstances = Filter.useFilter(wekaDataset, lofFilter);
            for (Instance instance : resultInstances) {
                result.add(new DataPoint(instance.value(0), instance.value(1), instance.value(2)));
            }
            Collections.sort(result, new Comparator<DataPoint>(){

                @Override
                public int compare(DataPoint o1, DataPoint o2) {
                    return Double.compare(o1.LOF, o2.LOF);
                }
            });
            int deleteIndex = Math.round((float)(result.size() * (100 - this.percentage)) * 0.01f);
            while (deleteIndex < result.size() && ((DataPoint)result.get((int)deleteIndex)).LOF < 1.0) {
                ++deleteIndex;
            }
            if (deleteIndex < result.size()) {
                result.subList(deleteIndex, result.size()).clear();
            }
            this.publish(this.formatOK("Removed outliers. Remaining GPS points:" + result.size()));
            this.done = 30;
            this.setProgress(this.done);
            return result;
        }
        catch (Exception e) {
            this.publish(this.formatError(e.getMessage()));
            return null;
        }
    }

    private List<Cluster> cluster(int minStopDist, List<DataPoint> dataPoints) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        int clusterIDCountr = 0;
        for (DataPoint dataPoint : dataPoints) {
            HashSet<DataPoint> clusterPoints = new HashSet<DataPoint>();
            clusterPoints.add(dataPoint);
            clusters.add(new Cluster(clusterIDCountr++, dataPoint));
        }
        double doneIn = Double.MAX_VALUE;
        int estimate = 0;
        while (true) {
            double minDistance = Double.MAX_VALUE;
            Cluster clusterWithMinDistanceSource = null;
            Cluster clusterWithMinDistanceTarget = null;
            double currentDistance = 0.0;
            for (Cluster sourceCluster : clusters) {
                for (Cluster targetCluster : clusters) {
                    if (sourceCluster == targetCluster || !((currentDistance = SPClusteringWorker.euclidianDistance(sourceCluster.getCentroid(), targetCluster.getCentroid())) <= minDistance)) continue;
                    minDistance = currentDistance;
                    clusterWithMinDistanceSource = sourceCluster;
                    clusterWithMinDistanceTarget = targetCluster;
                }
                if (!this.isCancelled()) continue;
                this.publish(this.formatError("Cancelled"));
                return null;
            }
            double mindistanceInMeters = SPClusteringWorker.greatCircleDistance(clusterWithMinDistanceSource.getCentroid(), clusterWithMinDistanceTarget.getCentroid());
            if (estimate == 0) {
                estimate = (int)((double)minStopDist - mindistanceInMeters);
            }
            doneIn = Math.min(doneIn, (double)minStopDist - mindistanceInMeters);
            this.done = (int)(31.0 + (1.0 - doneIn / (double)estimate) * 68.0);
            this.setProgress(Math.max(0, Math.min(this.done, 100)));
            if (mindistanceInMeters >= (double)minStopDist) {
                return clusters;
            }
            if (clusterWithMinDistanceSource == null || clusterWithMinDistanceTarget == null) continue;
            clusterWithMinDistanceSource.addPoints(clusterWithMinDistanceTarget);
            clusters.remove(clusterWithMinDistanceTarget);
        }
    }

    private static double euclidianDistance(DataPoint pt1, DataPoint pt2) {
        double diffLat = pt1.getLatitude() - pt2.getLatitude();
        double diffLong = pt1.getLongitude() - pt2.getLongitude();
        return Math.sqrt(Math.pow(diffLat, 2.0) + Math.pow(diffLong, 2.0));
    }

    private static double greatCircleDistance(DataPoint pt1, DataPoint pt2) {
        double a_x_point = pt1.getLatitude();
        double a_y_point = pt1.getLongitude();
        double b_x_point = pt2.getLatitude();
        double b_y_point = pt2.getLongitude();
        Double R = new Double(6371.0);
        Double dlat = (b_x_point - a_x_point) * Math.PI / 180.0;
        Double dlon = (b_y_point - a_y_point) * Math.PI / 180.0;
        Double aDouble = Math.sin(dlat / 2.0) * Math.sin(dlat / 2.0) + Math.cos(a_x_point * Math.PI / 180.0) * Math.cos(b_x_point * Math.PI / 180.0) * Math.sin(dlon / 2.0) * Math.sin(dlon / 2.0);
        Double cDouble = 2.0 * Math.atan2(Math.sqrt(aDouble), Math.sqrt(1.0 - aDouble));
        double d = R * cDouble * 1000.0;
        return d;
    }

    private void outputRegionFromCluster(List<Cluster> clusters, String stats) {
        this.publish(this.formatMessage("Outputing RoIs...\n"));
        StringBuilder sb = new StringBuilder();
        HashMap<Integer, DataPoint> minLatLongs = new HashMap<Integer, DataPoint>();
        HashMap<Integer, DataPoint> maxLatLongs = new HashMap<Integer, DataPoint>();
        HashMap<Integer, Integer> numberOfPointsInCluster = new HashMap<Integer, Integer>();
        HashSet<Integer> clusterIDs = new HashSet<Integer>();
        for (Cluster cluster : clusters) {
            clusterIDs.add(cluster.id);
            minLatLongs.put(cluster.id, cluster.getMinPoint());
            maxLatLongs.put(cluster.id, cluster.getMaxPoint());
            numberOfPointsInCluster.put(cluster.id, cluster.clusterPoints.size());
        }
        StringBuilder sb2 = new StringBuilder();
        int i = 0;
        while (i < this.users.size()) {
            if (i == this.users.size() - 1) {
                sb2.append(this.users.get(i));
            } else {
                sb2.append(String.valueOf(this.users.get(i)) + "_");
            }
            ++i;
        }
        sb2.append("-" + this.percentage + "_" + this.lowerK + "_" + this.upperK + ".txt");
        String fileName = sb2.toString();
        BufferedWriter bw = null;
        File outputFolder = this.dataset.createRoIDir(this.selectedPara);
        try {
            bw = new BufferedWriter(new FileWriter(new File(outputFolder + "/" + fileName)));
            int clusterRanking = 0;
            Iterator iterator = clusterIDs.iterator();
            while (iterator.hasNext()) {
                int clusterID = (Integer)iterator.next();
                sb.append(clusterRanking++);
                sb.append(" ");
                double minLatitudeThisCluster = ((DataPoint)minLatLongs.get(clusterID)).getLatitude();
                sb.append(minLatitudeThisCluster);
                sb.append(" ");
                double minLongitudeThisCluster = ((DataPoint)minLatLongs.get(clusterID)).getLongitude();
                sb.append(minLongitudeThisCluster);
                sb.append(" ");
                double maxLatitudeThisCluster = ((DataPoint)maxLatLongs.get(clusterID)).getLatitude();
                sb.append(maxLatitudeThisCluster);
                sb.append(" ");
                double maxLongitudeThisCluster = ((DataPoint)maxLatLongs.get(clusterID)).getLongitude();
                sb.append(maxLongitudeThisCluster);
                sb.append("\n");
            }
            bw.write(sb.toString().trim());
            bw.close();
            this.publish(this.formatOK("Finished outputing RoIs...\n"));
        }
        catch (IOException e1) {
            this.publish(this.formatError(e1.getMessage()));
        }
        this.publish(this.formatMessage("Outputing stats of the RoIs..."));
        File statOutputFolder = this.dataset.createStatRoIDir(this.selectedPara);
        try {
            bw = new BufferedWriter(new FileWriter(statOutputFolder + "/" + fileName));
            bw.write(stats);
            bw.close();
            this.publish(this.formatOK("Finished outputing stats of the RoIs...\n"));
        }
        catch (IOException e1) {
            this.publish(this.formatError(e1.getMessage()));
        }
    }

    public List<Cluster> multiPointClusters(List<Cluster> clusters) {
        ArrayList<Cluster> multiPointClusters = new ArrayList<Cluster>();
        for (Cluster cluster : clusters) {
            if (cluster.clusterPoints.size() <= 1) continue;
            multiPointClusters.add(cluster);
        }
        return multiPointClusters;
    }

    @Override
    protected void process(List<String> chunks) {
        for (String string : chunks) {
            this.addMessage(string);
        }
    }
}

