/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.sp;

public class GPSPoint {
    private final double radiusOfEarth = 6372.8;
    private double latitude;
    private double longitude;
    private int time;
    private String date;

    public GPSPoint(double aLatitude, double aLongitude, int aTime, String aDate) {
        this.latitude = aLatitude;
        this.longitude = aLongitude;
        this.time = aTime;
        this.date = aDate;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double aLatitude) {
        this.latitude = aLatitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double aLongitude) {
        this.longitude = aLongitude;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int aTime) {
        this.time = aTime;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String aDate) {
        this.date = aDate;
    }

    public double distanceTo(GPSPoint point2) {
        double longitudeOfPoint1 = this.longitude;
        double latitudeOfPoint2 = point2.getLatitude();
        double longitudeOfPoint2 = point2.getLongitude();
        double radianOfLatitudeDifference = Math.toRadians(latitudeOfPoint2 - this.latitude);
        double radianOfLongitudeDifference = Math.toRadians(longitudeOfPoint2 - longitudeOfPoint1);
        double part1 = Math.sin(radianOfLatitudeDifference / 2.0);
        double part2 = Math.sin(radianOfLongitudeDifference / 2.0);
        double part3 = part1 * part1 + Math.cos(Math.toRadians(this.latitude)) * Math.cos(Math.toRadians(latitudeOfPoint2)) * part2 * part2;
        double distance = 2.0 * Math.asin(Math.sqrt(part3)) * 6372.8 * 1000.0;
        return distance;
    }
}

