/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.sp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.utils.TextPaneWorker;
import lu.uni.minus.utils.UserStatistics;
import lu.uni.minus.utils.sp.GPSPoint;
import lu.uni.minus.utils.sp.StayPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPDetectWorker
extends TextPaneWorker {
    private final DataSet dataset;
    private final ArrayList<String> users;
    private int estimate;
    private final String distance;
    private final double distanceDouble;
    private final String time;
    private final double timeDouble;
    private final String merge;
    private final double mergeDouble;
    private int done;

    public SPDetectWorker(DataSet ds, ArrayList<String> aUsers, String distance, String time, String merge) {
        this.dataset = ds;
        this.users = aUsers;
        this.distance = distance;
        this.distanceDouble = Double.parseDouble(distance);
        this.time = time;
        this.timeDouble = Double.parseDouble(time);
        this.merge = merge;
        this.mergeDouble = Double.parseDouble(merge);
    }

    @Override
    protected Integer doInBackground() throws Exception {
        this.done = 0;
        this.estimate = this.estimateWork();
        this.setProgress(0);
        this.doAllUsers();
        this.setProgress(100);
        return new Integer(0);
    }

    private int estimateWork() {
        this.publish(this.formatMessage("Estimating needed time."));
        int result = 0;
        for (String user : this.users) {
            result += this.dataset.getUserInDir(user).list().length;
        }
        return result;
    }

    private void doAllUsers() {
        StringBuilder sb = new StringBuilder();
        for (String user : this.users) {
            UserStatistics stat = this.doUser(user);
            if (stat == null) {
                this.publish(this.formatError("Cancelled."));
                return;
            }
            sb.append(stat.toString());
        }
        try {
            File statOutDir = this.dataset.createOutputSPDir();
            BufferedWriter bw = new BufferedWriter(new FileWriter(statOutDir + File.separator + "StayPoints-" + this.distance + "_" + this.time + "_" + this.merge + ".txt", true));
            bw.write(sb.toString());
            bw.close();
            this.publish(this.formatOK("Done"));
        }
        catch (IOException e) {
            this.publish(this.formatError("Problem writing stats:" + e.getMessage()));
        }
    }

    private UserStatistics doUser(String user) {
        this.setProgress(100 * this.done / this.estimate);
        UserStatistics result = new UserStatistics();
        result.setUserID(user);
        TreeMap fileMap = new TreeMap();
        this.publish(this.formatMessage("Processing files of the user: \"" + user + "\"\n"));
        String[] stringArray = this.dataset.getUserInDir(user).list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            String date = file.substring(0, 8);
            if (fileMap.containsKey(date)) {
                ((ArrayList)fileMap.get(date)).add(file);
            } else {
                ArrayList<String> fileList = new ArrayList<String>();
                fileList.add(file);
                fileMap.put(date, fileList);
            }
            ++n2;
        }
        result.setNumberOfDays(fileMap.size());
        Set days = fileMap.keySet();
        Iterator itr = days.iterator();
        ArrayList<ArrayList<StayPoint>> allSP = new ArrayList<ArrayList<StayPoint>>();
        while (itr.hasNext()) {
            ArrayList fileList;
            String date = (String)itr.next();
            ArrayList<StayPoint> dateSP = this.doDate(date, fileList = (ArrayList)fileMap.get(date), user, result);
            if (dateSP == null) {
                return null;
            }
            allSP.add(dateSP);
            this.done += fileList.size();
            this.setProgress(100 * this.done / this.estimate);
        }
        StringBuilder sb = new StringBuilder();
        Iterator spIterator = allSP.iterator();
        for (String date : fileMap.keySet()) {
            sb.append(String.valueOf(date) + " ");
            ArrayList spDay = (ArrayList)spIterator.next();
            sb.append(String.valueOf(spDay.size()) + " " + this.getWeekBit(date) + " ");
            for (StayPoint staypoint : spDay) {
                sb.append(String.valueOf(staypoint.getArrivalTime()) + " " + staypoint.getLatitude() + " " + staypoint.getLongitude() + " ");
            }
            sb.append("\n");
        }
        File spOutDir = this.dataset.createSPDir(this.distance, this.time, this.merge);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(spOutDir + File.separator + user + ".txt"));
            bw.write(sb.toString());
            bw.close();
        }
        catch (IOException e) {
            this.publish(this.formatError(e.getMessage()));
        }
        return result;
    }

    private ArrayList<StayPoint> doDate(String date, ArrayList<String> fileList, String user, UserStatistics stat) {
        ArrayList<GPSPoint> gpsPoints = new ArrayList<GPSPoint>();
        for (String file : fileList) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(new File(this.dataset.getUserInDir(user) + File.separator + file)));
                int k = 0;
                while (k < 6) {
                    br.readLine();
                    ++k;
                }
                while ((line = br.readLine()) != null) {
                    String[] fields = line.split(",");
                    double lat = Double.parseDouble(fields[0]);
                    double lon = Double.parseDouble(fields[1]);
                    String[] time = fields[6].split(":");
                    int abstime = Integer.parseInt(time[0]) * 3600 + Integer.parseInt(time[1]) * 60 + Integer.parseInt(time[2]);
                    gpsPoints.add(new GPSPoint(lat, lon, abstime, date));
                }
                br.close();
                if (!this.isCancelled()) continue;
                return null;
            }
            catch (FileNotFoundException e) {
                this.publish(this.formatError(e.getMessage()));
            }
            catch (IOException e) {
                this.publish(this.formatError(e.getMessage()));
            }
        }
        ArrayList<StayPoint> result = this.detectStayPoints(gpsPoints);
        stat.setNumberOfPoints(stat.getNumberOfPoints() + result.size());
        if (stat.getMaxNumberOfPointsInADay() < result.size()) {
            stat.setMaxNumberOfPointsInADay(result.size());
        }
        if (stat.getMinNumberOfPointsInADay() > result.size()) {
            stat.setMinNumberOfPointsInADay(result.size());
        }
        this.publish(this.formatOK("Calculated " + result.size() + " staypoints for the date \"" + this.pretty(date) + "\"."));
        return result;
    }

    private ArrayList<StayPoint> detectStayPoints(ArrayList<GPSPoint> gpsPoints) {
        ArrayList<StayPoint> result = new ArrayList<StayPoint>();
        if (gpsPoints.size() > 0) {
            int index = 0;
            GPSPoint lP = gpsPoints.get(index);
            int within = this.withinDistance(lP, index, gpsPoints);
            result.add(this.averageSP(index, within, gpsPoints));
            int lastAdded = within;
            while (index < gpsPoints.size()) {
                double timeInter;
                lP = gpsPoints.get(index);
                within = this.withinDistance(lP, index, gpsPoints);
                if (within > 0 && (timeInter = (double)(gpsPoints.get(index + within).getTime() - gpsPoints.get(index).getTime())) > this.timeDouble) {
                    result.add(this.averageSP(index, index + within, gpsPoints));
                    lastAdded = index + within;
                }
                index = index + within + 1;
            }
            if (lastAdded < gpsPoints.size() - 1) {
                index = gpsPoints.size() - 1;
                while (index > lastAdded && gpsPoints.get(index).distanceTo(gpsPoints.get(gpsPoints.size() - 1)) < this.distanceDouble) {
                    --index;
                }
                result.add(this.averageSP(index, gpsPoints.size() - 1, gpsPoints));
            }
            this.mergeStayPoints(result);
        }
        return result;
    }

    private StayPoint averageSP(int lower, int upper, ArrayList<GPSPoint> gpsPoints) {
        StayPoint s = new StayPoint(gpsPoints.get(lower));
        double latsum = 0.0;
        double lngtsum = 0.0;
        int numofpoints = upper - lower + 1;
        int k = lower;
        while (k <= upper) {
            GPSPoint cur = gpsPoints.get(k);
            latsum += cur.getLatitude();
            lngtsum += cur.getLongitude();
            ++k;
        }
        s.setLatitude(latsum / (double)numofpoints);
        s.setLongitude(lngtsum / (double)numofpoints);
        s.setLeavingTime(gpsPoints.get(upper).getTime());
        return s;
    }

    private int withinDistance(GPSPoint p, int index, ArrayList<GPSPoint> gpsPoints) {
        int result = 0;
        while (index + result + 1 < gpsPoints.size() && gpsPoints.get(index).distanceTo(gpsPoints.get(index + result + 1)) < this.distanceDouble) {
            ++result;
        }
        return result;
    }

    private String getWeekBit(String date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        try {
            df.parse(date);
        }
        catch (ParseException e) {
            this.publish(this.formatError(e.getMessage()));
        }
        int dayOfWeek = df.getCalendar().get(7);
        if (dayOfWeek < 6) {
            return "1";
        }
        return "0";
    }

    private void mergeStayPoints(ArrayList<StayPoint> staypoints) {
        int last = staypoints.size() - 1;
        if (staypoints.size() == 2) {
            if (staypoints.get(0).distanceTo(staypoints.get(last)) < this.mergeDouble) {
                StayPoint s = staypoints.get(0).merge(staypoints.get(last));
                staypoints.clear();
                staypoints.add(s);
            }
        } else if (staypoints.size() == 3) {
            StayPoint s;
            if (staypoints.get(0).distanceTo(staypoints.get(1)) < this.mergeDouble) {
                s = staypoints.get(0).merge(staypoints.get(1));
                staypoints.set(0, s);
                staypoints.remove(1);
                last = staypoints.size() - 1;
            } else if (staypoints.get(1).distanceTo(staypoints.get(last)) < this.mergeDouble) {
                s = staypoints.get(1).merge(staypoints.get(last));
                staypoints.set(last, s);
                staypoints.remove(1);
                last = staypoints.size() - 1;
            }
            if (staypoints.size() == 2 && staypoints.get(0).distanceTo(staypoints.get(last)) < this.mergeDouble) {
                s = staypoints.get(0).merge(staypoints.get(last));
                staypoints.clear();
                staypoints.add(s);
            }
        } else if (staypoints.size() > 3) {
            StayPoint s;
            if (staypoints.get(0).distanceTo(staypoints.get(1)) < this.mergeDouble) {
                s = staypoints.get(0).merge(staypoints.get(1));
                staypoints.set(0, s);
                staypoints.remove(1);
                last = staypoints.size() - 1;
            }
            if (staypoints.get(last - 1).distanceTo(staypoints.get(last)) < this.mergeDouble) {
                s = staypoints.get(last - 1).merge(staypoints.get(last));
                staypoints.set(last - 1, s);
                staypoints.remove(last);
            }
        }
    }

    private String pretty(String date) {
        if (date.length() == 8) {
            return String.valueOf(date.substring(0, 4)) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8);
        }
        return date;
    }

    @Override
    protected void process(List<String> chunks) {
        for (String string : chunks) {
            this.addMessage(string);
        }
    }
}

