/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.sp;

import lu.uni.minus.utils.sp.GPSPoint;

public class StayPoint {
    private double latitude;
    private double longitude;
    private int arrivalTime;
    private int leavingTime;
    private String date;

    public StayPoint() {
    }

    public StayPoint(GPSPoint gpsPoint) {
        this.latitude = gpsPoint.getLatitude();
        this.longitude = gpsPoint.getLongitude();
        this.arrivalTime = gpsPoint.getTime();
        this.leavingTime = gpsPoint.getTime();
        this.date = gpsPoint.getDate();
    }

    public StayPoint(double someLatitude, double someLongitude, int someArrivalTime, int someLeavingTime, String someDate) {
        this.latitude = someLatitude;
        this.longitude = someLongitude;
        this.arrivalTime = someArrivalTime;
        this.leavingTime = someLeavingTime;
        this.date = someDate;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double aLatitude) {
        this.latitude = aLatitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double aLongitude) {
        this.longitude = aLongitude;
    }

    public int getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(int anArrivalTime) {
        this.arrivalTime = anArrivalTime;
    }

    public int getLeavingTime() {
        return this.leavingTime;
    }

    public void setLeavingTime(int aLeavingTime) {
        this.leavingTime = aLeavingTime;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String aDate) {
        this.date = aDate;
    }

    public double distanceTo(StayPoint point2) {
        double radiusOfEarth = 6372.8;
        double latitudeOfPoint1 = this.latitude;
        double longitudeOfPoint1 = this.longitude;
        double latitudeOfPoint2 = point2.getLatitude();
        double longitudeOfPoint2 = point2.getLongitude();
        double radianOfLatitudeDifference = Math.toRadians(latitudeOfPoint2 - latitudeOfPoint1);
        double radianOfLongitudeDifference = Math.toRadians(longitudeOfPoint2 - longitudeOfPoint1);
        double part1 = Math.sin(radianOfLatitudeDifference / 2.0);
        double part2 = Math.sin(radianOfLongitudeDifference / 2.0);
        double part3 = part1 * part1 + Math.cos(Math.toRadians(latitudeOfPoint1)) * Math.cos(Math.toRadians(latitudeOfPoint2)) * part2 * part2;
        double distance = 2.0 * Math.asin(Math.sqrt(part3)) * 6372.8 * 1000.0;
        return distance;
    }

    public StayPoint merge(StayPoint point) {
        double lat = (this.latitude + point.getLatitude()) / 2.0;
        double lon = (this.longitude + point.getLongitude()) / 2.0;
        int arriveTime = this.arrivalTime <= point.getArrivalTime() ? this.arrivalTime : point.getArrivalTime();
        int leaveTime = this.leavingTime <= point.getLeavingTime() ? point.getLeavingTime() : this.leavingTime;
        return new StayPoint(lat, lon, arriveTime, leaveTime, this.date);
    }
}

