/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.domain.TitledResourceReference;

public class TOCReference
extends TitledResourceReference
implements Serializable {
    private static final long serialVersionUID = 5787958246077042456L;
    private List<TOCReference> children;
    private static final Comparator<TOCReference> COMPARATOR_BY_TITLE_IGNORE_CASE = new Comparator<TOCReference>(){

        @Override
        public int compare(TOCReference tocReference1, TOCReference tocReference2) {
            return String.CASE_INSENSITIVE_ORDER.compare(tocReference1.getTitle(), tocReference2.getTitle());
        }
    };

    public TOCReference() {
        this((String)null, (Resource)null, (String)null);
    }

    public TOCReference(String name, Resource resource) {
        this(name, resource, null);
    }

    public TOCReference(String name, Resource resource, String fragmentId) {
        this(name, resource, fragmentId, new ArrayList<TOCReference>());
    }

    public TOCReference(String title, Resource resource, String fragmentId, List<TOCReference> children) {
        super(resource, title, fragmentId);
        this.children = children;
    }

    public static Comparator<TOCReference> getComparatorByTitleIgnoreCase() {
        return COMPARATOR_BY_TITLE_IGNORE_CASE;
    }

    public List<TOCReference> getChildren() {
        return this.children;
    }

    public TOCReference addChildSection(TOCReference childSection) {
        this.children.add(childSection);
        return childSection;
    }

    public void setChildren(List<TOCReference> children) {
        this.children = children;
    }
}

