package lu.uni.minus.preferences;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

/**
 *
 * @author Piotr Kordy
 */
public class DataSet implements Comparator<Object>
{
  public enum Type {
    SP, GPS
  }

  private String name;
  private Type type;
  private File inputPath;
  private File outputPath;

  public DataSet(String name, String type, String inPath, String outPath) {
    setName(name);
    setType(Type.valueOf(type));
    setInputPath(new File(inPath));
    setOutputPath(new File(outPath));
  }

  /**
   * @return the name
   */
  public String getName() {
    return name;
  }

  /**
   * @param name
   *          the name to set
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * @return the type
   */
  public Type getType() {
    return type;
  }

  /**
   * @param type
   *          the type to set
   */
  public void setType(Type type) {
    this.type = type;
  }

  /**
   * @return the inputPath
   */
  public File getInputPath() {
    return inputPath;
  }

  /**
   * @param inputPath
   *          the inputPath to set
   */
  public void setInputPath(File inputPath) {
    this.inputPath = inputPath;
  }

  /**
   * @return the outputPath
   */
  public File getOutputPath() {
    return outputPath;
  }

  /**
   * @param outputPath
   *          the outputPath to set
   */
  public void setOutputPath(File outputPath) {
    this.outputPath = outputPath;
  }

  public String toString() {
    return name;
  }

  /**
   * {@inheritDoc}
   *
   * @see Comparator#equals(Object)
   */
  public boolean equals(Object ds) {
    return name.equalsIgnoreCase(((DataSet) ds).getName());
  }

  /**
   * {@inheritDoc}
   *
   * @see Comparator#compare(Object, Object)
   */
  public int compare(Object ds1, Object ds2) {
    return ((DataSet) ds1).getName().compareToIgnoreCase(((DataSet) ds2).getName());
  }

  public File createDistRoIDir(String paraSetting,String roiFile) {
    File result;
    if (getType().equals(Type.GPS)) {
      result = new File(getOutputPath() + File.separator+"Dist"+ File.separator+ paraSetting + File.separator + roiFile);
    }
    else{
      result = new File(getOutputPath() + File.separator+ "Dist"+File.separator  + roiFile);
    }
    if (!result.exists()) {
      result.mkdirs();
    }
    return result;
  }

  public File createDistDir(String paraSetting) {
    File result;
    if (getType().equals(Type.GPS)) {
      result = new File(getOutputPath() + File.separator+"Dist"+ File.separator+ paraSetting );
    }
    else{
      result = new File(getOutputPath() + File.separator+ "Dist");
    }
    if (!result.exists()) {
      result.mkdirs();
    }
    return result;
  }

  public File createPatternDir() {
    File result = new File(getOutputPath() + File.separator + "PatternSets");
    if (!result.exists()) {
      result.mkdirs();
    }
    return result;
  }

  public String[] getSPList() {
    if (getType().equals(Type.GPS)) {
      File spDir = new File(getOutputPath() + File.separator + "StayPoints");
      if (!spDir.exists()) {
        spDir.mkdirs();
      }
      String[] result = spDir.list();
      Arrays.sort(result);
      return result;
    }
    else {
      return null;
    }
  }

  public File[] getSPFiles() {
    if (getType().equals(Type.GPS)) {
      File spDir = new File(getOutputPath() + File.separator + "StayPoints");
      if (!spDir.exists()) {
        spDir.mkdirs();
      }
      File[] result = spDir.listFiles();
      Arrays.sort(result);
      return result;
    }
    else {
      return null;
    }
  }

  public String[] getRoiList() {
    if (getType().equals(Type.GPS)) {
      File spDir = new File(getOutputPath() + File.separator + "RoIs");
      if (!spDir.exists()) {
        spDir.mkdirs();
      }
      String[] result = spDir.list();
      Arrays.sort(result);
      return result;
    }
    else {
      return null;
    }
  }

  public File getFPSDir(int selected, String paraSetting, String roiFile, double threshold,
      double tolerance, double side) {
    String ending = "";
    if (selected == -1) {// All Days
      ending = threshold + "_" + tolerance + "_" + side + "_" + "_AllDays";
    }
    else
      if (selected == 1) {// Weekdays
        ending = threshold + "_" + tolerance + "_" + side + "_" + "_Weekdays";
      }
    if (selected == 0) {// Weekends
      ending = threshold + "_" + tolerance + "_" + side + "_" + "_Weekends";
    }
    if (getType() == Type.GPS) {
      return new File(getOutputPath() + File.separator + "PatternSets" + File.separator
          + paraSetting + File.separator + roiFile + File.separator + ending);
    }
    else {
      return new File(getOutputPath() + File.separator + "PatternSets" + File.separator + roiFile
          + File.separator + ending);
    }
  }
  public boolean isRoiDir(String selectedPara){
    File result;
    if (getType() == Type.GPS) {
      result = new File(getOutputPath() + File.separator + "RoIs" + File.separator + selectedPara);
    }
    else {
      result = new File(getOutputPath() + File.separator + "RoIs");
    }
    return result.exists();
  }
  
  public File createRoIDir(String selectedPara) {
    File result;
    if (getType() == Type.GPS) {
      result = new File(getOutputPath() + File.separator + "RoIs" + File.separator + selectedPara);
    }
    else {
      result = new File(getOutputPath() + File.separator + "RoIs");
    }
    if (!result.exists()) {
      result.mkdirs();
    }
    return result;
  }

  public File createStatRoIDir(String selectedPara) {
    File result;
    if (getType() == Type.GPS) {
      result = new File(getOutputPath() + File.separator + "Stats" + File.separator + "RoIs"
          + File.separator + selectedPara);
    }
    else {
      result = new File(getOutputPath() + File.separator + "Stats" + File.separator + "RoIs");
    }
    if (!result.exists()) {
      result.mkdirs();
    }
    return result;
  }

  /**
   * Return file with staypoints for given user and for GPS type of database the
   * selected stay point directory
   *
   * @param selectedPara
   * @param user
   * @return file with staypoints
   */
  public File getSPFile(String selectedPara, String user) {
    if (getType().equals(Type.SP)) {
      return new File(getInputPath() + File.separator + user + ".txt");
    }
    else {
      if (selectedPara == null) return null;
      return new File(getOutputPath() + File.separator + "StayPoints" + File.separator
          + selectedPara + File.separator + user + ".txt");
    }
  }

  public String[] getSPUsers(String sp) {
    if (getType().equals(Type.GPS)) {
      File spDir = new File(getOutputPath() + File.separator + "StayPoints" + File.separator + sp);
      String[] result = spDir.list();
      strip(result);
      Arrays.sort(result);
      return result;
    }
    else {
      return null;
    }
  }

  public String[] getUserList() {
    String[] result = getInputPath().list();
    if (getType().equals(Type.SP)) {
      strip(result);
    }
    Arrays.sort(result);
    return result;
  }

  public File getUserInDir(String user) {
    if (getType().equals(Type.GPS)) {
      File result = new File(getInputPath() + File.separator + user + File.separator + "Trajectory");
      return result;
    }
    else {
      return null;
    }
  }

  public File createOutputSPDir() {
    File result = new File(getOutputPath() + File.separator + "Stats" + File.separator
        + "SourceDataAndStayPoints");
    if (!result.exists()) {
      result.mkdirs();
    }
    return result;
  }

  public File createSPDir(String distance, String time, String threshold) {
    File result = getSPDir(distance, time, threshold);
    if (!result.exists()) {
      result.mkdirs();
    }
    return result;
  }

  private void strip(String[] list) {
    for (int i = 0; i < list.length; i++) {
      list[i] = list[i].substring(0, 3);
    }
  }

  public File getSPDir(String distance, String time, String threshold) {
    File result = new File(getOutputPath() + File.separator + "StayPoints" + File.separator
        + distance + "_" + time + "_" + threshold);
    return result;
  }

}
