/**
 * Author: Piotr Kordy (piotr.kordy@uni.lu <mailto:piotr.kordy@uni.lu>)
 * Date:   06/06/2014
 * Copyright (c) 2014,2013 University of Luxembourg
 * All rights reserved.
 * Licensed under GNU Affero General Public License 3.0;
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU Affero General Public License as
 *    published by the Free Software Foundation, either version 3 of the
 *    License, or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Affero General Public License for more details.
 *
 *    You should have received a copy of the GNU Affero General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
//http://www.javaranch.com/journal/2002/10/preferences.html
package lu.uni.minus.preferences;

import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class Settings{
  private static Preferences prefs;
  public Settings()
  {
		try {
      prefs = Preferences.userNodeForPackage(Settings.class);
//       System.out.println(prefs);
      if (!prefs.getBoolean("settings saved",false)){
        setDefault();
      }
// 		  try {
// 		  	prefs.exportSubtree(System.out);
// 		  } catch (IOException e) {
// 		  	// TODO Auto-generated catch block
// 		  	e.printStackTrace();
// 		  } catch (BackingStoreException e) {
// 		  	// TODO Auto-generated catch block
// 		  	e.printStackTrace();
// 		  }
    }
    catch (SecurityException e) {
      System.err.println("Security exception:");  
			e.printStackTrace();
    }
  }

 /**
 * Restores the default values for the preferences
 * 
 */
  public void setDefault(){
		prefs.putBoolean("settings saved",true);
		ArrayList<DataSet> ds = new ArrayList<DataSet>();
    saveDataSets(ds);
    setShowExit(true);
  }
  
  public boolean getShowExit()
  {
    return prefs.getBoolean("show exit dialog",true);
  }

  public void setShowExit(boolean swith)
  {
		prefs.putBoolean("show exit dialog",swith);
  }
  public ArrayList<DataSet> getDatasets()
  {
		ArrayList<DataSet> result = new ArrayList<DataSet>();
    int n=prefs.getInt("no datasets",0);
		for(int i=0;i<n;i++) {
      String id="ds"+(new Integer(i)).toString();
      result.add(new DataSet(
                             prefs.get(id+" name","empty"),
                             prefs.get(id+" type","GPS"),
                             prefs.get(id+" inPath","empty"),
                             prefs.get(id+" outPath","empty")
                             ));
    }
    return result;
  }
  
  public void saveDataSets(ArrayList<DataSet> ds)
  {
    int n=prefs.getInt("no datasets",0);
    prefs.putInt("no datasets",ds.size());
    while (n>=ds.size()){//removing excess data
      String id="ds"+(new Integer(n)).toString();
      prefs.remove(id+" name");
      prefs.remove(id+" type");
      prefs.remove(id+" inPath");
      prefs.remove(id+" outPath");
      n--;
    }
    int i=0;
		for(DataSet aDs : ds) {
      storeDataset(aDs,i);
      i++;
    }
  }
  public void replaceDataset(String oldName,DataSet ds){
    int n=prefs.getInt("no datasets",0);
    for (int i=0;i<n;i++){
      String id="ds"+(new Integer(i)).toString();
      String str=prefs.get(id+" name","");
      if(oldName.equalsIgnoreCase(str)){
        storeDataset(ds,i);
        return;
      }
    }
  }
  public void addDataSet(DataSet ds)
  {
    int n=prefs.getInt("no datasets",0);
    prefs.putInt("no datasets",n+1);
    storeDataset(ds,n);
  }

  public void removeDataSet(DataSet ds)
  {
    ArrayList<DataSet> ar=getDatasets();
    ar.remove(ds);
    saveDataSets(ar);
  }
  
  public void clearPreferences()
  {
		try {
			prefs.removeNode();
			prefs.flush();
      prefs = Preferences.userNodeForPackage(Settings.class);
		} catch (BackingStoreException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
  }

  private void storeDataset(DataSet ds,int i){
    String id="ds"+(new Integer(i)).toString();
    prefs.put(id+" name",ds.getName());
    prefs.put(id+" type",ds.getType().name());
    prefs.put(id+" inPath",ds.getInputPath().toString());
    prefs.put(id+" outPath",ds.getOutputPath().toString());
    try {
      prefs.flush();
    }
    catch (BackingStoreException e) {
      e.printStackTrace();
    }
  }
}
