package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingWorker.StateValue;
import javax.swing.border.TitledBorder;

import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.utils.TextPaneWorker;
import lu.uni.minus.utils.ValidityWorker;

public class AddDSPane extends DSPanel
{
  private static final long serialVersionUID = 2198569380922887957L;
  private JTextField textInputPath;
  private JTextField textOutputPath;
  private JTextField textName;
  private JButton btnAdd = new JButton("Add");
  private ProgressDialog pd = null;
  private DataSet ds;
  private ValidityWorker worker;

  /**
   * Create the panel.
   */
  public AddDSPane(MainWindow aParent) {
    super(aParent);

    JPanel contentPanel = new JPanel();
    contentPanel.setBorder(new TitledBorder(null, "Add a new dataset", TitledBorder.LEADING,
        TitledBorder.TOP, null, null));
    add(contentPanel, BorderLayout.NORTH);
    contentPanel.setLayout(new BoxLayout(contentPanel, BoxLayout.Y_AXIS));

    JPanel namePanel = new JPanel();
    contentPanel.add(namePanel);
    GridBagLayout gbl_namePanel = new GridBagLayout();
    gbl_namePanel.columnWidths = new int[] { 31, 150, 0, 0, 0, 0 };
    gbl_namePanel.rowHeights = new int[] { 23, 0 };
    gbl_namePanel.columnWeights = new double[] { 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE };
    gbl_namePanel.rowWeights = new double[] { 0.0, Double.MIN_VALUE };
    namePanel.setLayout(gbl_namePanel);

    JLabel lblName = new JLabel("Name:");
    GridBagConstraints gbc_lblName = new GridBagConstraints();
    gbc_lblName.anchor = GridBagConstraints.EAST;
    gbc_lblName.insets = new Insets(0, 53, 0, 5);
    gbc_lblName.gridx = 0;
    gbc_lblName.gridy = 0;
    namePanel.add(lblName, gbc_lblName);

    textName = new JTextField();
    GridBagConstraints gbc_textName = new GridBagConstraints();
    gbc_textName.insets = new Insets(0, 0, 0, 5);
    gbc_textName.fill = GridBagConstraints.HORIZONTAL;
    gbc_textName.gridx = 1;
    gbc_textName.gridy = 0;
    namePanel.add(textName, gbc_textName);
    textName.setColumns(10);

    JLabel lblType = new JLabel("Type:");
    GridBagConstraints gbc_lblType = new GridBagConstraints();
    gbc_lblType.insets = new Insets(0, 0, 0, 5);
    gbc_lblType.anchor = GridBagConstraints.EAST;
    gbc_lblType.gridx = 3;
    gbc_lblType.gridy = 0;
    namePanel.add(lblType, gbc_lblType);

    final JComboBox<String> comboBox = new JComboBox<String>();
    comboBox.setModel(new DefaultComboBoxModel<String>(new String[] { "GPS point", "Stay point" }));
    GridBagConstraints gbc_comboBox = new GridBagConstraints();
    gbc_comboBox.fill = GridBagConstraints.HORIZONTAL;
    gbc_comboBox.gridx = 4;
    gbc_comboBox.gridy = 0;
    namePanel.add(comboBox, gbc_comboBox);

    JPanel inputPathPanel = new JPanel();
    contentPanel.add(inputPathPanel);
    GridBagLayout gbl_panel_1 = new GridBagLayout();
    gbl_panel_1.columnWidths = new int[] { 55, 200, 61, 0 };
    gbl_panel_1.rowHeights = new int[] { 23, 0 };
    gbl_panel_1.columnWeights = new double[] { 0.0, 0.0, 0.0, Double.MIN_VALUE };
    gbl_panel_1.rowWeights = new double[] { 0.0, Double.MIN_VALUE };
    inputPathPanel.setLayout(gbl_panel_1);

    JLabel lblInputDirectory = new JLabel("Input directory:");
    GridBagConstraints gbc_lblInputDirectory = new GridBagConstraints();
    gbc_lblInputDirectory.anchor = GridBagConstraints.EAST;
    gbc_lblInputDirectory.insets = new Insets(0, 8, 0, 5);
    gbc_lblInputDirectory.gridx = 0;
    gbc_lblInputDirectory.gridy = 0;
    inputPathPanel.add(lblInputDirectory, gbc_lblInputDirectory);

    textInputPath = new JTextField();
    try {
      textInputPath.setText(new java.io.File(".").getCanonicalPath());
    }
    catch (IOException e1) {
      e1.printStackTrace();
    }
    textInputPath.setEditable(true);
    GridBagConstraints gbc_textInputPath = new GridBagConstraints();
    gbc_textInputPath.weightx = 1.0;
    gbc_textInputPath.fill = GridBagConstraints.HORIZONTAL;
    gbc_textInputPath.insets = new Insets(0, 0, 0, 5);
    gbc_textInputPath.gridx = 1;
    gbc_textInputPath.gridy = 0;
    inputPathPanel.add(textInputPath, gbc_textInputPath);
    textInputPath.setColumns(10);

    JButton btnInputPath = new JButton("Select");
    btnInputPath.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        textInputPath.setText(openADirectoryDialog(textInputPath.getText()));
      }
    });
    GridBagConstraints gbc_btnInputPath = new GridBagConstraints();
    gbc_btnInputPath.anchor = GridBagConstraints.NORTHEAST;
    gbc_btnInputPath.gridx = 2;
    gbc_btnInputPath.gridy = 0;
    inputPathPanel.add(btnInputPath, gbc_btnInputPath);

    JPanel panel_2 = new JPanel();
    contentPanel.add(panel_2);
    GridBagLayout gbl_panel_2 = new GridBagLayout();
    gbl_panel_2.columnWidths = new int[] { 84, 86, 61, 0 };
    gbl_panel_2.rowHeights = new int[] { 23, 0 };
    gbl_panel_2.columnWeights = new double[] { 0.0, 0.0, 0.0, Double.MIN_VALUE };
    gbl_panel_2.rowWeights = new double[] { 0.0, Double.MIN_VALUE };
    panel_2.setLayout(gbl_panel_2);

    JLabel lblOutputDirectory = new JLabel("Output directory:");
    GridBagConstraints gbc_lblOutputDirectory = new GridBagConstraints();
    gbc_lblOutputDirectory.anchor = GridBagConstraints.EAST;
    gbc_lblOutputDirectory.insets = new Insets(0, 0, 0, 5);
    gbc_lblOutputDirectory.gridx = 0;
    gbc_lblOutputDirectory.gridy = 0;
    panel_2.add(lblOutputDirectory, gbc_lblOutputDirectory);

    textOutputPath = new JTextField();
    try {
      textOutputPath.setText(new java.io.File(".").getCanonicalPath());
    }
    catch (IOException e1) {
      e1.printStackTrace();
    }
    textOutputPath.setEditable(true);
    GridBagConstraints gbc_textField_1 = new GridBagConstraints();
    gbc_textField_1.fill = GridBagConstraints.HORIZONTAL;
    gbc_textField_1.weightx = 1.0;
    gbc_textField_1.insets = new Insets(0, 0, 0, 5);
    gbc_textField_1.gridx = 1;
    gbc_textField_1.gridy = 0;
    panel_2.add(textOutputPath, gbc_textField_1);
    textOutputPath.setColumns(10);

    JButton btnSelect_1 = new JButton("Select");
    btnSelect_1.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        String selectedDir = (openADirectoryDialog(textOutputPath.getText()));
        if (!selectedDir.isEmpty()) {
          File inputDir = new File(selectedDir);
          if(inputDir.exists()){
            if (inputDir.list().length != 0) {
              JOptionPane.showMessageDialog(AddDSPane.this, "The output directory is not empty.",
                  "Invalid output directory", JOptionPane.ERROR_MESSAGE);
              return;
            }
            else {
              textOutputPath.setText(inputDir.getAbsolutePath());
            }
          }
        }
      }
    });
    GridBagConstraints gbc_btnSelect_1 = new GridBagConstraints();
    gbc_btnSelect_1.anchor = GridBagConstraints.NORTHEAST;
    gbc_btnSelect_1.gridx = 2;
    gbc_btnSelect_1.gridy = 0;
    panel_2.add(btnSelect_1, gbc_btnSelect_1);

    JPanel btnPanel = new JPanel();
    contentPanel.add(btnPanel);
    final AddDSPane me = this;
    btnAdd.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        String type = (String) comboBox.getSelectedItem();
        if (type == null) {
          JOptionPane.showMessageDialog(null, "You haven't chosen a dataset type.",
              "Choose a type", JOptionPane.INFORMATION_MESSAGE);
          return;
        }

        String name = textName.getText().trim();
        String inputPath = textInputPath.getText().trim();
        String outputPath = textOutputPath.getText().trim();

        if (name.isEmpty()) {
          JOptionPane.showMessageDialog(null, "You haven't filled in the dataset's name.",
              "Fill in a name", JOptionPane.INFORMATION_MESSAGE);
          return;
        }
        if (inputPath.isEmpty()) {
          JOptionPane.showMessageDialog(null, "You haven't chosen an input directory.",
              "Choose an input directory", JOptionPane.INFORMATION_MESSAGE);
          return;
        }
        if (outputPath.isEmpty()) {
          JOptionPane.showMessageDialog(null, "You haven't chosen an output directory.",
              "Choose an output directory", JOptionPane.INFORMATION_MESSAGE);
          return;
        }
        if (type.equals("GPS point")) {
          ds = new DataSet(name, "GPS", inputPath, outputPath);
        }
        else {
          ds = new DataSet(name, "SP", inputPath, outputPath);
        }
        worker = new ValidityWorker(ds, me);
        btnAdd.setEnabled(false);
        pd = new ProgressDialog(mw, (TextPaneWorker) worker);
        worker.setAnnouncer(pd);
        worker.addPropertyChangeListener(new PropertyChangeListener()
        {
          public void propertyChange(final PropertyChangeEvent event) {
            if (event.getPropertyName().equals("progress")) {
              pd.setIndeterminate(false);
              pd.setProgress((Integer) event.getNewValue());
            }
            else {
              if (event.getPropertyName().equals("state")) {
                switch ((StateValue) event.getNewValue()) {
                  case DONE:
                    workDone();
                    break;
                  case STARTED:
                  case PENDING:
                    pd.setButtonText("Cancel");
                    pd.setIndeterminate(true);
                    break;
                }
              }
            }
          }
        });
        worker.execute();

      }
    });
    btnPanel.add(btnAdd);

    JButton btnClear = new JButton("Clear");
    btnClear.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        textInputPath.setText("");
        textOutputPath.setText("");
        textName.setText("");
      }
    });
    btnPanel.add(btnClear);
    JButton btnCancel = new JButton("Cancel");
    btnCancel.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        mw.goHome();
      }
    });
    btnPanel.add(btnCancel);

    JLabel lblNewLabel = new JLabel(
        "<html>\r\nThe dataset to be added should conform to one of the following two types of formats:\r\n<br>\r\n<br><b>GPS point type: (for example look at Geolife dataset)</b><br><p>The input directory contains subfolders each of which is for one user and whose names are the users' three-digit numbered IDs, like 003. In each user's subfolder there is one folder named \"Trajectory\", in which each file is his GPS point trajectory in one day, or part of it. The first eight characters of each filename are the date of the day, like 20090909.</p><br><b>Stay point type: (for example look at Yonsei dataset)</b><br><p>The input directory contains files each of which is one user's stay point trajectories. Each filename is the user's three-digit numbered ID, like 003.</p></html>");
    lblNewLabel.setVerticalAlignment(SwingConstants.TOP);
    add(lblNewLabel, BorderLayout.CENTER);
  }

  /**
   * @return the btnAdd
   */
  public JButton getBtnAdd() {
    return btnAdd;
  }

  /**
   * @param btnAdd
   *          the btnAdd to set
   */
  public void setBtnAdd(JButton btnAdd) {
    this.btnAdd = btnAdd;
  }

  private void workDone() {
    pd.setButtonText("Close");
    int result = -2;
    try {
      result = worker.get();
    }
    catch (InterruptedException e1) {
      result = -1;
      worker.addErrorMessage(e1.getMessage());
    }
    catch (ExecutionException e1) {
      result = -1;
      worker.addErrorMessage(e1.getMessage());
    }
    if (result == 0) {
      mw.getDataSetPane().addDataSet(ds);
      mw.goHome();
    }
    btnAdd.setEnabled(true);
  }

}
