package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Enumeration;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import lu.uni.minus.preferences.DataSet;

public class DSPanel extends JPanel
{
  private static final long serialVersionUID = 5499601819450914301L;
  protected MainWindow mw;
  public DSPanel(MainWindow aParent) {
    mw=aParent;
    initCloseListener();
    setLayout(new BorderLayout(0, 0));
  }
  protected String openADirectoryDialog(String path) {
    JFileChooser parseDir = new JFileChooser(path);
    parseDir.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    try {
      int returnValue = parseDir.showOpenDialog(this);
      if (returnValue == JFileChooser.APPROVE_OPTION) {
        return parseDir.getSelectedFile().getAbsolutePath();
      }
      else {
        return path;
      }
    }
    catch (HeadlessException e) {
      e.printStackTrace();
      return "";
    }
  }

	@SuppressWarnings("unchecked")
	public String isIncluded(DataSet ds) {
    DefaultTreeModel treeModel = (DefaultTreeModel)(mw.getDataSetPane().getTree().getModel());
    DefaultMutableTreeNode root =(DefaultMutableTreeNode)(treeModel.getRoot());
    Enumeration<DefaultMutableTreeNode> currentDatasets = root.children();
    while (currentDatasets.hasMoreElements()) {
      DataSet aCurrentDataset = (DataSet) currentDatasets.nextElement().getUserObject();
      if (ds.equals(aCurrentDataset)) {
        return "A dataset with the name \"" + ds.getName() + "\" already exists";
      }
      try {
        if (ds.getInputPath().getCanonicalPath()
            .equals(aCurrentDataset.getInputPath().getCanonicalPath())) {
          return "A dataset with the input directory \"" + ds.getInputPath().toString()
              + "\" already exists";
        }
        if (ds.getOutputPath().getCanonicalPath().equals(aCurrentDataset.getOutputPath().getCanonicalPath())) {
          return "A dataset with the output directory \"" + ds.getOutputPath().toString()
              + "\" already exists";
        }
      }
      catch (IOException e) {
        return e.getMessage();
      }
    }
    return null;
	}
  private void initCloseListener() {
    getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
        KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "Cancel");
    getActionMap().put("Cancel", new AbstractAction()
    {
      private static final long serialVersionUID = 2143956335533214473L;
      public void actionPerformed(ActionEvent e) {
        mw.goHome();
      }
    });
  }
  
}
