package lu.uni.minus.ui;

import java.awt.Dimension;
import java.util.ArrayList;

import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;

import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.preferences.Settings;

public class DataSetsPanel extends JScrollPane
{
  private static final long serialVersionUID = 3843103137661347215L;
  private JTree tree;
  private Settings settings;
  public DataSetsPanel(Settings s){
    settings=s;
    fillTree(settings.getDatasets());
    setPreferredSize(new Dimension(100,300));
    setMinimumSize(new Dimension(100,300));
  }
  public void fillTree(ArrayList<DataSet> ar){
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("All datasets");
    for(DataSet a : ar) {
      DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(a, false);
      root.add(aNode);
    }
    tree = new JTree(root, true);
    tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    setViewportView(tree);
  }
  public void addDataSet(DataSet ds){
    settings.addDataSet(ds);
    DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(ds, false);
    DefaultTreeModel treeModel = (DefaultTreeModel)(tree.getModel());
    DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
    treeModel.insertNodeInto(newNode, root, root.getChildCount());
  }
  /**
   * @return the tree
   */
  public JTree getTree() {
    return tree;
  }

  public DefaultMutableTreeNode getSelected()
  {
    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode) tree
        .getLastSelectedPathComponent();
    if (selectedNode == null || selectedNode.isRoot()) {
      return null;
    }
    return selectedNode;
  }
  /**
   * @param tree the tree to set
   */
  public void setTree(JTree tree) {
    this.tree = tree;
  }
}
