package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import lu.uni.minus.preferences.DataSet;

import org.apache.commons.io.FileUtils;

public class EditDSPanel extends DSPanel
{
  /**
   *
   */
  private static final long serialVersionUID = 4434281789357219313L;
  private JTextField textName;
  private JTextField textNewOut;
  private DataSet dataset;
  private DefaultMutableTreeNode node;

  public EditDSPanel(MainWindow aParent, DefaultMutableTreeNode aNode) {
    super(aParent);
    node = aNode;
    dataset = (DataSet) aNode.getUserObject();
    JPanel mainPanel = new JPanel();
    mainPanel.setBorder(new TitledBorder(null, "Edit the dataset " + dataset.getName(),
        TitledBorder.LEADING, TitledBorder.TOP, null, null));
    add(mainPanel, BorderLayout.NORTH);
    mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));

    JPanel panelTemp = new JPanel();
    panelTemp.setLayout(new BoxLayout(panelTemp, BoxLayout.X_AXIS));
    panelTemp.add(new JLabel("Type of the database:"));
    panelTemp.add(Box.createRigidArea(new Dimension(5, 5)));
    panelTemp.add(new JLabel(dataset.getType().toString()));
    panelTemp.add(Box.createHorizontalGlue());
    mainPanel.add(panelTemp);
    mainPanel.add(Box.createRigidArea(new Dimension(5, 5)));

    panelTemp = new JPanel();
    panelTemp.setLayout(new BoxLayout(panelTemp, BoxLayout.X_AXIS));
    panelTemp.add(new JLabel("Current dataset source directory:"));
    panelTemp.add(Box.createRigidArea(new Dimension(5, 5)));
    panelTemp.add(new JLabel(dataset.getInputPath().toString()));
    panelTemp.add(Box.createHorizontalGlue());
    mainPanel.add(panelTemp);

    JPanel panelCurrOutDir = new JPanel();
    GridBagLayout gbl_panelCurrOutDir = new GridBagLayout();
    gbl_panelCurrOutDir.columnWidths = new int[] { 46, 0, 0 };
    gbl_panelCurrOutDir.rowHeights = new int[] { 25, 0 };
    gbl_panelCurrOutDir.columnWeights = new double[] { 0.0, 0.0, Double.MIN_VALUE };
    gbl_panelCurrOutDir.rowWeights = new double[] { 0.0, Double.MIN_VALUE };
    panelCurrOutDir.setLayout(gbl_panelCurrOutDir);

    JLabel lblCurrOutDir = new JLabel("Current output directory:");
    GridBagConstraints gbc_lblCurrOutDir = new GridBagConstraints();
    gbc_lblCurrOutDir.insets = new Insets(0, 0, 0, 5);
    gbc_lblCurrOutDir.anchor = GridBagConstraints.EAST;
    gbc_lblCurrOutDir.gridx = 0;
    gbc_lblCurrOutDir.gridy = 0;
    panelCurrOutDir.add(lblCurrOutDir, gbc_lblCurrOutDir);

    JLabel lblCurrOutValue = new JLabel(dataset.getOutputPath().toString());
    GridBagConstraints gbc_lblCurrOutVal = new GridBagConstraints();
    gbc_lblCurrOutVal.gridx = 1;
    gbc_lblCurrOutVal.gridy = 0;
    panelCurrOutDir.add(lblCurrOutValue, gbc_lblCurrOutVal);
    mainPanel.add(panelCurrOutDir);

    JPanel panelName = new JPanel();
    GridBagLayout gbl_panelName = new GridBagLayout();
    gbl_panelName.columnWidths = new int[] { 0, 0, 0 };
    gbl_panelName.rowHeights = new int[] { 25, 0 };
    gbl_panelName.columnWeights = new double[] { 0.0, 0.0, Double.MIN_VALUE };
    gbl_panelName.rowWeights = new double[] { 0.0, Double.MIN_VALUE };
    panelName.setLayout(gbl_panelName);

    JLabel lblName = new JLabel("New name:");
    GridBagConstraints gbc_lblName = new GridBagConstraints();
    gbc_lblName.insets = new Insets(0, 68, 0, 5);
    gbc_lblName.anchor = GridBagConstraints.EAST;
    gbc_lblName.gridx = 0;
    gbc_lblName.gridy = 0;
    panelName.add(lblName, gbc_lblName);
    mainPanel.add(panelName);

    textName = new JTextField(dataset.getName());
    GridBagConstraints gbc_textName = new GridBagConstraints();
    gbc_textName.fill = GridBagConstraints.HORIZONTAL;
    gbc_textName.gridx = 1;
    gbc_textName.gridy = 0;
    textName.setColumns(10);
    panelName.add(textName, gbc_textName);

    JPanel panelNewOut = new JPanel();
    GridBagLayout gbl_panel_3 = new GridBagLayout();
    gbl_panel_3.columnWidths = new int[] { 0, 0, 0, 0 };
    gbl_panel_3.rowHeights = new int[] { 25, 0 };
    gbl_panel_3.columnWeights = new double[] { 0.0, 1.0, 0.0, Double.MIN_VALUE };
    gbl_panel_3.rowWeights = new double[] { 0.0, Double.MIN_VALUE };
    panelNewOut.setLayout(gbl_panel_3);

    JLabel lblOutputDirectory = new JLabel("New output directory:");
    GridBagConstraints gbc_lblOutputDirectory = new GridBagConstraints();
    gbc_lblOutputDirectory.insets = new Insets(0, 15, 0, 5);
    gbc_lblOutputDirectory.anchor = GridBagConstraints.EAST;
    gbc_lblOutputDirectory.gridx = 0;
    gbc_lblOutputDirectory.gridy = 0;
    panelNewOut.add(lblOutputDirectory, gbc_lblOutputDirectory);

    textNewOut = new JTextField(dataset.getOutputPath().toString());
    textNewOut.setEditable(true);
    GridBagConstraints gbc_textNewOut = new GridBagConstraints();
    gbc_textNewOut.insets = new Insets(0, 0, 0, 5);
    gbc_textNewOut.fill = GridBagConstraints.HORIZONTAL;
    gbc_textNewOut.gridx = 1;
    gbc_textNewOut.gridy = 0;
    textNewOut.setColumns(10);
    panelNewOut.add(textNewOut, gbc_textNewOut);

    JButton btnNewOut = new JButton("Select");
    GridBagConstraints gbc_btnNewOut = new GridBagConstraints();
    gbc_btnNewOut.gridx = 2;
    gbc_btnNewOut.gridy = 0;
    panelNewOut.add(btnNewOut, gbc_btnNewOut);
    mainPanel.add(panelNewOut);

    JPanel panelBtn = new JPanel();

    final JButton btnConfirm = new JButton("Confirm");
    btnConfirm.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        String newName = textName.getText().trim();
        String oldName = dataset.getName();
        File newOutPath = new File(textNewOut.getText().trim());
        boolean samePath = true;
        try {
          samePath = newOutPath.getCanonicalPath().equals(
              dataset.getOutputPath().getCanonicalPath());
        }
        catch (IOException e1) {
          e1.printStackTrace();
        }
        if (newName.equalsIgnoreCase(oldName) && samePath) {
          mw.goHome();
          return;
        }
        if (!samePath) {
          if (newOutPath.list().length != 0) {
            int ans = JOptionPane
                .showConfirmDialog(
                    mw,
                    "The new output directory is not empty. \nUsing it will delete its contents.\nDo you want to continue?",
                    "Confirm", JOptionPane.YES_NO_OPTION);
            if (ans == JOptionPane.NO_OPTION) {
              return;
            }
          }
          try {
            FileUtils.deleteDirectory(newOutPath);
            FileUtils.moveDirectory(dataset.getOutputPath(), newOutPath);
          }
          catch (IOException exc) {
            System.err.println("Error while moving directory:" + exc.getMessage());
            return;
          }
        }
        dataset.setName(newName);
        dataset.setOutputPath(newOutPath);
        DefaultTreeModel treeModel = (DefaultTreeModel) (mw.getDataSetPane().getTree().getModel());
        treeModel.nodeChanged(node);
        mw.getSettings().replaceDataset(oldName, dataset);
        mw.goHome();
      }
    });
    panelBtn.add(btnConfirm);

    JButton btnClear = new JButton("Clear");
    panelBtn.add(btnClear);
    btnClear.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        textName.setText("");
        textNewOut.setText("");
      }
    });

    JButton btnCancel = new JButton("Cancel");
    btnCancel.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        mw.goHome();
      }
    });
    panelBtn.add(btnCancel);
    mainPanel.add(panelBtn);
  }
}
