package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.utils.PSExtractor;

public class ExtractFPSPanel extends JPanel implements Announcer
{
  private static final long serialVersionUID = -1406202306902077691L;
  private final MainWindow mw;
  private final Dimension space = new Dimension(6, 6);
  private JTextField tfThreshold;
  private JTextField tfSidelength;
  private JTextField tfTolerance;
  public JButton btnStart;
  private JTextPane messageArea;
  private HTMLEditorKit kit;
  private HTMLDocument doc;
  private DataSet dataset;
  private String selectedSP;
  private final ButtonGroup buttonGroup = new ButtonGroup();

  public ExtractFPSPanel(MainWindow aMw, DataSet aDataset) {
    mw = aMw;
    dataset = aDataset;
    createGui();
  }

  private void createGui() {
    final JSplitPane splitPane = new JSplitPane();
    setLayout(new BorderLayout(0, 0));
    add(splitPane, BorderLayout.CENTER);
    final JPanel mainPanel = new JPanel();
    mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
    JPanel titlePanel = new JPanel();
    titlePanel.setLayout(new BoxLayout(titlePanel, BoxLayout.Y_AXIS));
    titlePanel.setBorder(new TitledBorder(null, "Parameters for extracting frequent pattern sets",
        TitledBorder.LEADING, TitledBorder.TOP, null, null));

    JPanel subtitlePanel = new JPanel();
    subtitlePanel.setLayout(new BoxLayout(subtitlePanel, BoxLayout.X_AXIS));
    JPanel leftPanel = new JPanel();
    leftPanel.setLayout(new BoxLayout(leftPanel, BoxLayout.Y_AXIS));

    leftPanel.setMaximumSize(new Dimension(250, 100));
    leftPanel.add(createLabelPanel("Support threshold :"));
    leftPanel.add(Box.createRigidArea(space));
    leftPanel.add(createLabelPanel("Side length of cell :"));
    leftPanel.add(Box.createRigidArea(space));
    subtitlePanel.add(leftPanel);

    JPanel rightPanel = new JPanel();
    rightPanel.setLayout(new BoxLayout(rightPanel, BoxLayout.Y_AXIS));
    rightPanel.setMaximumSize(new Dimension(250, 100));
    Dimension fieldSize = new Dimension(100, 20);
    tfThreshold = new JTextField("0.1");
    tfThreshold.setPreferredSize(fieldSize);
    tfThreshold.setMaximumSize(fieldSize);
    tfThreshold
        .setToolTipText("<html>\r\nIt specifies the minimum percentage of trajectories that support a specific pattern \r\n<br/>\r\nfor it to be a frequent pattern. \r\n<br/>\r\nIt should be between 0 and 1. A typical value is 0.1.\r\n<html/>");
    tfSidelength = new JTextField("0.02");
    tfSidelength.setPreferredSize(fieldSize);
    tfSidelength.setMaximumSize(fieldSize);
    tfSidelength
        .setToolTipText("<html>\r\nIt refers to the span of latitudes or longitudes a cell covers. \r\n<br/>\r\na cell is a terminology used in course of trajectory pattern mining.\r\n<br/>\r\nA typical value is 0.02.\r\n<html/>");
    rightPanel.add(createComponentPanel(tfThreshold, " "));
    rightPanel.add(createComponentPanel(tfSidelength, " "));

    subtitlePanel.add(rightPanel);

    JPanel leftPanel2 = new JPanel();
    leftPanel2.setLayout(new BoxLayout(leftPanel2, BoxLayout.Y_AXIS));
    leftPanel2.setMaximumSize(new Dimension(250, 100));
    leftPanel2.add(createLabelPanel("Time tolerance :"));
    leftPanel2.add(Box.createRigidArea(space));
    subtitlePanel.add(leftPanel2);

    JPanel rightPanel2 = new JPanel();
    rightPanel2.setLayout(new BoxLayout(rightPanel2, BoxLayout.Y_AXIS));
    tfTolerance = new JTextField("7200");
    tfTolerance.setPreferredSize(fieldSize);
    tfTolerance.setMaximumSize(fieldSize);
    tfTolerance
        .setToolTipText("<html>\r\nIt is the maximum allowed time length that a time length between two RoIs in a \r\n<br/>\r\npattern can differ from a time length between two points in a trajectory in order to \r\n<br/>\r\nlet the trajectory contain the pattern. A typical value is 7200.\r\n<html/>");
    rightPanel2.add(createComponentPanel(tfTolerance, " s"));
    final WideJComboBox<String> comboRoI = new WideJComboBox<String>();
    rightPanel2.add(createComponentPanel(comboRoI, " "));
    comboRoI.setMaximumSize(new Dimension(200, 25));
    comboRoI.setPrototypeDisplayValue("MMMMMMMMMMMM");
    final JList<String> usersList = new JList<String>();
    subtitlePanel.add(rightPanel2);

    subtitlePanel.add(Box.createHorizontalGlue());
    titlePanel.add(subtitlePanel);
    final JPanel daysPanel = new JPanel();
    daysPanel.setLayout(new BoxLayout(daysPanel, BoxLayout.X_AXIS));
    daysPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"),
        "Type of days taken into account", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    daysPanel.add(Box.createHorizontalGlue());
    final JRadioButton rdbtnAllDays = new JRadioButton("All days");
    buttonGroup.add(rdbtnAllDays);
    daysPanel.add(rdbtnAllDays);

    final JRadioButton rdbtnWeekdays = new JRadioButton("Weekdays");
    buttonGroup.add(rdbtnWeekdays);
    daysPanel.add(rdbtnWeekdays);

    final JRadioButton rdbtnWeekends = new JRadioButton("Weekends");
    buttonGroup.add(rdbtnWeekends);
    rdbtnAllDays.setSelected(true);
    daysPanel.add(rdbtnWeekends);
    daysPanel.add(Box.createHorizontalGlue());
    titlePanel.add(daysPanel);
    mainPanel.add(titlePanel);

    JScrollPane scrollMessage = new JScrollPane();
    messageArea = new JTextPane();
    messageArea.setPreferredSize(new Dimension(300, 200));
    messageArea.setContentType("text/html");
    messageArea.setEditable(false);
    // messageArea.setBackground(Color.BLACK);
    kit = new HTMLEditorKit();
    messageArea.setEditorKit(kit);
    doc = new HTMLDocument();
    messageArea.setDocument(doc);
    scrollMessage.setViewportView(messageArea);
    mainPanel.add(scrollMessage);

    splitPane.setRightComponent(mainPanel);

    final JPanel usersPanel = new JPanel();
    usersPanel.setBorder(null);
    usersPanel.setLayout(new BoxLayout(usersPanel, BoxLayout.Y_AXIS));

    JScrollPane scrollPane = new JScrollPane();
    selectedSP = null;
    if (dataset.getType() == DataSet.Type.GPS) {
      usersPanel.add(new JLabel("Generated RoIs"));
      final DefaultComboBoxModel<String> cModel = new DefaultComboBoxModel<String>(
          dataset.getSPList());
      final JComboBox<String> comboBox = new JComboBox<String>(cModel);
      comboBox.setMaximumSize(new Dimension(200, 25));
      comboBox.addActionListener(new ActionListener()
      {
        public void actionPerformed(ActionEvent e) {
          selectedSP = (String) comboBox.getSelectedItem();
          if (selectedSP != null) {
            String[] roiFiles = dataset.getRoiList();
            HashSet<String> usersInRoIFilesUnderThePara = new HashSet<String>();
            for (String anRoIFile : roiFiles) {
              String[] fields = anRoIFile.split("-");
              String[] usersInTheRoIFile = fields[0].split("_");
              for (String aUser : usersInTheRoIFile) {
                usersInRoIFilesUnderThePara.add(aUser);
              }
            }
            usersList.setListData(usersInRoIFilesUnderThePara.toArray(new String[0]));
          }
        }
      });
      usersPanel.add(comboBox);
      selectedSP = (String) comboBox.getSelectedItem();
      if (selectedSP != null) {
        usersList.setListData(dataset.getSPUsers(selectedSP));
      }
      comboRoI.addPopupMenuListener(new PopupMenuListener()
      {
        public void popupMenuCanceled(PopupMenuEvent arg0) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
          List<String> selectedList = usersList.getSelectedValuesList();
          if (selectedList.size() == 0) { return; }
          ArrayList<String> usableRoIFiles = new ArrayList<String>();
          selectedSP = (String) comboBox.getSelectedItem();
          HashSet<String> selectedUsersSet = new HashSet<String>(selectedList);
          String[] roiFiles = dataset.createRoIDir(selectedSP).list();
          for (String aFile : roiFiles) {
            String[] fields = aFile.split("-");
            String[] users = fields[0].split("_");
            HashSet<String> usersAnRoI = new HashSet<String>();
            for (String aUser : users) {
              usersAnRoI.add(aUser);
            }

            if (usersAnRoI.containsAll(selectedUsersSet)) {
              usableRoIFiles.add(aFile);
            }
          }
          comboRoI.removeAllItems();

          for (String aUsableRoIFile : usableRoIFiles) {
            comboRoI.addItem(aUsableRoIFile);
          }
          comboRoI.setWide(true);
        }
      });

    }
    else {
      usersList.setListData(dataset.getUserList());
    }
    usersPanel.add(new JLabel("User list:"));
    usersPanel.add(scrollPane);

    scrollPane.setViewportView(usersList);
    usersPanel.setPreferredSize(new Dimension(100, 500));
    splitPane.setLeftComponent(usersPanel);

    JPanel buttonPanel = new JPanel();
    buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
    buttonPanel.add(Box.createRigidArea(space));
    buttonPanel.add(Box.createHorizontalGlue());
    buttonPanel.add(Box.createHorizontalGlue());
    btnStart = new JButton("Start");
    final ExtractFPSPanel me = this;
    btnStart.addActionListener(new ActionListener()
    {
      /**
       * {@inheritDoc}
       *
       * @see ActionListener#actionPerformed(ActionEvent)
       */
      public void actionPerformed(ActionEvent e) {
        messageArea.setText("");
        List<String> selectedList = usersList.getSelectedValuesList();
        if (selectedList.size() == 0) {
          JOptionPane.showMessageDialog(null, "Please first choose some users.", "Choose users",
              JOptionPane.INFORMATION_MESSAGE);
          return;
        }
        String selectedRoIFile = (String) comboRoI.getSelectedItem();
        if (selectedRoIFile == null) {
          JOptionPane.showMessageDialog(null, "You haven't chosen an RoI file yet.",
              "Choose an RoI file", JOptionPane.INFORMATION_MESSAGE);
          return;
        }
        double threshold = Double.parseDouble(tfThreshold.getText().trim());
        double tolerance = Double.parseDouble(tfTolerance.getText().trim());
        double side = Double.parseDouble(tfSidelength.getText().trim());

        if (threshold < 0.0 || threshold > 1.0) {
          JOptionPane.showMessageDialog(null,
              "The support threshold you entered is not between 0 and 1.", "Input error",
              JOptionPane.ERROR_MESSAGE);
          return;
        }
        if (tolerance < 0.0) {
          JOptionPane.showMessageDialog(null,
              "The time tolerance you entered is not non-negative.", "Input error",
              JOptionPane.ERROR_MESSAGE);
          return;
        }
        if (side <= 0.0) {
          JOptionPane.showMessageDialog(null, "The time tolerance you entered is not positive.",
              "Input error", JOptionPane.ERROR_MESSAGE);
          return;
        }
        byte selected = rdbtnAllDays.isSelected() ? (byte) -1
            : (rdbtnWeekdays.isSelected() ? (byte) 1 : (rdbtnWeekends.isSelected() ? (byte) 0
                : (byte) -2));
        if (selected == -2) {
          JOptionPane.showMessageDialog(null, "Please first choose a type of days.",
              "Choose a type of days", JOptionPane.ERROR_MESSAGE);
          return;
        }
        File fpsDir = dataset.getFPSDir(selected, selectedSP, selectedRoIFile, threshold,
            tolerance, side);
        ArrayList<String> filteredList = new ArrayList<String>(selectedList);
        if (fpsDir.exists()) {
          String[] filenamesPS = fpsDir.list();
          for (int i = 0; i < filenamesPS.length; i++) {
            filenamesPS[i] = filenamesPS[i].substring(0, 3);
          }
          Arrays.sort(filenamesPS);
          for (String anSelectedUser : selectedList) {
            if (Arrays.binarySearch(filenamesPS, anSelectedUser) >= 0) {
              filteredList.remove(anSelectedUser);
            }
          }
        }
        if (filteredList.size() == 0) {
          JOptionPane
              .showMessageDialog(
                  null,
                  "All the users you selected have already been extracted from.\nNo more work needs to be done.",
                  "Duplicate operation", JOptionPane.INFORMATION_MESSAGE);
          return;
        }
        btnStart.setEnabled(false);
        PSExtractor worker = null;
        worker = new PSExtractor(dataset,me,filteredList, threshold, tolerance, side, selectedRoIFile,
            selected, selectedSP, fpsDir);
        Thread t = new Thread(worker);
        t.setPriority(Thread.MAX_PRIORITY);
        t.start();

      }
    });
    buttonPanel.add(btnStart);
    buttonPanel.add(Box.createRigidArea(space));

    buttonPanel.add(Box.createRigidArea(space));

    JButton btnClose = new JButton("Close");
    btnClose.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        mw.goHome();
      }
    });
    buttonPanel.add(btnClose);
    mainPanel.add(buttonPanel);
    usersList.addListSelectionListener(new ListSelectionListener()
    {
      public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) return;
        List<String> selectedList = usersList.getSelectedValuesList();
        if (selectedList.size() == 0) { return; }
        ArrayList<String> usableRoIFiles = new ArrayList<String>();
        HashSet<String> selectedUsersSet = new HashSet<String>(selectedList);
        String[] roiFiles = dataset.createRoIDir(selectedSP).list();
        for (String aFile : roiFiles) {
          String[] fields = aFile.split("-");
          String[] users = fields[0].split("_");
          HashSet<String> usersAnRoI = new HashSet<String>();
          for (String aUser : users) {
            usersAnRoI.add(aUser);
          }

          if (usersAnRoI.containsAll(selectedUsersSet)) {
            usableRoIFiles.add(aFile);
          }
        }
        comboRoI.removeAllItems();

        for (String aUsableRoIFile : usableRoIFiles) {
          comboRoI.addItem(aUsableRoIFile);
        }
        btnStart.setEnabled(usableRoIFiles.size()>0);
        comboRoI.setWide(true);
//         System.out.println("Selected from " + evt.getFirstIndex() + " to " + evt.getLastIndex());
      }
    });
    
  }

  private JPanel createLabelPanel(String text) {
    JPanel result = new JPanel();
    result.setLayout(new BoxLayout(result, BoxLayout.X_AXIS));
    result.add(Box.createHorizontalGlue());
    result.add(Box.createRigidArea(space));
    result.add(new JLabel(text));
    result.add(Box.createRigidArea(space));
    return result;
  }

  private JPanel createComponentPanel(JComponent component, String text) {
    JPanel result = new JPanel();
    result.setLayout(new BoxLayout(result, BoxLayout.X_AXIS));
    result.add(Box.createRigidArea(space));
    result.add(component);
    result.add(new JLabel(text));
    result.add(Box.createHorizontalGlue());
    return result;
  }

  public void addMessage(String html) {
    try {
      kit.insertHTML(doc, doc.getLength(), html, 0, 0, null);
    }
    catch (BadLocationException e) {
      e.printStackTrace();
    }
    catch (IOException e) {
      e.printStackTrace();
    }
  }


}
