package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker.StateValue;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.utils.TextPaneWorker;
import lu.uni.minus.utils.roi.SPClusteringWorker;

public class GenerateRoIPanel extends JPanel implements Announcer
{
  /**
   *
   */
  private static final long serialVersionUID = 8744363387885045523L;
  private final MainWindow mw;
  private final Dimension space = new Dimension(6, 6);
  private JTextField tfPercentage;
  private JTextField tfLowerK;
  private JTextField tfUpperK;
  private JButton btnStart;
  private JButton btnCancel;
  private Action cancelAction;
  private JTextPane messageArea;
  private JProgressBar progressBar;
  private TextPaneWorker worker;
  private HTMLEditorKit kit;
  private HTMLDocument doc;
  private DataSet dataset;
  private String selectedSP;

  public GenerateRoIPanel(MainWindow aMw, DataSet aDataset) {
    mw = aMw;
    dataset = aDataset;
    createGui();
  }

  private void createGui() {
    final JSplitPane splitPane = new JSplitPane();
    setLayout(new BorderLayout(0, 0));
    add(splitPane, BorderLayout.CENTER);
    final JPanel mainPanel = new JPanel();
    mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
    JPanel titlePanel = new JPanel();
    titlePanel.setLayout(new BoxLayout(titlePanel, BoxLayout.X_AXIS));
    titlePanel.setBorder(new TitledBorder(null, "Parameters for generating RoIs",
        TitledBorder.LEADING, TitledBorder.TOP, null, null));
    JPanel leftPanel = new JPanel();
    leftPanel.setLayout(new BoxLayout(leftPanel, BoxLayout.Y_AXIS));

    leftPanel.setMaximumSize(new Dimension(250, 100));
    leftPanel.add(createLabelPanel("Deletion percentage :"));
    leftPanel.add(Box.createRigidArea(space));
    leftPanel.add(createLabelPanel("Lower bound of K :"));
    leftPanel.add(Box.createRigidArea(space));
    leftPanel.add(createLabelPanel("Upper bound of K :"));
    leftPanel.add(Box.createRigidArea(space));
    titlePanel.add(leftPanel);

    JPanel rightPanel = new JPanel();
    rightPanel.setLayout(new BoxLayout(rightPanel, BoxLayout.Y_AXIS));
    Dimension fieldSize = new Dimension(100, 20);
    tfPercentage = new JTextField("25");
    tfPercentage.setPreferredSize(fieldSize);
    tfPercentage.setMaximumSize(fieldSize);
    tfPercentage
        .setToolTipText("<html>\r\nIt specifies the percentage of stay points to constitute noise and be removed.\r\n<br/>\r\nA typical value is 20 or 30.\r\n<html/>");
    tfLowerK = new JTextField("5");
    tfLowerK.setPreferredSize(fieldSize);
    tfLowerK.setMaximumSize(fieldSize);
    tfLowerK
        .setToolTipText("<html>\r\nK is a parameter used when removing outliers. Typical bounds are 5 and 35 \r\n<br/>\r\nwhen the number of stay points to be clustered is less than 1000, 10 and 50 when\r\n<br/>\r\nthe number is between 1000 and 3000, 20 and 100 when the number is more than\r\n<br/>\r\n3000. But these are not necessarily applicable. Different sets of stay points may\r\n<br/>\r\nrequire different bounds of K.\r\n<html/>\r\n\r\n");
    tfUpperK = new JTextField("35");
    tfUpperK.setPreferredSize(fieldSize);
    tfUpperK.setMaximumSize(fieldSize);
    tfUpperK
        .setToolTipText("<html>\r\nK is a parameter used when removing outliers. Typical bounds are 5 and 35 \r\n<br/>\r\nwhen the number of stay points to be clustered is less than 1000, 10 and 50 when\r\n<br/>\r\nthe number is between 1000 and 3000, 20 and 100 when the number is more than\r\n<br/>\r\n3000. But these are not necessarily applicable. Different sets of stay points may\r\n<br/>\r\nrequire different bounds of K.\r\n<html/>");
    rightPanel.add(createComponentPanel(tfPercentage, " %"));
    rightPanel.add(createComponentPanel(tfLowerK, " "));
    rightPanel.add(createComponentPanel(tfUpperK, " "));

    titlePanel.add(rightPanel);
    titlePanel.add(Box.createHorizontalGlue());
    mainPanel.add(titlePanel);

    JScrollPane scrollMessage = new JScrollPane();
    messageArea = new JTextPane();
    messageArea.setPreferredSize(new Dimension(300, 200));
    messageArea.setContentType("text/html");
    messageArea.setEditable(false);
    // messageArea.setBackground(Color.BLACK);
    kit = new HTMLEditorKit();
    messageArea.setEditorKit(kit);
    doc = new HTMLDocument();
    messageArea.setDocument(doc);
    scrollMessage.setViewportView(messageArea);
    mainPanel.add(scrollMessage);

    splitPane.setRightComponent(mainPanel);

    final JPanel usersPanel = new JPanel();
    usersPanel.setBorder(null);
    usersPanel.setLayout(new BoxLayout(usersPanel, BoxLayout.Y_AXIS));
    final JList<String> usersList = new JList<String>();

    JScrollPane scrollPane = new JScrollPane();
    selectedSP = null;
    if (dataset.getType() == DataSet.Type.GPS) {
      usersPanel.add(new JLabel("Stay point paras"));
      final DefaultComboBoxModel<String> cModel = new DefaultComboBoxModel<String>(
          dataset.getSPList());
      final JComboBox<String> comboBox = new JComboBox<String>(cModel);
      comboBox.setMaximumSize(new Dimension(200, 25));
      comboBox.addActionListener(new ActionListener()
      {
        public void actionPerformed(ActionEvent e) {
          selectedSP = (String) comboBox.getSelectedItem();
          if (selectedSP != null) {
            usersList.setListData(dataset.getSPUsers(selectedSP));
          }
        }
      });
      usersPanel.add(comboBox);
      selectedSP = (String) comboBox.getSelectedItem();
      if (selectedSP != null) {
        usersList.setListData(dataset.getSPUsers(selectedSP));
      }
    }
    else {
      usersList.setListData(dataset.getUserList());
    }
    usersPanel.add(new JLabel("User list:"));
    usersPanel.add(scrollPane);

    scrollPane.setViewportView(usersList);
    usersPanel.setPreferredSize(new Dimension(100, 500));
    splitPane.setLeftComponent(usersPanel);

    JPanel buttonPanel = new JPanel();
    buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
    buttonPanel.add(Box.createRigidArea(space));
    progressBar = new JProgressBar(0, 100);
    progressBar.setStringPainted(true);
    progressBar.setVisible(false);
    progressBar.setPreferredSize(new Dimension(800, 20));
    buttonPanel.add(Box.createHorizontalGlue());
    buttonPanel.add(progressBar);
    buttonPanel.add(Box.createHorizontalGlue());
    btnStart = new JButton("Start");
    final GenerateRoIPanel me = this;
    btnStart.addActionListener(new ActionListener()
    {
      /**
       * {@inheritDoc}
       *
       * @see ActionListener#actionPerformed(ActionEvent)
       */
      public void actionPerformed(ActionEvent e) {
        messageArea.setText("");
        List<String> selectedList = usersList.getSelectedValuesList();
        if (selectedList.size() == 0) {
          JOptionPane.showMessageDialog(null, "Please first choose some users.", "Choose users",
              JOptionPane.INFORMATION_MESSAGE);
          return;
        }
        int percentage = Integer.parseInt(tfPercentage.getText().trim());
        int lowerK = Integer.parseInt(tfLowerK.getText().trim());
        int upperK = Integer.parseInt(tfUpperK.getText().trim());

        if (percentage <= 0 || lowerK <= 0 || upperK <= 0 || percentage > 100) {
          JOptionPane
              .showMessageDialog(
                  null,
                  "The three parameters must be positive integers and percentage must be lower that 100.",
                  "Number format error", JOptionPane.ERROR_MESSAGE);
          return;
        }

        if (upperK <= lowerK) {
          JOptionPane.showMessageDialog(null,
              "The upper bound of K you entered is not greater than the lower bound.",
              "Input error", JOptionPane.ERROR_MESSAGE);
          return;
        }
        String msg = getPopupMsg(selectedList, percentage, lowerK, upperK);
        if (msg != null) {
          int ans = JOptionPane.showConfirmDialog(GenerateRoIPanel.this, msg, "Confirmation",
              JOptionPane.YES_NO_OPTION);
          if (ans == JOptionPane.NO_OPTION) { return; }
        }
        btnStart.setEnabled(false);
        btnCancel.setEnabled(true);
        progressBar.setVisible(true);
        worker = new SPClusteringWorker(dataset, selectedList, percentage, lowerK, upperK,
            selectedSP);
        worker.setAnnouncer(me);
        worker.addPropertyChangeListener(new PropertyChangeListener()
        {
          public void propertyChange(final PropertyChangeEvent event) {
            if (event.getPropertyName().equals("progress")) {
              progressBar.setIndeterminate(false);
              progressBar.setValue((Integer) event.getNewValue());
            }
            else {
              if (event.getPropertyName().equals("state")) {
                switch ((StateValue) event.getNewValue()) {
                  case DONE:
                    try {
                      Integer result = worker.get();
                      if (result != 0) progressBar.setValue(0);
                    }
                    catch (Exception e) {
                      e.printStackTrace();
                    }
                    btnStart.setEnabled(true);
                    btnCancel.setEnabled(false);
                    // workDone();
                    break;
                  case STARTED:
                  case PENDING:
                    progressBar.setIndeterminate(true);
                    break;
                }
              }
            }
          }
        });
        worker.execute();
      }
    });
    buttonPanel.add(btnStart);
    buttonPanel.add(Box.createRigidArea(space));

    cancelAction = new AbstractAction("Cancel")
    {
      private static final long serialVersionUID = 7666652133260327969L;

      public void actionPerformed(final ActionEvent e) {
        // mw.goHome();
        worker.cancel(true);
      }
    };
    btnCancel = new JButton(cancelAction);
    btnCancel.setEnabled(false);
    buttonPanel.add(btnCancel);
    buttonPanel.add(Box.createRigidArea(space));

    JButton btnClose = new JButton("Close");
    btnClose.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        mw.goHome();
      }
    });
    buttonPanel.add(btnClose);
    mainPanel.add(buttonPanel);
  }

  private JPanel createLabelPanel(String text) {
    JPanel result = new JPanel();
    result.setLayout(new BoxLayout(result, BoxLayout.X_AXIS));
    result.add(Box.createHorizontalGlue());
    result.add(Box.createRigidArea(space));
    result.add(new JLabel(text));
    result.add(Box.createRigidArea(space));
    return result;
  }

  private JPanel createComponentPanel(JComponent component, String text) {
    JPanel result = new JPanel();
    result.setLayout(new BoxLayout(result, BoxLayout.X_AXIS));
    result.add(Box.createRigidArea(space));
    result.add(component);
    result.add(new JLabel(text));
    result.add(Box.createHorizontalGlue());
    return result;
  }

  private String getPopupMsg(List<String> selectedList, int percentage, int lowerK, int upperK) {
    int popupMessageDecision = 0;
    if (dataset.getType() == DataSet.Type.GPS) {
      File RoIFolder = new File(dataset.getOutputPath() + File.separator + "RoIs");
      if (RoIFolder.exists()) {
        File theParaRoISubfoler = new File(RoIFolder + "/" + selectedSP);
        if (theParaRoISubfoler.exists()) {
          HashSet<String> selectedUsers = new HashSet<String>(selectedList);
          String[] RoIFiles = theParaRoISubfoler.list();
          for (String aFile : RoIFiles) {
            String[] fields = aFile.split("-");
            String[] theUsers = fields[0].split("_");
            HashSet<String> usersAnRoIFile = new HashSet<String>();
            for (String aUser : theUsers) {
              usersAnRoIFile.add(aUser);
            }
            if (usersAnRoIFile.equals(selectedUsers)) {
              if (fields[1].equals(percentage + "_" + lowerK + "_" + upperK + ".txt")) {
                popupMessageDecision = 1;
              }
              else {
                if (popupMessageDecision != 1) {
                  popupMessageDecision = 2;
                }
              }
            }

            if (usersAnRoIFile.containsAll(selectedUsers)) {
              if (popupMessageDecision != 1 && popupMessageDecision != 2) {
                popupMessageDecision = 3;
              }
            }
          }
        }
      }
    }
    else {
      HashSet<String> selectedUsers = new HashSet<String>(selectedList);
      File RoIFolder = new File(dataset.getOutputPath() + File.separator + "RoIs");
      if (RoIFolder.exists()) {
        String[] RoIFiles = RoIFolder.list();
        for (String aFile : RoIFiles) {
          String[] fields = aFile.split("-");
          String[] users = fields[0].split("_");
          HashSet<String> usersAnRoIFile = new HashSet<String>();
          for (String aUser : users) {
            usersAnRoIFile.add(aUser);
          }

          if (usersAnRoIFile.equals(selectedUsers)) {
            if (fields[1].equals(percentage + "_" + lowerK + "_" + upperK + ".txt")) {
              popupMessageDecision = 1;
            }
            else {
              if (popupMessageDecision != 1) {
                popupMessageDecision = 2;
              }
            }
          }

          if (usersAnRoIFile.containsAll(selectedUsers)) {
            if (popupMessageDecision != 1 && popupMessageDecision != 2) {
              popupMessageDecision = 3;
            }
          }
        }
      }
    }
    if (popupMessageDecision == 1) { return "You have generated the RoI file of these "
        + "selected users using these parameters." + "\nDo you want to do it again?"; }
    if (popupMessageDecision == 2) { return "You have generated the RoI file of these "
        + "selected users using a different parameter setting.\nDo you want to do it "
        + "using the current parameter setting?"; }
    if (popupMessageDecision == 3) { return "You have generated an RoI file whose users"
        + " include these selected users.\nDo you want to continue generating their RoI file?"; }
    return null;
  }

  public void addMessage(String html) {
    try {
      kit.insertHTML(doc, doc.getLength(), html, 0, 0, null);
    }
    catch (BadLocationException e) {
      e.printStackTrace();
    }
    catch (IOException e) {
      e.printStackTrace();
    }
  }
}
