/**
 * Author: Piotr Kordy (piotr.kordy@uni.lu <mailto:piotr.kordy@uni.lu>)
 * Date:   06/06/2014
 * Copyright (c) 2014,2013 University of Luxembourg
 * All rights reserved.
 * Licensed under GNU Affero General Public License 3.0;
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU Affero General Public License as
 *    published by the Free Software Foundation, either version 3 of the
 *    License, or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Affero General Public License for more details.
 *
 *    You should have received a copy of the GNU Affero General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
//http://www.drdobbs.com/security/encrypted-preferences-in-java/184416587
package lu.uni.minus.ui;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

import lu.uni.minus.preferences.Settings;

/**
 * Class containing the main window of the application
 *
 * @author Piotr Kordy
 */
public class MainWindow extends JFrame
{
  private static final long serialVersionUID = 5166621465142322036L;
  private Settings settings;
  private JSplitPane mainSplitPane;
  private DataSetsPanel dataSetPane;
  private MainMenu mainMenu;

  public MainWindow()
  {
    super("MinUS Tool");
    settings=new Settings();
    createRootWindow();
    showFrame();
  }

  private void createRootWindow()
  {
    mainSplitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
    mainSplitPane.setOneTouchExpandable(true);
    mainSplitPane.setContinuousLayout(true);
    mainSplitPane.setResizeWeight(0.0);
    mainMenu=new MainMenu(this);
    setJMenuBar(mainMenu);
    dataSetPane = new DataSetsPanel(settings);
    mainSplitPane.setLeftComponent(dataSetPane);
    add(mainSplitPane);
  }
  
  private void showFrame()
  {
		setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
    final JCheckBox checkbox = new JCheckBox("Do not show this message again.");  
    String message = "Are you sure you want to exit?";  
    final JPanel messagePanel = new JPanel();
    messagePanel.setLayout(new GridLayout(2,0));
    messagePanel.add(new JLabel(message));
    checkbox.setFont(new Font("Serif",Font.PLAIN,10));
    messagePanel.add(checkbox);
    final JFrame parent=this;
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				if(settings.getShowExit() == true) {
          int ans = JOptionPane.showConfirmDialog(parent, messagePanel, "Confirm exit", JOptionPane.YES_NO_OPTION);  
          settings.setShowExit(!checkbox.isSelected());  
					if (ans == JOptionPane.YES_OPTION) {
            System.exit(0);
					}
				}
        else{
				  System.exit(0);
        }
			}
		});
    setVisible(true);
    setMinimumSize(new Dimension(100,100));
    setPreferredSize(new Dimension(800,500));
  }

	/**
	 * Sets the content to the inital page
	 *
	 */
	public void goHome()
  {
    MainMenu.getHelpStartPage().actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED,null));
  }
	/**
	 * Sets the main content panel of the application
	 *
	 * @param pane
	 */
	public void setContent(JComponent pane)
  {
    mainSplitPane.setRightComponent(pane);
  }

	/**
	 * @return the settings
	 */
	public Settings getSettings() {
		return settings;
	}

	/**
	 * @param settings the settings to set
	 */
	public void setSettings(Settings settings) {
		this.settings = settings;
	}

	/**
   * @return the dataSetPane
   */
  public DataSetsPanel getDataSetPane() {
    return dataSetPane;
  }

}
