package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

import lu.uni.minus.utils.TextPaneWorker;

/**
 * Dialog showing progress.
 *
 * @author Piotr Kordy
 */
public class ProgressDialog extends JDialog implements Announcer
{
  private static final long serialVersionUID = 3420837293089827169L;
  private Action cancelAction;
  private JTextPane messageArea;
  private JProgressBar progressBar;
  private TextPaneWorker worker;
  private HTMLEditorKit kit;
  private HTMLDocument doc;
  /**
   * Default constructor
   */
  public ProgressDialog(MainWindow parent, TextPaneWorker aWorker) {
    super(parent);
    worker = aWorker;
    initCloseListener();
    initActions();
    initUI();
  }

  /**
   * Create the dialog.
   */
  public final void initUI() {
    setVisible(false);
    JPanel mainPane = new JPanel();
    Border paneEdge = BorderFactory.createEmptyBorder(20, 20, 20, 20);
    mainPane.setBorder(paneEdge);
    mainPane.setBackground(Color.white);
    mainPane.setOpaque(true);
    mainPane.setLayout(new BorderLayout(0, 0));
    messageArea = new JTextPane();
    messageArea.setPreferredSize(new Dimension(300, 200));
    messageArea.setContentType("text/html");
    messageArea.setEditable(false);
    kit = new HTMLEditorKit();
    messageArea.setEditorKit(kit);
    doc = new HTMLDocument();
    messageArea.setDocument(doc);
    add(messageArea, BorderLayout.CENTER);
    JPanel lowerPane = new JPanel();

    progressBar = new JProgressBar(0, 100);
    progressBar.setValue(0);
    progressBar.setStringPainted(true);
    progressBar.setVisible(true);
    progressBar.setIndeterminate(true);
    progressBar.setPreferredSize(new Dimension(260, 20));

    lowerPane.setLayout(new BoxLayout(lowerPane, BoxLayout.X_AXIS));
    lowerPane.add(progressBar);
    lowerPane.add(new JButton(cancelAction));
    add(lowerPane, BorderLayout.SOUTH);

    setTitle("Progress Monitor");
    setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    setLocationRelativeTo(null);
    pack();
    setVisible(true);

  }

  public void addMessage(String html) {
    try {
      kit.insertHTML(doc, doc.getLength(), html, 0, 0, null);
    }
    catch (BadLocationException e) {
      e.printStackTrace();
    }
    catch (IOException e) {
      e.printStackTrace();
    }

  }

  private void initActions() {
    cancelAction = new AbstractAction("Cancel")
    {
      private static final long serialVersionUID = -774586177783237294L;

      public void actionPerformed(final ActionEvent e) {
        cancel();
      }
    };
  }

  private void initCloseListener() {
    getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
        KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "close");
    getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
        KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "close");
    getRootPane().getActionMap().put("close", new AbstractAction()
    {
      private static final long serialVersionUID = 2143956335533214473L;

        public void actionPerformed(ActionEvent e) {
        cancel();
      }
    });
  }

  private void cancel() {
    worker.cancel(true);
    dispose();
  }

  public void setButtonText(String text) {
    cancelAction.putValue(Action.NAME, text);
  }

  public void setProgress(Integer i) {
    progressBar.setValue(i);
  }

  public void setIndeterminate(boolean is) {
    progressBar.setIndeterminate(is);
  }
}
