package lu.uni.minus.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import lu.uni.minus.preferences.DataSet;

public class StatDSPanel extends JPanel
{
  private static final long serialVersionUID = -8263112875159039261L;
  private final MainWindow mw;
  private final Dimension space = new Dimension(6, 6);

  public StatDSPanel(MainWindow aMw, DataSet dataset) {
    mw = aMw;
    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    JPanel mainPanel = new JPanel();
    mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.X_AXIS));
    mainPanel.setBorder(new TitledBorder(null, "Dataset \"" + dataset.getName() + "\" information",
        TitledBorder.LEADING, TitledBorder.TOP, null, null));
    JPanel leftPanel = new JPanel();
    leftPanel.setLayout(new BoxLayout(leftPanel, BoxLayout.Y_AXIS));
    JPanel rightPanel = new JPanel();
    rightPanel.setLayout(new BoxLayout(rightPanel, BoxLayout.Y_AXIS));

    leftPanel.setMaximumSize(new Dimension(250, 100));

    leftPanel.add(createLabelPanel(true, "Name :"));
    leftPanel.add(Box.createRigidArea(space));
    leftPanel.add(createLabelPanel(true, "Type :"));
    leftPanel.add(Box.createRigidArea(space));
    leftPanel.add(createLabelPanel(true, "Number of users :"));
    leftPanel.add(Box.createRigidArea(space));
    leftPanel.add(createLabelPanel(true, "Input directory :"));
    leftPanel.add(Box.createRigidArea(space));
    leftPanel.add(createLabelPanel(true, "Output directory :"));
    leftPanel.add(Box.createRigidArea(space));

    rightPanel.add(createLabelPanel(false, dataset.getName()));
    rightPanel.add(Box.createRigidArea(space));
    rightPanel.add(createLabelPanel(false, dataset.getType().toString()));
    rightPanel.add(Box.createRigidArea(space));
    rightPanel.add(createLabelPanel(false,
        (new Integer(dataset.getInputPath().list().length)).toString()));
    rightPanel.add(Box.createRigidArea(space));
    rightPanel.add(createLabelPanel(false, dataset.getInputPath().toString()));
    rightPanel.add(Box.createRigidArea(space));
    rightPanel.add(createLabelPanel(false, dataset.getOutputPath().toString()));
    rightPanel.add(Box.createRigidArea(space));
    mainPanel.add(leftPanel);
    mainPanel.add(rightPanel);
    mainPanel.add(Box.createHorizontalGlue());
    JPanel buttonPanel = new JPanel();
    buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
    JButton btnClose = new JButton("Close");
    btnClose.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        mw.goHome();
      }
    });
    buttonPanel.add(btnClose);
    add(mainPanel);
    add(buttonPanel);
    add(Box.createVerticalGlue());
  }

  private JPanel createLabelPanel(boolean leftAligned, String text) {
    JPanel result = new JPanel();
    result.setLayout(new BoxLayout(result, BoxLayout.X_AXIS));
    if (leftAligned) {
      result.add(Box.createHorizontalGlue());
    }
    result.add(Box.createRigidArea(space));
    result.add(new JLabel(text));
    result.add(Box.createRigidArea(space));
    if (!leftAligned) {
      result.add(Box.createHorizontalGlue());
    }
    return result;
  }
}
