/**
 * Author: Piotr Kordy (piotr.kordy@uni.lu <mailto:piotr.kordy@uni.lu>)
 * Date:   06/06/2014
 * Copyright (c) 2014,2013 University of Luxembourg
 * All rights reserved.
 * Licensed under GNU Affero General Public License 3.0;
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU Affero General Public License as
 *    published by the Free Software Foundation, either version 3 of the
 *    License, or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Affero General Public License for more details.
 *
 *    You should have received a copy of the GNU Affero General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
//result = Viewer.class.getResourceAsStream("/viewer/epublibviewer-help.epub");
package lu.uni.minus.ui.epub;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;

import javax.swing.JPanel;
import javax.swing.JSplitPane;

import nl.siegmann.epublib.browsersupport.Navigator;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.epub.EpubReader;


public class EpubViewer extends JPanel
{
	/**
	 *
	 */
  private static final long serialVersionUID = 1041636930664130189L;
  //    private final JFrame mainWindow;
  private BrowseBar browseBar;
  private JSplitPane mainSplitPane;
  private Navigator navigator = new Navigator();
//   private NavigationHistory browserHistory;
//   private BookProcessorPipeline epubCleaner = new BookProcessorPipeline(Collections.<BookProcessor>emptyList());

  public EpubViewer(){
    createContent();
    openBook("MinUSManual.epub");
  }
  private void createContent() {
//      this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setLayout(new BorderLayout());

//     JPanel mainPanel = new JPanel(new BorderLayout());

    ContentPane htmlPane = new ContentPane(navigator);
    JPanel contentPanel = new JPanel(new BorderLayout());
    contentPanel.add(htmlPane, BorderLayout.CENTER);
    this.browseBar = new BrowseBar(navigator, htmlPane);
    contentPanel.add(browseBar, BorderLayout.SOUTH);

    mainSplitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
    mainSplitPane.setLeftComponent(new TableOfContentsPane(navigator));
    mainSplitPane.setRightComponent(contentPanel);
    mainSplitPane.setOneTouchExpandable(true);
    mainSplitPane.setContinuousLayout(true);
    mainSplitPane.setResizeWeight(0.0);

    add(mainSplitPane, BorderLayout.CENTER);
    setPreferredSize(new Dimension(1000, 750));
//      add(new NavigationBar(navigator), BorderLayout.NORTH);

//     this.add(mainPanel);
//     this.pack();
    mainSplitPane.setDividerLocation(0.2d);
//     this.setVisible(true);
  }

  private void openBook(String name){
    try {
      InputStream in=EpubViewer.class.getResourceAsStream("/manual/"+name);
      Book book = (new EpubReader()).readEpub(in);
      navigator.gotoBook(book, this);
    }
    catch (IOException e) {
      System.err.println(e.getMessage());
    }
  }
}
