package lu.uni.minus.utils;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.List;

import javax.swing.JOptionPane;

import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.ExtractFPSPanel;

public class PSExtractor implements Runnable
  {
    private DataSet dataset;
    private ExtractFPSPanel ePanel;
    private List<String> list;
    private double threshold;
    private double tolerance;
    private double side;
    private String roiFile;
    private byte typeDay;
    private String selectedSP;
    private File fpsDir;

    public PSExtractor(DataSet aDataset,ExtractFPSPanel pr, List<String> aList, double aThreshold, double aTolerance, double aSide,
        String aRoIFile, byte aTypeDay, String aSelectedSP, File aDir) {
      dataset=aDataset;
      ePanel=pr;
      list = aList;
      threshold = aThreshold;
      tolerance = aTolerance;
      side = aSide;
      roiFile = aRoIFile;
      typeDay = aTypeDay;
      selectedSP = aSelectedSP;
      fpsDir = aDir;
    }

    public void run() {
      double minLatitude = 0.0;
      double maxLatitude = 0.0;
      double minLongitude = 0.0;
      double maxLongitude = 0.0;
      File statRoIFilePath = new File(dataset.createStatRoIDir(selectedSP) +File.separator+ roiFile);
      try {
        BufferedReader bf = new BufferedReader(new FileReader(statRoIFilePath));
        String aLine;
        int i = 0;
        while ((aLine = bf.readLine()) != null && i < 4) {
          if (i == 0) {
            minLatitude = Double.parseDouble(aLine.trim());
          }
          else if (i == 1) {
            minLongitude = Double.parseDouble(aLine.trim());
          }
          else if (i == 2) {
            maxLatitude = Double.parseDouble(aLine.trim());
          }
          else if (i == 3) {
            maxLongitude = Double.parseDouble(aLine.trim());
          }
          i++;
        }
        bf.close();
      }
      catch (Exception e) {
        e.printStackTrace();
        EventQueue.invokeLater(new Runnable()
        {
          public void run() {
            JOptionPane
                .showMessageDialog(
                    null,
                    "An error occurred when reading coordinates of min and max points of the RoI file.",
                    "Error", JOptionPane.ERROR_MESSAGE);
            ePanel.btnStart.setEnabled(true);
            return;
          }
        });
      }

      if (!fpsDir.exists()) {
        fpsDir.mkdirs();
      }
      for (String aUser : list) {
        try {
          Process p;
          if (dataset.getType() == DataSet.Type.GPS) {
            String[] cmd = {
                "tmp-linux",
                dataset.getOutputPath() + File.separator + "StayPoints" + File.separator
                    + selectedSP + File.separator + aUser + ".txt",
                "" + threshold,
                "" + tolerance,
                "-static",
                dataset.getOutputPath() + File.separator + "RoIs" + File.separator + selectedSP
                    + File.separator + roiFile, "-no_interpolate", "-side", "" + side,
                "-minlatitude", "" + minLatitude, "-maxlatitude", "" + maxLatitude,
                "-minlongitude", "" + minLongitude, "-maxlongitude", "" + maxLongitude,
                "-outputpath", fpsDir.getAbsolutePath(), "-weekdays", "" + typeDay };
            p = ProcessRunner.getTMPProcess(cmd, this);
          }
          else {
            String[] cmd = { "tmp-linux", dataset.getInputPath() + File.separator + aUser + ".txt",
                "" + threshold, "" + tolerance, "-static",
                dataset.getOutputPath() + File.separator + "RoIs" + File.separator + roiFile,
                "-no_interpolate", "-side", "" + side, "-minlatitude", "" + minLatitude,
                "-maxlatitude", "" + maxLatitude, "-minlongitude", "" + minLongitude,
                "-maxlongitude", "" + maxLongitude, "-outputpath", fpsDir.getAbsolutePath(),
                "-weekdays", "" + typeDay };
            p = ProcessRunner.getTMPProcess(cmd, this);
          }

          BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
          BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
          String line;
          while ((line = bri.readLine()) != null) {
            ePanel.addMessage(line + "\n");
          }
          bri.close();
          while ((line = bre.readLine()) != null) {
            ePanel.addMessage(line + "\n");
          }
          bre.close();
          ePanel.addMessage("****************************************************************\n");
        }
        catch (Exception e) {
          e.printStackTrace();
        }
      }
      EventQueue.invokeLater(new Runnable()
      {
        public void run() {
          ePanel.btnStart.setEnabled(true);
        }
      });
    }
  }

