/*
 * Decompiled with CFR 0.152.
 */
package main;

import main.Beta;
import main.CalcSettings;
import main.HelpFunc;
import main.Obs;

public class BetaSF
extends Beta {
    int s;
    int f;

    public BetaSF(int success, int failure, CalcSettings cs) {
        this.s = success;
        this.f = failure;
        this.chopSize = cs.chopSize;
        this.chopStep = 1.0 / (double)this.chopSize;
    }

    public BetaSF(Obs[] obss, CalcSettings cs) {
        this.s = 0;
        this.f = 0;
        Obs[] obsArray = obss;
        int n = obss.length;
        int n2 = 0;
        while (n2 < n) {
            Obs obs = obsArray[n2];
            this.s += obs.s;
            this.f += obs.f;
            ++n2;
        }
        this.chopSize = cs.chopSize;
        this.chopStep = 1.0 / (double)this.chopSize;
    }

    public BetaSF(Obs z, CalcSettings cs) {
        this(new Obs[]{z}, cs);
    }

    @Override
    public double getValueAt(int loc) {
        if (loc >= 0 && loc < this.chopSize) {
            double locR = this.chopStep * (double)loc + this.chopStep / 2.0;
            double factor = Math.pow(locR, this.s) * Math.pow(1.0 - locR, this.f);
            return this.chopStep * HelpFunc.bfi(this.s + 1, this.f + 1, factor) * factor;
        }
        throw new RuntimeException("Value out of range");
    }

    @Override
    public double getEV() {
        return ((double)this.s + 1.0) / ((double)(this.s + this.f) + 2.0);
    }

    @Override
    protected String betaFileHeader(String sep) {
        return String.valueOf(this.getClass().getName()) + sep + this.chopSize;
    }

    @Override
    public double getVariance() {
        double a = this.s + 1;
        double b = this.f + 1;
        return a * b / ((a + b) * (a + b) * (a + b + 1.0));
    }

    @Override
    public Obs getClosestBeta() {
        return new Obs(this.s, this.f);
    }

    @Override
    public Beta.BetaData getEntryData() {
        return new Beta.BetaData(this.getClass(), new Obs(this.s, this.f), null, null, null, null, 0, null, 0.0, 0.0);
    }
}

