/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import main.CalcSettings;
import main.Entanglement;
import main.HelpFunc;
import main.Obs;
import main.Param;
import main.SingletonChi;

public abstract class Chi {
    protected Param myPar;
    protected Obs myObs;
    protected Entanglement sysDist;
    protected int chopSize;
    protected CalcSettings settings;

    protected static double isDistr(Chi chi) {
        double sum = 0.0;
        Iterator<Obs.Selection> ws = Obs.monteCarlo(chi.sysDist);
        while (ws.hasNext()) {
            Obs.Selection os = ws.next();
            Obs w = os.observation;
            double weight = os.weight;
            sum += chi.getProb(w) * weight;
        }
        return sum;
    }

    public static Chi getChi(Param p, Obs o, CalcSettings cs) {
        try {
            Chi c = cs.chiType.newInstance();
            c.myPar = p;
            c.myObs = o;
            c.sysDist = cs.systemSizeDistribution;
            c.chopSize = cs.chopSize;
            c.settings = cs;
            return c;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getParamDependancy(Class<? extends Chi> c) throws ChiIncorrectlyImplementedException {
        try {
            return (String)c.getMethod("getParamDependency", null).invoke(null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new ChiIncorrectlyImplementedException("Implementation of lying strategy is invalid.");
    }

    public static double getOrderPriority(Class<? extends Chi> c) throws ChiIncorrectlyImplementedException {
        try {
            return (Double)c.getMethod("getOrderPriority", null).invoke(null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new ChiIncorrectlyImplementedException("Implementation of lying strategy is invalid.");
    }

    public static String getUIName(Class<? extends Chi> c) throws ChiIncorrectlyImplementedException {
        try {
            return (String)c.getMethod("getUIName", null).invoke(null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new ChiIncorrectlyImplementedException("Implementation of lying strategy is invalid.");
    }

    public abstract double getProb(Obs var1);

    public static ComboBoxModel getLyingStrategies() {
        return new DefaultComboBoxModel<UglyItem>(Chi.getStrategies());
    }

    private static UglyItem[] getStrategies() {
        File fh = new File("");
        File fg = new File(String.valueOf(fh.getAbsolutePath()) + File.separator + "bin");
        if (!fg.exists() || !fg.isDirectory()) {
            fg = fh;
        }
        File f = new File(String.valueOf(fg.getAbsolutePath()) + File.separator + "lyingStrategies");
        LinkedList<String> ls = null;
        if (!f.exists()) {
            ls = HelpFunc.getClassNamesInPackage("lyingStrategies");
        } else {
            ls = new LinkedList();
            File[] fs = f.listFiles();
            int i = 0;
            while (i < fs.length) {
                if (fs[i].getName().endsWith(".class")) {
                    ls.add(fs[i].getName().substring(0, fs[i].getName().length() - 6));
                }
                ++i;
            }
        }
        TreeSet<UglyItem> res = new TreeSet<UglyItem>();
        for (String classStr : ls) {
            Class<?> c = null;
            try {
                c = Class.forName("lyingStrategies." + classStr);
                res.add(new UglyItem(Chi.getUIName(c), c, Chi.getOrderPriority(c)));
            }
            catch (ChiIncorrectlyImplementedException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return Chi.convert(res);
    }

    private static UglyItem[] getStrategiesUnsafe() throws ChiIncorrectlyImplementedException {
        File fh = new File("");
        File fg = new File(String.valueOf(fh.getAbsolutePath()) + File.separator + "bin");
        if (!fg.exists() || !fg.isDirectory()) {
            fg = fh;
        }
        File f = new File(String.valueOf(fg.getAbsolutePath()) + File.separator + "lyingStrategies");
        LinkedList<String> ls = null;
        if (!f.exists()) {
            ls = HelpFunc.getClassNamesInPackage("lyingStrategies");
        } else {
            ls = new LinkedList();
            File[] fs = f.listFiles();
            int i = 0;
            while (i < fs.length) {
                if (fs[i].getName().endsWith(".class")) {
                    ls.add(fs[i].getName().substring(0, fs[i].getName().length() - 6));
                }
                ++i;
            }
        }
        TreeSet<UglyItem> res = new TreeSet<UglyItem>();
        for (String classStr : ls) {
            Class<?> c = null;
            try {
                c = Class.forName("lyingStrategies." + classStr);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            try {
                res.add(new UglyItem(Chi.getUIName(c), c, Chi.getOrderPriority(c)));
            }
            catch (ChiIncorrectlyImplementedException e) {
                res.add(new UglyItem("Unknown", c, 3.0));
            }
        }
        return Chi.convert(res);
    }

    public static String checkAllStrategies() {
        UglyItem[] u = null;
        try {
            u = Chi.getStrategiesUnsafe();
        }
        catch (ChiIncorrectlyImplementedException ex) {
            return "Class could not be properly loaded: " + ex.getOffendingClass();
        }
        int i = 0;
        while (i < u.length) {
            Class<? extends Chi> c = u[i].c;
            try {
                Chi.getUIName(c);
            }
            catch (ChiIncorrectlyImplementedException e) {
                return "The class " + c.getSimpleName() + " has no (or improperly defined) getUIName method. The method getUIName() should return a string.";
            }
            try {
                String s = Chi.getParamDependancy(c);
                if (s.equals("singleton")) {
                    Class<?>[] cs = c.getInterfaces();
                    boolean b = false;
                    int j = 0;
                    while (j < cs.length) {
                        if (cs[j].equals(SingletonChi.class)) {
                            b = true;
                        }
                        ++j;
                    }
                    if (!b) {
                        return "The class " + c.getSimpleName() + " claims to be a point distribution, but does not implement the SingletonChi interface.";
                    }
                }
            }
            catch (ChiIncorrectlyImplementedException e) {
                return "The class " + c.getSimpleName() + " has no (or improperly defined) getParamDependancy method. The method getParamDependancy() should return a string.";
            }
            try {
                Chi.getOrderPriority(c);
            }
            catch (ChiIncorrectlyImplementedException e) {
                return "The class " + c.getSimpleName() + " has no (or improperly defined) getOrderPriority method. The method getOrderPriority() should return a double.";
            }
            ++i;
        }
        return null;
    }

    private static UglyItem[] convert(SortedSet<UglyItem> res) {
        UglyItem[] result = new UglyItem[res.size()];
        Iterator it = res.iterator();
        int i = 0;
        while (i < result.length) {
            result[i] = (UglyItem)it.next();
            ++i;
        }
        return result;
    }

    public static class ChiIncorrectlyImplementedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private File f;

        public ChiIncorrectlyImplementedException(String string) {
            super(string);
        }

        public ChiIncorrectlyImplementedException(File file) {
            this.f = file;
        }

        public String getOffendingClass() {
            return this.f.getName();
        }
    }

    public static class UglyItem
    implements Comparable<UglyItem> {
        String name;
        Class<? extends Chi> c;
        double prio;

        public UglyItem(String name, Class<? extends Chi> c, double prio) {
            this.name = name;
            this.c = c;
            this.prio = prio;
        }

        public String toString() {
            return this.name;
        }

        public Class<? extends Chi> getClazz() {
            return this.c;
        }

        @Override
        public int compareTo(UglyItem b) {
            int res = Double.compare(this.prio, b.prio);
            if (res == 0) {
                return this.name.compareTo(b.name);
            }
            return res;
        }
    }
}

