/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import main.Chi;
import main.HelpFunc;

public abstract class Entanglement {
    protected static final String ID_SEP = ";";

    public abstract double getProb(int var1);

    public abstract int getMaxSize();

    public abstract int getImpact(int var1);

    public abstract String systDistFileHeader();

    public abstract int getExpectedSize();

    public abstract Entanglement parseHeader(String var1, int var2);

    public static double isDistr(Entanglement id) {
        double sum = 0.0;
        int i = 0;
        while (i < id.getMaxSize() * 1) {
            sum += id.getProb(i);
            ++i;
        }
        return sum;
    }

    public static double getOrderPriority(Class<? extends Entanglement> c) throws EntanglementIncorrectlyImplementedException {
        try {
            return (Double)c.getMethod("getOrderPriority", null).invoke(null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new EntanglementIncorrectlyImplementedException("Implementation of lying strategy is invalid.");
    }

    public static String getUIName(Class<? extends Entanglement> c) throws EntanglementIncorrectlyImplementedException {
        try {
            return (String)c.getMethod("getUIName", null).invoke(null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new EntanglementIncorrectlyImplementedException("Implementation of lying strategy is invalid.");
    }

    public static UglyItem[] getEntanglements() {
        File fh = new File("");
        File fg = new File(String.valueOf(fh.getAbsolutePath()) + File.separator + "bin");
        if (!fg.exists() || !fg.isDirectory()) {
            fg = fh;
        }
        File f = new File(String.valueOf(fg.getAbsolutePath()) + File.separator + "entanglements");
        LinkedList<String> ls = null;
        if (!f.exists()) {
            ls = HelpFunc.getClassNamesInPackage("entanglements");
        } else {
            ls = new LinkedList();
            File[] fs = f.listFiles();
            int i = 0;
            while (i < fs.length) {
                if (fs[i].getName().endsWith(".class")) {
                    ls.add(fs[i].getName().substring(0, fs[i].getName().length() - 6));
                }
                ++i;
            }
        }
        TreeSet<UglyItem> res = new TreeSet<UglyItem>();
        for (String classStr : ls) {
            Class<?> c = null;
            try {
                c = Class.forName("entanglements." + classStr);
                res.add(new UglyItem(Entanglement.getUIName(c), c, Entanglement.getOrderPriority(c)));
            }
            catch (EntanglementIncorrectlyImplementedException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return Entanglement.convert(res);
    }

    private static UglyItem[] convert(SortedSet<UglyItem> res) {
        UglyItem[] result = new UglyItem[res.size()];
        Iterator it = res.iterator();
        int i = 0;
        while (i < result.length) {
            result[i] = (UglyItem)it.next();
            ++i;
        }
        return result;
    }

    private static UglyItem[] getEntanglementsUnsafe() throws Chi.ChiIncorrectlyImplementedException {
        File fh = new File("");
        File fg = new File(String.valueOf(fh.getAbsolutePath()) + File.separator + "bin");
        if (!fg.exists() || !fg.isDirectory()) {
            fg = fh;
        }
        File f = new File(String.valueOf(fg.getAbsolutePath()) + File.separator + "entanglements");
        LinkedList<String> ls = null;
        if (!f.exists()) {
            ls = HelpFunc.getClassNamesInPackage("entanglements");
        } else {
            ls = new LinkedList();
            File[] fs = f.listFiles();
            int i = 0;
            while (i < fs.length) {
                if (fs[i].getName().endsWith(".class")) {
                    ls.add(fs[i].getName().substring(0, fs[i].getName().length() - 6));
                }
                ++i;
            }
        }
        TreeSet<UglyItem> res = new TreeSet<UglyItem>();
        for (String classStr : ls) {
            Class<?> c = null;
            try {
                c = Class.forName("entanglements." + classStr);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            try {
                res.add(new UglyItem(Entanglement.getUIName(c), c, Entanglement.getOrderPriority(c)));
            }
            catch (EntanglementIncorrectlyImplementedException e) {
                res.add(new UglyItem("Unknown", c, 3.0));
            }
        }
        return Entanglement.convert(res);
    }

    public static String checkAllEntanglements() {
        UglyItem[] u = null;
        try {
            u = Entanglement.getEntanglementsUnsafe();
        }
        catch (Chi.ChiIncorrectlyImplementedException ex) {
            return "Class could not be properly loaded: " + ex.getOffendingClass();
        }
        int i = 0;
        while (i < u.length) {
            Class<? extends Entanglement> c = u[i].c;
            try {
                Entanglement.getUIName(c);
            }
            catch (EntanglementIncorrectlyImplementedException e) {
                return "The class " + c.getSimpleName() + " has no (or improperly defined) getUIName method. The method getUIName() should return a string.";
            }
            try {
                Entanglement.getOrderPriority(c);
            }
            catch (EntanglementIncorrectlyImplementedException e) {
                return "The class " + c.getSimpleName() + " has no (or improperly defined) getOrderPriority method. The method getOrderPriority() should return a double.";
            }
            ++i;
        }
        return null;
    }

    public static class EntanglementIncorrectlyImplementedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private File f;

        public EntanglementIncorrectlyImplementedException(String string) {
            super(string);
        }

        public EntanglementIncorrectlyImplementedException(File file) {
            this.f = file;
        }

        public String getOffendingClass() {
            return this.f.getName();
        }
    }

    public static enum LambdaTypes {
        Poisson;

    }

    public static class UglyItem
    implements Comparable<UglyItem> {
        String name;
        Class<? extends Entanglement> c;
        double prio;

        public UglyItem(String name, Class<? extends Entanglement> c, double prio) {
            this.name = name;
            this.c = c;
            this.prio = prio;
        }

        public String toString() {
            return this.name;
        }

        public Class<? extends Entanglement> getClazz() {
            return this.c;
        }

        @Override
        public int compareTo(UglyItem b) {
            int res = Double.compare(this.prio, b.prio);
            if (res == 0) {
                return this.name.compareTo(b.name);
            }
            return res;
        }
    }
}

