/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.Random;
import main.Beta;
import main.Obs;
import main.Param;

public class Graph {
    private final Beta beta;
    private final int chopSize;
    private final double chopStep;
    private Color color;
    private int id;

    public Graph(Beta b) {
        this.beta = b;
        this.chopSize = b.chopSize;
        this.chopStep = 1.0 / (double)this.chopSize;
        this.color = this.changeColor();
        Random r = new Random();
        this.id = r.nextInt();
    }

    public double getMaxValue() {
        if (this.beta != null) {
            return (Double)this.beta.maxVal().first;
        }
        throw new RuntimeException("Only beta distributions are currently supported.");
    }

    public Point[] getPointIterator(Rectangle rect) {
        if (this.beta != null) {
            double hc = (double)rect.height / this.getMaxValue() * (double)this.chopSize;
            double wc = (double)rect.width * this.chopStep;
            Point[] result = new Point[this.chopSize];
            int i = 0;
            while (i < this.chopSize) {
                result[i] = new Point((int)Math.round(((double)i + 0.5) * wc) + rect.x, (int)Math.round(this.beta.getValueAt(i) * hc) + rect.y);
                ++i;
            }
            return result;
        }
        throw new RuntimeException("Only beta distributions are currently supported.");
    }

    public boolean equals(Object g) {
        try {
            return this.id == ((Graph)g).id;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public CalcData getGraphData() {
        return new CalcData(this.beta.getEV(), (Double)this.beta.maxVal().first, ((Integer)this.beta.maxVal().second).doubleValue() * this.beta.chopStep, this.beta.getVariance(), this.beta.getRelativeEntropy(), this.beta.getEntropy(), this.beta.getClosestBeta());
    }

    public void saveToFile(File file) {
        if (this.beta == null) {
            throw new RuntimeException("Only beta distributions are currently supported.");
        }
        this.beta.saveBeta(file);
    }

    public Info getInfoOn(double x, double y) {
        Info res = new Info();
        Param p = new Param(x, this.chopSize);
        if (p.getRawValue() >= 0 && y >= 0.0 && p.getRawValue() < this.chopSize) {
            res.x = p.getValue();
            res.y = y;
            res.fx = this.beta.getValueAt(p) * (double)this.chopSize;
            res.ex = this.beta.getExpectedEntropy(p);
            return res;
        }
        return null;
    }

    public Beta.BetaData getBetaData() {
        return this.beta.getEntryData();
    }

    public Color getColor() {
        return this.color;
    }

    public Color changeColor() {
        Random r = new Random();
        this.color = new Color(r.nextInt(256), r.nextInt(256), r.nextInt(256));
        return this.color;
    }

    public void changeColor(Color c) {
        this.color = c;
    }

    public static class CalcData {
        public double ev;
        public double maxVal;
        public double mode;
        public double variance;
        public double entropy;
        public double trueEntropy;
        public Obs closestBeta = null;

        public CalcData(double ev, double maxVal, double mode, double variance, double entropy, double trueEntropy, Obs closestBeta) {
            this.ev = ev;
            this.maxVal = maxVal;
            this.mode = mode;
            this.variance = variance;
            this.entropy = entropy;
            this.trueEntropy = trueEntropy;
            this.closestBeta = closestBeta;
        }
    }

    public class Info {
        double x;
        double y;
        double fx;
        double ex;
    }
}

