/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileSystemView;
import main.Beta;
import main.BetaCT;
import main.BetaPW;
import main.BetaSF;
import main.CalcSettings;
import main.Chi;
import main.Entanglement;
import main.Graph;
import main.GraphView;
import main.MultiGraphView;
import main.Obs;

public class Main
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static Point loc;
    public static Random rand;
    public static File DEFAULT_DIR;
    private static MultiGraphView mgv;

    static {
        rand = new Random();
    }

    public static void main(String[] args) {
        String s = Chi.checkAllStrategies();
        if (s != null) {
            System.err.println(s);
            System.exit(-1);
        }
        if ((s = Entanglement.checkAllEntanglements()) != null) {
            System.err.println(s);
            System.exit(-1);
        }
        if (!(DEFAULT_DIR = new File(FileSystemView.getFileSystemView().getDefaultDirectory(), "Beta Graphs")).exists()) {
            DEFAULT_DIR.mkdir();
        }
        new Main();
    }

    public Main() {
        this.setVisible(true);
        this.setTitle("Trust Chaining Calculator");
        this.getContentPane().setLayout(null);
        this.setDefaultCloseOperation(3);
        final JSlider speedSlider = new JSlider(1, 7, 5);
        speedSlider.setMajorTickSpacing(1);
        speedSlider.setPaintTicks(true);
        speedSlider.setSnapToTicks(true);
        speedSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(1), new JLabel("<html><font size=\"1\" face=\"sans-serif\">Fastest</font></html>"));
        labelTable.put(new Integer(4), new JLabel("<html><font size=\"1\" face=\"sans-serif\">Balanced</font></html>"));
        labelTable.put(new Integer(7), new JLabel("<html><font size=\"1\" face=\"sans-serif\">Exact</font></html>"));
        speedSlider.setLabelTable(labelTable);
        speedSlider.setSize(200, speedSlider.getPreferredSize().height);
        new IBox(this.getContentPane(), "Speed:", speedSlider);
        final JComboBox<Entanglement.UglyItem> enumEnt = new JComboBox<Entanglement.UglyItem>(Entanglement.getEntanglements());
        enumEnt.setSize(enumEnt.getPreferredSize());
        new IBox(this.getContentPane(), "Distribution of the entanglement:", enumEnt);
        final JSpinner expSpinner = new JSpinner(new SpinnerNumberModel(6, 1, 200, 1));
        expSpinner.setSize(expSpinner.getPreferredSize());
        new IBox(this.getContentPane(), "Expected value of the entanglement:", expSpinner);
        final JSpinner grainSpinner = new JSpinner(new SpinnerNumberModel(100, 10, 999, 1));
        grainSpinner.setSize(grainSpinner.getPreferredSize());
        new IBox(this.getContentPane(), "Granularity of the graph (low values are quicker but coarser):", grainSpinner);
        final ObsBox obAB = new ObsBox(16, 5, true);
        new IBox(this.getContentPane(), "Observations of the source about the intermediate:", obAB);
        final ObsBox obBC = new ObsBox(8, 4, true);
        new IBox(this.getContentPane(), "Statement of the intermediate about the target:", obBC);
        final ObsBox obAC = new ObsBox(10, 6, false);
        new IBox(this.getContentPane(), "Observations of the source about the target:", obAC);
        final JComboBox enumChi = new JComboBox(Chi.getLyingStrategies());
        enumChi.setSize(enumChi.getPreferredSize());
        new IBox(this.getContentPane(), "Set the type of Chi distribution:", enumChi);
        JButton calcB = new JButton("Calculate");
        calcB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final GraphView gv = new GraphView();
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        int spe = Integer.valueOf(speedSlider.getValue()) - 1;
                        int exp = (Integer)expSpinner.getValue();
                        int gra = (Integer)grainSpinner.getValue();
                        Obs obsAB = obAB.getObs();
                        Obs statBC = obBC.getObs();
                        Obs obsAC = obAC.getObs();
                        Class<? extends Chi> chiType = ((Chi.UglyItem)enumChi.getSelectedItem()).getClazz();
                        Class<? extends Entanglement> entanglement = ((Entanglement.UglyItem)enumEnt.getSelectedItem()).getClazz();
                        Beta b = null;
                        try {
                            if (obAB.isActive() && obBC.isActive()) {
                                b = new BetaPW(obsAB, obsAC, statBC, new CalcSettings(gra, spe, entanglement.getConstructor(Integer.TYPE, Integer.TYPE).newInstance(exp, spe), chiType));
                            } else if (obAB.isActive() && !obBC.isActive()) {
                                b = new BetaCT(obsAB, obsAC, new CalcSettings(gra, spe, entanglement.getConstructor(Integer.TYPE, Integer.TYPE).newInstance(exp, spe), chiType));
                            } else if (!obAB.isActive()) {
                                b = new BetaSF(obsAC, new CalcSettings(gra, spe, entanglement.getConstructor(Integer.TYPE, Integer.TYPE).newInstance(exp, spe), chiType));
                            }
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (SecurityException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                        Graph gr = new Graph(b);
                        gv.addGraph(gr);
                        mgv.addGraph(gr);
                    }
                };
                new Thread(t).start();
            }
        });
        calcB.setSize(calcB.getPreferredSize());
        new IBox(this.getContentPane(), "Calculate data and graph using these settings:", calcB);
        IBox.vSpace(100);
        this.setSize(500, 700);
        this.setFirstWindowLocation(this.getLocationOnScreen().x + this.getWidth(), this.getLocationOnScreen().y);
        mgv = new MultiGraphView();
    }

    private void setFirstWindowLocation(int x, int y) {
        loc = new Point(x, y);
    }

    public static Point getNextWindowLocation() {
        if (loc == null) {
            loc = new Point(0, 0);
        }
        Point ret = loc;
        loc = new Point(Main.loc.x + 8, Main.loc.y + 22);
        return ret;
    }

    public static void updateMultiGraphView() {
        mgv.repaint();
    }

    private static class IBox {
        private static Point loc = new Point(10, 10);

        private IBox(Container container, String label, Component obj) {
            JLabel lab = new JLabel(label);
            lab.setLocation(loc);
            lab.setSize(lab.getPreferredSize());
            container.add(lab);
            obj.setLocation(IBox.loc.x, IBox.loc.y + lab.getHeight() + 5);
            container.add(obj);
            loc = new Point(IBox.loc.x, obj.getY() + obj.getHeight() + 15);
        }

        protected static void vSpace(int i) {
            loc = new Point(IBox.loc.x, IBox.loc.y + i);
        }
    }

    private static class ObsBox
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JSpinner success;
        private JSpinner fail;
        private JCheckBox cb;

        private ObsBox(int s, int f, boolean checkbox) {
            super(null);
            this.success = new JSpinner(new SpinnerNumberModel(s, 0, 999, 1));
            this.fail = new JSpinner(new SpinnerNumberModel(f, 0, 999, 1));
            this.success.setSize(this.success.getPreferredSize());
            this.fail.setSize(this.fail.getPreferredSize());
            this.add(this.success);
            this.fail.setLocation(this.success.getSize().width + 30, 0);
            this.add(this.fail);
            if (checkbox) {
                this.cb = new JCheckBox("", true);
                this.cb.setLocation(this.fail.getX() + this.fail.getSize().width + 30, 0);
                this.cb.setSize(this.cb.getPreferredSize());
                this.add(this.cb);
                this.setSize(new Dimension(this.cb.getX() + this.cb.getWidth(), this.fail.getHeight()));
            } else {
                this.setSize(new Dimension(this.fail.getX() + this.fail.getWidth(), this.fail.getHeight()));
            }
        }

        private Obs getObs() {
            return new Obs((Integer)this.success.getValue(), (Integer)this.fail.getValue());
        }

        private boolean isActive() {
            return this.cb.isSelected();
        }
    }

    public class SEEnum {
        public static final int MAX_SPEED = 0;
        public static final int SPEEDY = 1;
        public static final int QUICK = 2;
        public static final int BALANCED = 3;
        public static final int CAREFUL = 4;
        public static final int EXACT = 5;
        public static final int SLOW_EXACT = 6;
    }
}

