/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Iterator;

public class Param {
    public final int chopSize;
    public final double chopStep;
    private int param;

    public Param(int p, int chopSize) {
        this.param = p;
        this.chopSize = chopSize;
        this.chopStep = 1.0 / (double)chopSize;
    }

    public Param(double x, int chopSize) {
        long l = Math.round(Math.floor(x * (double)chopSize));
        this.param = (int)l;
        this.chopSize = chopSize;
        this.chopStep = 1.0 / (double)chopSize;
    }

    public double getValue() {
        return (double)this.param * this.chopStep + this.chopStep / 2.0;
    }

    public int getRawValue() {
        return this.param;
    }

    public static Iterator<Param> iterator(final int chopSize) {
        return new Iterator<Param>(){
            private int loc = 0;

            @Override
            public boolean hasNext() {
                return this.loc < chopSize;
            }

            @Override
            public Param next() {
                ++this.loc;
                return new Param(this.loc - 1, chopSize);
            }

            @Override
            public void remove() {
                throw new RuntimeException("Code should never be reached");
            }
        };
    }
}

