/*
 * ============================================================================
 *
 *       Filename:  bitsMacros.h
 *
 *    Description:  Some useful macro definitions of bits operations
 *
 *        Version:  1.0
 *        Created:  10/21/2011 12:05:31 PM
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Piotr Kordy (),
 *        Company:
 *
 * ============================================================================
 */
#ifndef _BITS_MACROS_H
#define _BITS_MACROS_H
#include "brg_types.h"
#   define REVERSE_32(v)({\
 v = ((v >> 1) & 0x55555555) | ((v & 0x55555555) << 1),\
 v = ((v >> 2) & 0x33333333) | ((v & 0x33333333) << 2),\
 v = ((v >> 4) & 0x0F0F0F0F) | ((v & 0x0F0F0F0F) << 4),\
 v = ((v >> 8) & 0x00FF00FF) | ((v & 0x00FF00FF) << 8),\
 v = ( v >> 16             ) | ( v               << 16);})
//reverse bits in bytes only
#   define BYTE_REVERSE_32(v)({\
 v = ((v >> 1) & 0x55555555) | ((v & 0x55555555) << 1),\
 v = ((v >> 2) & 0x33333333) | ((v & 0x33333333) << 2),\
 v = ((v >> 4) & 0x0F0F0F0F) | ((v & 0x0F0F0F0F) << 4);})

/* macro to swap the bytes in a 16-bit variable */
#define SWAPBYTES16(x) \
{ \
    unsigned short int data = *(unsigned short int*)&(x); \
    data = ((data & 0xff00) >> 8) |    \
           ((data & 0x00ff) << 8);     \
    *(unsigned short int*)&(x) = data;       \
}
/* macro to swap the bytes in a 32-bit variable */
#define SWAPBYTES32(x) \
{ \
    unsigned int data = *(unsigned int*)&(x); \
    data = ((data & 0xff000000) >> 24) |    \
           ((data & 0x00ff0000) >>  8) |    \
           ((data & 0x0000ff00) <<  8) |    \
           ((data & 0x000000ff) << 24);     \
    *(unsigned int*)&(x) = data;            \
}

/* macro to swap the bytes in a 64-bit variable */
#define SWAPBYTES64(x) \
{ \
    unsigned int *words = (unsigned int *)&(x); \
    unsigned int temp0;  \
    unsigned int temp1;  \
    temp0 = words[0];    \
    SWAPBYTES32(temp0);  \
    temp1 = words[1];    \
    SWAPBYTES32(temp1);  \
    words[1] = temp0;    \
    words[0] = temp1;    \
}
#endif
