template<typename nodeT>
class single_list{
private:
  nodeT* root;
  nodeT* cache_last;
  nodeT r;

public:
  single_list(){
    root = &r;
    //printf("new node nr=%x\n",(long)root);
    root->next = root;
    cache_last = root;
  }
  ~single_list(){
    //printf("delete node nr=%x\n",(long)root);
    //delete root;
  }
  inline nodeT* before_begin(){
    return root;
  }
  inline nodeT* begin(){
    return root->next;
  }
  inline nodeT* end(){
    return root;
  }
  inline nodeT* last(){
    return cache_last;
  }
  inline bool empty() {
    return root==root->next;
  }
  inline void erase_after(nodeT* where){
    if(where->next==cache_last){
      cache_last = where;
    }
    where->next=where->next->next;
  }
  inline void insert_after(nodeT* where,nodeT* what){
    if(where==cache_last){
      cache_last = what;
    }
    what->next = where->next;
    where->next = what;
  }
  inline void push_front(nodeT* what){
    if(empty()){
      cache_last = what;
    }
    what->next = root->next;
    root->next = what;
  }
};
