/*
 * ============================================================================
 *
 *       Filename:  project_test.cc
 *
 *    Description: Tests for Project class
 *
 *        Version:  1.0
 *        Created:  10/07/2011 01:40:21 PM
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Piotr Kordy (),
 *        Company:
 *
 * ============================================================================
 */
#include "gtest/gtest.h"
#include "project.h"
class Options;

//wrapper class to give access to protected members
class UnitProject : public Project {
public:
  friend class ProjectTest;
  UnitProject (Options* options):Project(options){    /* constructor */
  }
  void callParseProjectFile(){
    parseProjectFile();
  }
  void callSplitLine(std::string &line,std::vector<std::string> &result){
    splitLine(line,result);
  }
  void callAddBogusAttribute(){
    addBogusAttribute();
  }
  const vtPath &getFileNames(){
    return fileNames;
  }
  AttNamesMap &getAttributes(){
    return attributes;
  }

  void createFile(const std::string &name,const std::string &content){
    FILE * pFile;
    pFile = fopen (name.c_str(), "wb");
    fwrite (content.c_str() , 1 , content.size(), pFile );
    fclose(pFile);
  }
};

// class ProjectTest : public testing::Test {
// protected:
//   virtual void SetUp() {
//   }
// };

TEST(ProjectTest,splitLine){
  Options opt;
  std::vector<std::string> v;
  std::string line("abc");
  UnitProject proj(&opt);
  proj.callSplitLine(line,v);
  EXPECT_EQ(v[0],"abc");
  line="\'abc\'";
  proj.callSplitLine(line,v);
  EXPECT_EQ(v[0],"abc");
  line="\'ab c\' def";
  proj.callSplitLine(line,v);
  EXPECT_EQ(v[0],"ab c");
  EXPECT_EQ(v[1],"def");
  line="\'ab\\'c' '\"df\"'"; //double quotes inside single quotes test
  proj.callSplitLine(line,v);
  EXPECT_EQ(v[0],"ab\'c");
  EXPECT_EQ(v[1],"\"df\"");
  line="\'abc\' e#ua";   //comment test
  proj.callSplitLine(line,v);
  EXPECT_EQ(v[0],"abc");
  EXPECT_EQ(v[1],"e");
  EXPECT_EQ(v.size(),2u);
  line="\''   \\\"  #abc\'"; //empty string
  proj.callSplitLine(line,v);
  EXPECT_EQ(v[0],"");
  EXPECT_EQ(v[1],"\"");
  EXPECT_EQ(v.size(),2u);
}


TEST(ProjectTest,parseProjectFile){
  Options opt;
  UnitProject proj(&opt);
  std::string fileName("__proj_temp__");
  std::ostringstream content;
  content<<"bin         att1\t att2"<<std::endl;
  content<<"__f1_temp__ 1  1"<<std::endl;
  content<<"__f2_temp__ 2  1"<<std::endl;
  content<<"__f3_temp__ 3  1"<<std::endl;
  content<<"__f4_temp__ 4  1"<<std::endl;
  content<<"__f5_temp__ 5  1"<<std::endl;
  proj.createFile(fileName,content.str());
  fileName = "__f1_temp__";
  content.str("");
  content<<"1  1";
  proj.createFile(fileName,content.str());
  fileName = "__f2_temp__";
  content.str("");
  content<<"2  1";
  proj.createFile(fileName,content.str());
  fileName = "__f3_temp__";
  content.str("");
  content<<"3  1";
  proj.createFile(fileName,content.str());
  fileName = "__f4_temp__";
  content.str("");
  content<<"4  1";
  proj.createFile(fileName,content.str());
  fileName = "__f5_temp__";
  content.str("");
  content<<"5  1";
  proj.createFile(fileName,content.str());
  opt.projectFile="__proj_temp__";
  proj.callParseProjectFile();
  const vtPath fN = proj.getFileNames();
  EXPECT_EQ(fN.size(),5u);
  EXPECT_EQ(fN[0].native().compare("__f1_temp__"),0);
  EXPECT_EQ(fN[1].native().compare("__f2_temp__"),0);
  EXPECT_EQ(fN[2].native().compare("__f3_temp__"),0);
  EXPECT_EQ(fN[3].native().compare("__f4_temp__"),0);
  EXPECT_EQ(fN[4].native().compare("__f5_temp__"),0);
  AttNamesMap attr = proj.getAttributes();
  EXPECT_TRUE(attr.find("att1")!=attr.end());
  EXPECT_TRUE(attr.find("att2")!=attr.end());
  EXPECT_TRUE(attr.find("att3")==attr.end());
  EXPECT_EQ(attr.size(),2u);
  EXPECT_EQ(attr["att1"]->size(),5u);
  EXPECT_EQ(attr["att2"]->size(),1u);
  EXPECT_EQ((*attr["att1"])["1"]->at(0),0u);
  EXPECT_EQ((*attr["att1"])["2"]->at(0),1u);
  EXPECT_EQ((*attr["att1"])["3"]->at(0),2u);
  EXPECT_EQ((*attr["att1"])["4"]->at(0),3u);
  EXPECT_EQ((*attr["att1"])["5"]->at(0),4u);
  EXPECT_EQ((*attr["att2"])["1"]->at(0),0u);
  EXPECT_EQ((*attr["att2"])["1"]->at(1),1u);
  EXPECT_EQ((*attr["att2"])["1"]->at(2),2u);
  EXPECT_EQ((*attr["att2"])["1"]->at(3),3u);
  EXPECT_EQ((*attr["att2"])["1"]->at(4),4u);
  proj.callAddBogusAttribute();
  attr = proj.getAttributes();
  EXPECT_EQ((*attr["_id"])["s"]->at(0),0u);
  EXPECT_EQ((*attr["_id"])["s"]->at(1),1u);
  EXPECT_EQ((*attr["_id"])["s"]->at(2),2u);
  EXPECT_EQ((*attr["_id"])["s"]->at(3),3u);
  EXPECT_EQ((*attr["_id"])["s"]->at(4),4u);

  remove("__f1_temp__");
  remove("__f2_temp__");
  remove("__f3_temp__");
  remove("__f4_temp__");
  remove("__f5_temp__");
  remove("__proj_temp__");
}
