#! /bin/sh

# Multi-session tranformer based on: 
#
# Xihui Chen, Ton van Deursen, Jun Pang: Improving Automatic
# Verification of Protocols with XOR, submitted to ICFEM 2009
#
# Author: Xihui Chen (based on work and code by Ralf Kuesters and Tomasz
# Truderung)
#
# Prerequisites: 
# - ProVerif analyzed and added to $PATH
# - Compiled version of sec_list

echo "Input the protocol name: "
read fname
echo "Run secrecy check (y/n): "
read sc
if test $sc = "y"
then
    ./mst_gsec $fname".pl" $fname"sout">/dev/null
    rm $fname".pl-sec"
    analyzer $fname"sout" >sec
    rm $fname"sout"
    grep "RESULT goal " sec>result
    rm sec
    ./sec_list
    ./mst_general $fname".pl" $fname".out" -sc
    rm seclist
else
    ./mst_general $fname".pl" $fname".out" -nsc
fi    
analyzer $fname".out"
