<?php

// ***************     QUICKSTART     ************

define('BIBLIOFILE',  'php-bibHTML-example.bib'); // location of your bibfile
define('SPLITBYTYPE', false);		          // split into categories?

// *************     END QUICKSTART     **********




/****** Configuration file for php-bibHTML  ***********
   (necessary to ensure that biblink.php uses the same bibliography file)

   Output (splitbytype === FALSE):
   - 2012:
      [1] ... [ bib | preprint ]
      [2] ... [ bib | doi ]
      [3] ...
   - 2011:
      ...
   - etc.

   Output (splitbytype === TRUE):
   - 2012:
     + Articles:
       [1]
       [2]
       [3]
     + Conference proceedings:
        ...
     + ...
   - 2011
     ...
   - etc.

   Configuration options:

   BIBLIOFILE	- path/url of default bibtex file to use
   SPLITBYTYPE	- whether to split the year-listings into
  		   journals/confs/books/etc

   PHPBIBHTMLDIR- path of php-bibHTML relative to where it's called from
   CSSFILE	- path/url of the CSS file to use
   TEMPLATEDIR	- local path to dir where php-bibHTML templates are stored
   BIBLINKFILE	- URL of the biblink.php file

   $mapfile	- a file with the mapping from LaTex code to HTML entities
   $rvwkeys	- which bibtex entries to show (only reviewed ones)
   $biblink	- what label to use for bibfields url/doi/ee/...
   		  bibfields in this array are treated as links and
		  given their label (see ex. output)
   $bibtypes	- what label (header) to use for each type (if split by type)
   		  This determines the order of the labels

   mapfile format is multiple lines, line grammar:
  	LINE ::= HTML_OPCODE TAB HTML_UNICODE TAB TEX_OPCODE
***********************************************************/


// use define for compatibility with PHP < 5.3.0
define('PHPBIBHTMLDIR',	'./php-bibHTML/');	// path of php-bibHTML install
define('CSSFILE',	PHPBIBHTMLDIR . 'css/php-bibHTML.css');
define('TEMPLATEDIR',	PHPBIBHTMLDIR . 'templates/');
define('BIBLINKFILE',	PHPBIBHTMLDIR . 'biblink.php');

$mapfile	= PHPBIBHTMLDIR . 'mapping-tex-html.txt';
$rvwkeys	= array(
			'proceedings', 'inproceedings', 'phdthesis',
			'article', 'book', 'inbook', 'incollection',
			// below: non-reviewed entries
			'misc', 'manual', 'mastersthesis', 'booklet', 
			'techreport', 'unpublished'
		);

$biblink	= array(
			'url' => 'preprint',
			'ee' => 'from publisher',
			'doi' => 'DOI'
		); 

// Label 	=>	list of bibtex types
// This also determines the order in which 
// the publications are listed -- if SPLITBYTYPE == true
$bibtypes	= array(
	'PhD Theses'		=> array('phdthesis'),
	'Books'			=> array('book', 'booklet'),
	'Editted Proceedings'	=> array('proceedings'),
	'Journal Articles'	=> array('article'),
	'Conference Proceedings' => array('inproceedings'),
	'Book Chapters'		=> array('inbook', 'incollection'),
	'Master Theses'		=> array('mastersthesis'),
	'Technical Reports'	=> array('techreport'),
	'Manuals'		=> array('manual'),
	'Miscellaneous'		=> array('misc', 'unpublished'),
	);

?>
