<?php
/* biblink.php:
  spits out requested entry of a bibtex file, or the whole file if no
  request was detected.

  Configuration:
    $bibtex	- filename of the bibtex file
    $noprint	- array of fields to suppress in output

*/

include_once('inc-parsebib.php');
include_once('conf-bibHTML.php');

$bibfile = '../' . BIBLIOFILE;		// path of the bibfile to use
// ### this assumes that the path is given relative to a dir one level up
//     from the path of the current script.


$noprint = array('preprint', 'slides'); // fields to surpress

if (!is_readable($bibfile))  {
	die ("Fatal error: bibfile '$bibfile' not found.\n");
}

// Prints a bibtex entry
function print_entry($bib, $surpress = array())  {
	// block parser-internal fields
	$surpress[] = 'bibtexCitation';
	$surpress[] = 'bibtexEntryType';

	print '@' . $bib['bibtexEntryType'] . '{' . $bib['bibtexCitation'];
	foreach($bib as $key => $value)  {
		if (in_array($key, $surpress))  {
			continue;
		}
		printf(",\n  %-13s = {%s}", $key, $value);
	}
	print "\n}\n\n";
}
	

// Parse bibtex entries
$parse = new PARSEENTRIES();
$parse->expandMacro = TRUE;
$parse->openBib($bibfile);
$parse->extractEntries();
$parse->closeBib();
list($preamble, $strings, $entries, $undefinedStrings) =
        $parse->returnArrays();

// Show a specific entry?
$id = (isset($_GET['id']) ? $_GET['id'] : 'all');

header('Content-Type: text/plain');
header('Expires: 0');

foreach($entries as $bib)  {
	if($id != 'all' && $bib['bibtexCitation'] != $id)  {
		continue;
	}
	print_entry($bib, $noprint);
}
		
?>
