#! /usr/bin/env python

"""
The procedures in this module are used to format bitstrings and masks for display.
"""

import bitstring

def bin_to_span(bb):
    r = []
    for b in bb:
        if b == True:
            r.append('g')
        else:
            r.append('r')
    return r
    
def hex_to_span(bb):
    r = []
    for b in bb:
        if b == '0':
            r.append('r')
        elif b == 'f':
            r.append('g')
        else: 
            r.append('o')
    
    return r

def bin_to_list(b):
  # takes a bitstring and returns a list of bits
    list = []
    for a in b:
        list.append(int(a))
    return list      
 
def hex_to_list(b):
  # takes a bitstring and returns a list of bits
    list = []
    for a in b:
        list.append(a)
    return list      
 
def add_span_to_bin(l, s):
    # Combines list l with span classes s
    if len(l) != len(s):
        print "add_span_to_bin: length inconsistency: ",  len(l),  "/", len(s)
    
    return ["<span class=" + str(y) + ">" + str(x) + "</span>" for x, y in zip(l, s)]

def add_differences(span, min, max):
    r = span[:]
    for i in range(min, max):
        r[i] = 'y'
    return r

def add_mask_bin(l, m):
    if len(l) != len(m):
        print "Mask_bin: length inconsistency: ",  len(l),  "/", len(m)
    
    s = bin_to_span(m)
            
    return combine_bin(l, s)
    
def add_mask_hex(l, m):
    list = bin_to_list(l.hex)[:]
    mask = m.hex[2:]
    
    if len(list) != len(m):
        print "Mask_hex: length inconsistency: ",  len(list),  "/", len(m)
    
    for i in range(len(mask)):
        if mask[i] == '0':
            list[i] = '<span class=r>' + list[i] + '</span>'
        elif mask[i] == 'f':
            list[i] = '<span class=g>' + list[i] + '</span>'
        else:
            list[i] = '<span class=o>' + list[i] + '</span>'
        
    return list
def list_add_underline(l, i, c):
    if len(l) < i+c:
        print "Underline: length inconsistency: ",  len(l),  "/", i,  "/", c
        
    # add underline of length c starting at index i
    l[i] = "<b>" + l[i]
    l[i+c-1] = l[i+c-1] + "</b>"
    return l
    
def list_add_separators(l, s):
    for i in range(len(s)):
        if s[i] == True:
            l[i] = '<span class=\"s\">' + l[i] + '</span>'
            
    return l
    
def list_add_linebreaks(l, c):
    for i in range(c-1, len(l), c):
        l[i] = l[i] + '<br />'
    return l
    
def html(l, colors):
    css = ".body {font-family: monospace; font-size: 14px}"
    css += " .g { background-color: rgb" + str(colors[0]) + "}"
    css += " .r { background-color: rgb" + str(colors[1]) + "}"
    css += " .o { background-color: orange}"
    css += " .y { background-color: rgb" + str(colors[2]) + "}"
    css += " .s { background-color: #bebebe}"
    css += " .w { background-color: white}"
    
    header = "<html><head><style type=text/css>"
    header += css
    header += "</style></head><body><span class=body>" 
    
    body = "".join(l)
    
    footer = "</span></body></html>"
    
    return header + body + footer
    
