/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.adtconverter;

import java.util.Collections;
import java.util.Vector;
import lu.uni.adtool.adtconverter.LabelDictionary;
import lu.uni.adtool.adtree.ADTNode;
import lu.uni.adtool.adtree.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EulerTree {
    private LabelDictionary ld;

    public EulerTree() {
        this.init();
    }

    private void init() {
        this.ld = new LabelDictionary();
        this.ld.store("op+");
        this.ld.store("ap+");
        this.ld.store("oo+");
        this.ld.store("ao+");
        this.ld.store("co+");
        this.ld.store("cp+");
        this.ld.store("op-");
        this.ld.store("ap-");
        this.ld.store("oo-");
        this.ld.store("ao-");
        this.ld.store("co-");
        this.ld.store("cp-");
    }

    public Vector<Operation> levenshteinPath(Vector<Integer> v1, Vector<Integer> v2) {
        int a;
        int j;
        int i;
        int[][] costs = new int[v1.size() + 1][v2.size() + 1];
        for (i = 0; i <= v1.size(); ++i) {
            costs[i][0] = i;
        }
        for (j = 1; j <= v2.size(); ++j) {
            costs[0][j] = j;
        }
        for (j = 0; j < v2.size(); ++j) {
            for (i = 0; i < v1.size(); ++i) {
                costs[i + 1][j + 1] = v1.elementAt(i).intValue() == v2.elementAt(j).intValue() ? costs[i][j] : Math.min(Math.min(costs[i + 1][j], costs[i][j + 1]), costs[i][j]) + 1;
            }
        }
        Vector<Operation> result = new Vector<Operation>();
        i = v1.size();
        j = v2.size();
        while (i != 0 && j != 0) {
            int lastValue = costs[i - 1][j - 1];
            Operation lastOp = Operation.NONE;
            if (costs[i][j] > lastValue) {
                lastOp = Operation.CHANGE;
            }
            if (costs[i][j - 1] < lastValue) {
                lastOp = Operation.ADD;
                lastValue = costs[i][j - 1];
            }
            if (costs[i - 1][j] < lastValue) {
                lastOp = Operation.DEL;
                lastValue = costs[i - 1][j];
            }
            switch (lastOp) {
                case ADD: {
                    --j;
                    break;
                }
                case DEL: {
                    --i;
                    break;
                }
                default: {
                    --i;
                    --j;
                }
            }
            result.add(lastOp);
        }
        for (a = j; a > 0; --a) {
            result.add(Operation.ADD);
        }
        for (a = i; a > 0; --a) {
            result.add(Operation.DEL);
        }
        Collections.reverse(result);
        return result;
    }

    public Vector<Integer> eulerString(ADTNode root) {
        Vector<Integer> result = new Vector<Integer>();
        return this.eulerSubstring(root, result);
    }

    private Vector<Integer> eulerSubstring(ADTNode node, Vector<Integer> result) {
        result.add(this.node2Int(node, true));
        for (Node child : node.getChildren()) {
            result = this.eulerSubstring((ADTNode)child, result);
        }
        result.add(this.node2Int(node, false));
        return result;
    }

    private Integer node2Int(ADTNode node, boolean down) {
        String ch = "-";
        if (down) {
            ch = "+";
        }
        switch (node.getType()) {
            case OO: {
                return new Integer(this.ld.store("oo" + ch));
            }
            case AO: {
                return new Integer(this.ld.store("ao" + ch));
            }
            case OP: {
                return new Integer(this.ld.store("op" + ch));
            }
            case AP: {
                return new Integer(this.ld.store("ap" + ch));
            }
            case CP: {
                return new Integer(this.ld.store("cp" + ch));
            }
            case CO: {
                return new Integer(this.ld.store("co" + ch));
            }
            case LEAFO: 
            case LEAFP: {
                return new Integer(this.ld.store(ch + node.getName()));
            }
        }
        return null;
    }

    public void transferLabels(ADTNode t1, ADTNode t2) {
        Vector<Integer> v1 = this.eulerString(t1);
        Vector<Integer> v2 = this.eulerString(t2);
        Vector<Operation> lP = this.levenshteinPath(v1, v2);
        Vector<ADTNode> index2Node1 = this.getEulerOrdering(t1);
        Vector<ADTNode> index2Node2 = this.getEulerOrdering(t2);
        int iL = 0;
        int iR = 0;
        block5: for (int index = 0; index < lP.size(); ++index) {
            switch (lP.elementAt(index)) {
                case NONE: 
                case CHANGE: {
                    ADTNode leftNode = index2Node1.elementAt(iL);
                    ADTNode rightNode = index2Node2.elementAt(iR);
                    if (leftNode.getType() != ADTNode.Type.LEAFO && leftNode.getType() != ADTNode.Type.LEAFP) {
                        leftNode.setName(rightNode.getName());
                    }
                    ++iL;
                    ++iR;
                    continue block5;
                }
                case ADD: {
                    ++iR;
                    continue block5;
                }
                case DEL: {
                    ++iL;
                }
            }
        }
    }

    private Vector<ADTNode> getEulerOrdering(ADTNode t1) {
        Vector<ADTNode> v = new Vector<ADTNode>();
        this.getEulerOrdering(t1, v);
        return v;
    }

    private void getEulerOrdering(ADTNode t, Vector<ADTNode> v) {
        v.add(t);
        for (int childrenCount = 0; childrenCount < t.getChildren().size(); ++childrenCount) {
            this.getEulerOrdering((ADTNode)t.getChildren().elementAt(childrenCount), v);
        }
        v.add(t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        NONE,
        ADD,
        DEL,
        CHANGE;

    }
}

