/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.adtree;

import java.util.Vector;
import lu.uni.adtool.Options;
import lu.uni.adtool.adtree.Node;
import lu.uni.adtool.adtree.SimpleNode;
import lu.uni.adtool.domains.Domain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADTNode
extends SimpleNode {
    private String name = "";
    protected Vector<Node> children = new Vector();
    private Type type;

    public ADTNode(int id) {
        super(id);
    }

    public Vector<Node> getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public final void setType(Type t) {
        this.type = t;
    }

    public final void setName(String n) {
        this.name = n;
    }

    public void setChildren(Vector<Node> children) {
        this.children = children;
    }

    public int getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public final void removeAllChildren(Node node) {
        for (Node n : this.getChildren()) {
            this.removeAllChildren(n);
        }
        this.getChildren().clear();
    }

    public final void removeChild(Node child) {
        if (this.children == null) {
            System.err.println("Tried to remove child from node with no children");
            return;
        }
        int index = this.getChildren().indexOf(child);
        if (index == -1) {
            System.err.println("Tried to remove child from that is not contained in children");
            return;
        }
        Vector<Node> newChildren = ((ADTNode)child).getChildren();
        this.getChildren().remove(index);
        this.getChildren().addAll(index, newChildren);
        for (Node c : newChildren) {
            c.jjtSetParent(this);
        }
    }

    public final void addChildAt(Type type, String name, int indexAt, int noChildren) {
        ADTNode child = new ADTNode(-1);
        child.setType(type);
        child.setName(name);
        Vector<Node> newChildren = null;
        if (noChildren > 0) {
            newChildren = new Vector<Node>(this.children.subList(indexAt, indexAt + noChildren));
            this.children.removeAll(newChildren);
            for (Node n : newChildren) {
                if (n == null) continue;
                n.jjtSetParent(child);
            }
        }
        this.children.add(indexAt, child);
        child.jjtSetParent(this);
        child.setChildren(newChildren);
    }

    public final boolean isEditable(Domain<?> domain) {
        boolean result = false;
        if (this.type == Type.LEAFO && domain.isValueModifiable(false)) {
            result = true;
        } else if (this.type == Type.LEAFP && domain.isValueModifiable(true)) {
            result = true;
        } else if (this.type == Type.CP) {
            Type childType = ((ADTNode)this.getChildren().elementAt(0)).getType();
            result = childType == Type.LEAFP && domain.isValueModifiable(true);
        } else if (this.type == Type.CO) {
            Type childType = ((ADTNode)this.getChildren().elementAt(0)).getType();
            result = childType == Type.LEAFO && domain.isValueModifiable(false);
        }
        return result;
    }

    private String toString(int level) {
        int i;
        String result = "";
        String indent = "";
        String currIndent = "";
        String eol = "";
        if (Options.adt_multiLine) {
            for (i = 0; i < Options.adt_indentLevel; ++i) {
                indent = indent + " ";
            }
            for (i = 0; i < level; ++i) {
                currIndent = currIndent + indent;
            }
            eol = "\n";
        }
        if (this.children != null) {
            for (i = 0; i < this.children.size(); ++i) {
                ADTNode n = (ADTNode)this.children.elementAt(i);
                if (n != null) {
                    result = result + n.toString(level + 1);
                    if (i + 1 < this.children.size()) {
                        result = result + ",";
                    }
                    result = result + eol;
                    continue;
                }
                System.err.println("Null child at index:" + i);
            }
        }
        switch (this.type) {
            case OO: {
                result = currIndent + "oo(" + eol + result + currIndent + ")";
                break;
            }
            case AO: {
                result = currIndent + "ao(" + eol + result + currIndent + ")";
                break;
            }
            case OP: {
                result = currIndent + "op(" + eol + result + currIndent + ")";
                break;
            }
            case AP: {
                result = currIndent + "ap(" + eol + result + currIndent + ")";
                break;
            }
            case CO: {
                result = currIndent + "co(" + eol + result + currIndent + ")";
                break;
            }
            case CP: {
                result = currIndent + "cp(" + eol + result + currIndent + ")";
                break;
            }
            case LEAFO: {
                result = currIndent + this.name;
                break;
            }
            case LEAFP: {
                result = currIndent + this.name;
                break;
            }
            default: {
                result = "unknown";
            }
        }
        return result;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Vector(i + 1);
        } else if (i >= this.children.size()) {
            this.children.setSize(i + 1);
        }
        this.children.set(i, n);
        n.jjtSetParent(this);
    }

    @Override
    public final Node jjtGetChild(int i) {
        return this.children.elementAt(i);
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                SimpleNode n = (SimpleNode)this.children.elementAt(i);
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        OO,
        AO,
        OP,
        AP,
        CO,
        CP,
        LEAFO,
        LEAFP;

    }
}

