/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.adtree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import lu.uni.adtool.Options;
import lu.uni.adtool.adtree.ADTreeForGui;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.domains.DomainFactory;
import lu.uni.adtool.domains.ValuationDomain;
import lu.uni.adtool.domains.ValueAssignement;
import lu.uni.adtool.domains.rings.Ring;
import lu.uni.adtool.ui.ADTermView;
import lu.uni.adtool.ui.ADTreeCanvas;
import lu.uni.adtool.ui.ADTreeView;
import lu.uni.adtool.ui.DetailsView;
import lu.uni.adtool.ui.DomainView;
import lu.uni.adtool.ui.MainWindow;
import lu.uni.adtool.ui.ValuationView;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.View;

public class ADTSerializer {
    private MainWindow mainWindow;
    private View[] views;

    public ADTSerializer(MainWindow mw) {
        this.mainWindow = mw;
        this.views = this.mainWindow.getViews();
    }

    private void writeOptions(ObjectOutputStream out) throws IOException {
        out.writeObject(Options.canv_BackgroundColor);
        out.writeObject(Options.canv_EdgesColor);
        out.writeObject(Options.canv_TextColorAtt);
        out.writeObject(Options.canv_TextColorDef);
        out.writeObject(Options.canv_FillColorAtt);
        out.writeObject(Options.canv_FillColorDef);
        out.writeObject(Options.canv_BorderColorAtt);
        out.writeObject(Options.canv_BorderColorDef);
        out.writeObject(Options.canv_EditableColor);
        out.writeObject((Object)Options.canv_ShapeAtt);
        out.writeObject((Object)Options.canv_ShapeDef);
        out.writeObject(Options.canv_Font);
        out.writeObject((Object)Options.canv_Defender);
        out.writeObject(Options.canv_ArcSize);
        out.writeObject(Options.canv_ArcPadding);
        out.writeObject(Options.canv_LineWidth);
        out.writeObject(Options.canv_DoAntialiasing);
    }

    private void readOptions(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Options.canv_BackgroundColor = (Color)in.readObject();
        Options.canv_EdgesColor = (Color)in.readObject();
        Options.canv_TextColorAtt = (Color)in.readObject();
        Options.canv_TextColorDef = (Color)in.readObject();
        Options.canv_FillColorAtt = (Color)in.readObject();
        Options.canv_FillColorDef = (Color)in.readObject();
        Options.canv_BorderColorAtt = (Color)in.readObject();
        Options.canv_BorderColorDef = (Color)in.readObject();
        Options.canv_EditableColor = (Color)in.readObject();
        Options.canv_ShapeAtt = (Options.ShapeType)((Object)in.readObject());
        Options.canv_ShapeDef = (Options.ShapeType)((Object)in.readObject());
        Options.canv_Font = (Font)in.readObject();
        Options.canv_Defender = (ADTreeNode.Type)((Object)in.readObject());
        Options.canv_ArcSize = (Integer)in.readObject();
        Options.canv_ArcPadding = (Integer)in.readObject();
        Options.canv_LineWidth = (Integer)in.readObject();
        Options.canv_DoAntialiasing = (Boolean)in.readObject();
    }

    /*
     * WARNING - void declaration
     */
    public ADTreeForGui loadVer1(ADTreeNode root, ObjectInputStream in) {
        ADTreeForGui newTree = null;
        try {
            void var12_16;
            Options.currentSaveVer = 1;
            RootWindow rootWindow = this.mainWindow.getRootWindow();
            Map childrenMap = (Map)in.readObject();
            Map parents = (Map)in.readObject();
            int maxCounter = 0;
            for (ADTreeNode node : parents.keySet()) {
                maxCounter = Math.max(maxCounter, node.getId());
                if (!node.isAboveFolded()) continue;
                node.setAboveFolded(false);
            }
            ADTreeNode.resetCounter(maxCounter + 1);
            newTree = new ADTreeForGui(root, childrenMap, parents);
            this.views[0].setComponent((Component)new ADTreeView(newTree, this.mainWindow));
            ADTreeCanvas canvas = ((ADTreeView)this.views[0].getComponent()).getCanvas();
            this.views[1].setComponent((Component)new ADTermView(canvas));
            this.views[2].setComponent((Component)new ValuationView());
            this.views[3].setComponent((Component)new DetailsView());
            this.readOptions(in);
            Boolean savedLayout = (Boolean)in.readObject();
            this.mainWindow.removeDomains();
            Vector<Integer> domainsIds = null;
            if (savedLayout.booleanValue()) {
                rootWindow.read(in, true);
                domainsIds = new Vector<Integer>();
                for (View view : this.mainWindow.getDynamicViews().values()) {
                    domainsIds.add(new Integer(((DomainView)view.getComponent()).getId()));
                }
            }
            ((ADTreeView)this.views[0].getComponent()).getCanvas().setFocus(null);
            ((ValuationView)this.views[2].getComponent()).assignCanvas(null);
            ((DetailsView)this.views[3].getComponent()).assignCanvas(null);
            Integer noDomains = (Integer)in.readObject();
            this.mainWindow.getValuations().clear();
            boolean bl = false;
            while (var12_16 < noDomains) {
                Domain<Ring> d = DomainFactory.updateDomain((Domain)in.readObject());
                ValuationDomain<Ring> vd = new ValuationDomain<Ring>(d);
                ValueAssignement vass = (ValueAssignement)in.readObject();
                vd.setValueAssPro(vass, root);
                ValueAssignement vass2 = (ValueAssignement)in.readObject();
                vd.setValueAssOpp(vass2, root);
                if (!savedLayout.booleanValue()) {
                    this.mainWindow.getValuations().put(new Integer((int)var12_16), vd);
                    View view = this.mainWindow.getDynamicView((int)var12_16);
                    System.out.println("Adding domain window when loading");
                    this.mainWindow.addDomainWindow((DockingWindow)view);
                } else {
                    this.mainWindow.getValuations().put((Integer)domainsIds.elementAt((int)var12_16), vd);
                }
                ++var12_16;
            }
            newTree.updateAllSizes();
            Options.currentSaveVer = -1;
        }
        catch (IOException e) {
            this.mainWindow.getStatusBar().reportError(e.getMessage());
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return newTree;
    }

    public void loadVerN(Integer verNo, ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (verNo == 2) {
            ADTreeForGui tree;
            String description = (String)in.readObject();
            HashMap comments = (HashMap)in.readObject();
            Object o = in.readObject();
            if (o instanceof ADTreeNode && (tree = this.loadVer1((ADTreeNode)o, in)) != null) {
                tree.setDescription(description);
                tree.setComments(comments);
            }
        } else {
            this.mainWindow.getStatusBar().reportError("Loading not implemented for version of the save: " + verNo);
        }
    }

    public void loadFromStreamTree(ObjectInputStream in) {
        if (in != null) {
            try {
                Object o = in.readObject();
                if (o instanceof ADTreeNode) {
                    this.loadVer1((ADTreeNode)o, in);
                    this.mainWindow.updateDynamicViewTitles();
                } else if (o instanceof Integer) {
                    this.loadVerN((Integer)o, in);
                }
                in.close();
            }
            catch (IOException e) {
                this.mainWindow.getStatusBar().reportError(e.getMessage());
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void saveToStreamTree(ObjectOutputStream out) {
        if (out != null) {
            try {
                HashMap<Integer, MainWindow.DynamicView> dynamicViews = this.mainWindow.getDynamicViews();
                ADTreeForGui tree = ((ADTreeView)this.views[0].getComponent()).getCanvas().getTree();
                out.writeObject(Options.saveVersion);
                out.writeObject(tree.getDescription());
                out.writeObject(tree.getComments());
                out.writeObject(tree.getRoot(true));
                out.writeObject(tree.getChildrenMap());
                out.writeObject(tree.getParents());
                this.writeOptions(out);
                out.writeObject(new Boolean(Options.main_saveLayout));
                if (Options.main_saveLayout) {
                    this.mainWindow.getRootWindow().write(out, true);
                }
                out.writeObject(new Integer(dynamicViews.size()));
                for (View view : dynamicViews.values()) {
                    out.writeObject(((DomainView)view.getComponent()).getCanvas().getDomain());
                    out.writeObject(((DomainView)view.getComponent()).getCanvas().getValueAssPro());
                    out.writeObject(((DomainView)view.getComponent()).getCanvas().getValueAssOpp());
                }
                out.close();
            }
            catch (IOException e2) {
                this.mainWindow.getStatusBar().reportError(e2.getMessage());
            }
        }
    }
}

