/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.adtree;

import java.io.Serializable;
import lu.uni.adtool.Options;
import lu.uni.adtool.adtree.ADTNode;

public class ADTreeNode
implements Serializable {
    static final long serialVersionUID = 19696324774341496L;
    private static int idCounter = 1;
    private boolean folded;
    private boolean aboveFolded;
    private Type type;
    private RefinementType refinementType;
    private transient ADTNode term;
    private boolean countered;
    private int id;
    private int level;
    private String label;

    public ADTreeNode() {
        this(Type.PROPONENT, Options.tree_defRefType, "Root");
    }

    public ADTreeNode(Type type, RefinementType refinementType) {
        this(type, refinementType, "N_" + idCounter);
    }

    public ADTreeNode(Type type, RefinementType refinementType, String label) {
        if (label != null) {
            this.setLabel(label);
        } else {
            this.setLabel("");
        }
        this.level = 0;
        this.type = type;
        this.refinementType = refinementType;
        this.countered = false;
        this.id = idCounter++;
        this.term = null;
        this.folded = false;
        this.aboveFolded = false;
    }

    public static void resetCounter(int number) {
        idCounter = number;
    }

    public boolean equals(ADTreeNode node) {
        if (node != null) {
            return this.id == node.getId();
        }
        return false;
    }

    public void setLabel(String label) {
        this.label = label.trim().replaceAll("(?m)^ +| +$|^[ \t]*\r?\n|( )+", "$1");
    }

    public void setRefinementType(RefinementType refinementType) {
        this.refinementType = refinementType;
    }

    public final boolean isFolded() {
        return this.folded;
    }

    public void setFolded(boolean folded) {
        this.folded = folded;
    }

    public boolean isAboveFolded() {
        return this.aboveFolded;
    }

    public void setAboveFolded(boolean aboveFolded) {
        this.aboveFolded = aboveFolded;
    }

    public final Type getType() {
        return this.type;
    }

    public void changeOp() {
        if (this.getRefinmentType() == RefinementType.DISJUNCTIVE) {
            this.setRefinementType(RefinementType.CONJUNCTIVE);
        } else {
            this.setRefinementType(RefinementType.DISJUNCTIVE);
        }
    }

    public void changeType() {
        if (this.getType() == Type.OPPONENT) {
            this.setType(Type.PROPONENT);
        } else {
            this.setType(Type.OPPONENT);
        }
    }

    public void setType(Type type) {
        this.type = type;
    }

    public RefinementType getRefinmentType() {
        return this.refinementType;
    }

    public void setTerm(ADTNode term) {
        this.term = term;
    }

    public ADTNode getTerm() {
        return this.term;
    }

    public boolean isCountered() {
        return this.countered;
    }

    public void setCountered(boolean countered) {
        this.countered = countered;
    }

    public int getId() {
        return this.id;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RefinementType {
        DISJUNCTIVE,
        CONJUNCTIVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        OPPONENT,
        PROPONENT;

    }
}

