/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.adtree;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import lu.uni.adtool.adtree.ADTLocalTNExtendProvider;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.ui.ADTreeCanvas;
import lu.uni.adtool.ui.DomainCanvas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADTreeNodeExtentProvider
extends ADTLocalTNExtendProvider {
    private Set<DomainCanvas<?>> canvasSet = new HashSet();
    private HashMap<ADTreeNode, Point2D.Double> sizes = new HashMap();

    public ADTreeNodeExtentProvider() {
        super(null);
    }

    public void registerCanvas(DomainCanvas<?> canvas) {
        this.canvasSet.add(canvas);
    }

    public void deregisterCanvas(DomainCanvas<?> canvas) {
        this.canvasSet.remove(canvas);
    }

    @Override
    public final double getWidth(ADTreeNode node) {
        return this.sizes.get((Object)node).x;
    }

    @Override
    public final double getHeight(ADTreeNode node) {
        return this.sizes.get((Object)node).y;
    }

    public final void clearSizes() {
        this.sizes.clear();
    }

    public final void updateSize(ADTreeNode node) {
        if (this.getOwner() != null) {
            String[] labels = this.getOwner().getLabelLines(node);
            Point2D.Double size = this.getSizeOfLabels(labels);
            for (ADTreeCanvas aDTreeCanvas : this.canvasSet) {
                labels = aDTreeCanvas.getLabelLines(node);
                Point2D.Double newSize = this.getSizeOfLabels(labels);
                size.x = Math.max(size.x, newSize.x);
                size.y = Math.max(size.y, newSize.y);
            }
            size.x = this.correctForOval(size.x, node);
            size.y = this.correctForOval(size.y, node);
            if (size.x < size.y) {
                size.x = size.y;
            }
            this.sizes.put(node, size);
        }
    }

    public HashMap<ADTreeNode, Point2D.Double> getSizes() {
        return this.sizes;
    }
}

