/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.domains;

import lu.uni.adtool.adtree.ADTNode;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.adtree.Node;
import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.domains.Evaluator;
import lu.uni.adtool.domains.ValueAssignement;
import lu.uni.adtool.domains.rings.Ring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuationDomain<Type> {
    static final long serialVersionUID = 665464411570251703L;
    private Domain<Type> domain;
    private transient Evaluator<Type> evaluator;
    private ValueAssignement<Type> valueAssPro;
    private ValueAssignement<Type> valueAssOpp;
    private boolean showAllLabels;

    public ValuationDomain(Domain<Type> newDomain) {
        this.domain = newDomain;
        this.evaluator = new Evaluator<Type>(this.domain);
        this.valueAssPro = new ValueAssignement();
        this.valueAssOpp = new ValueAssignement();
        this.showAllLabels = true;
    }

    public Type getValue(ADTreeNode node) {
        Type result = null;
        String key = node.getTerm().getName();
        result = node.getType() == ADTreeNode.Type.PROPONENT ? (Type)this.valueAssPro.get(key) : (Type)this.valueAssOpp.get(key);
        return result;
    }

    public final Type getTermValue(ADTNode node) {
        return this.evaluator.getValue(node);
    }

    public void setValue(boolean proponent, String key, Type value) {
        if (proponent) {
            this.valueAssPro.put(key, value);
        } else {
            this.valueAssOpp.put(key, value);
        }
    }

    public boolean hasEvaluator() {
        return this.evaluator != null;
    }

    public void refreshAllValues(ADTreeNode root) {
        ValueAssignement proNew = new ValueAssignement();
        ValueAssignement oppNew = new ValueAssignement();
        this.refreshAllValues(root.getTerm(), proNew, oppNew);
        this.valueAssPro = proNew;
        this.valueAssOpp = oppNew;
    }

    private void refreshAllValues(ADTNode node, ValueAssignement proNew, ValueAssignement oppNew) {
        String name = node.getName();
        if (node.getType() == ADTNode.Type.LEAFP) {
            Ring value = (Ring)this.valueAssPro.get(name);
            if (value == null) {
                proNew.put(name, this.getDomain().getDefaultValue(true));
            } else {
                proNew.put(name, value);
            }
        } else if (node.getType() == ADTNode.Type.LEAFO) {
            Ring value = (Ring)this.valueAssOpp.get(name);
            if (value == null) {
                oppNew.put(name, this.getDomain().getDefaultValue(false));
            } else {
                oppNew.put(name, value);
            }
        } else if (node.getChildren() != null) {
            for (Node c : node.getChildren()) {
                if (c == null) continue;
                this.refreshAllValues((ADTNode)c, proNew, oppNew);
            }
        }
    }

    public void valuesUpdated(ADTreeNode root) {
        this.evaluator.reevaluate(root.getTerm(), this.valueAssPro, this.valueAssOpp);
    }

    public void treeChanged(ADTreeNode root) {
        this.valueAssPro.setDefault(true, root.getTerm(), this.domain);
        this.valueAssOpp.setDefault(false, root.getTerm(), this.domain);
        this.evaluator.reevaluate(root.getTerm(), this.valueAssPro, this.valueAssOpp);
        this.refreshAllValues(root);
    }

    public Domain<Type> getDomain() {
        return this.domain;
    }

    public void setValueAssPro(ValueAssignement<Type> newValueAss, ADTreeNode root) {
        this.valueAssPro = newValueAss;
        this.evaluator.reevaluate(root.getTerm(), this.valueAssPro, this.valueAssOpp);
    }

    public void setValueAssOpp(ValueAssignement<Type> newValueAss, ADTreeNode root) {
        this.valueAssOpp = newValueAss;
        this.evaluator.reevaluate(root.getTerm(), this.valueAssPro, this.valueAssOpp);
    }

    public ValueAssignement<Type> getValueAssPro() {
        return this.valueAssPro;
    }

    public ValueAssignement<Type> getValueAssOpp() {
        return this.valueAssOpp;
    }

    public boolean isShowAllLabels() {
        return this.showAllLabels;
    }

    public void setShowAllLabels(boolean showAllLabels) {
        this.showAllLabels = showAllLabels;
    }
}

