/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.domains.predefined;

import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.domains.predefined.DescriptionGenerator;
import lu.uni.adtool.domains.rings.LMHEValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffLMHE
implements Domain<LMHEValue> {
    static final long serialVersionUID = 14682694465266848L;

    @Override
    public final LMHEValue getDefaultValue(boolean proponent) {
        if (proponent) {
            return new LMHEValue(4);
        }
        return new LMHEValue(LMHEValue.INF);
    }

    @Override
    public final boolean isValueModifiable(boolean proponent) {
        return proponent;
    }

    @Override
    public String getName() {
        return "Difficulty for the proponent (L,M,H,E)";
    }

    @Override
    public final String getDescription() {
        String name = "Minimal difficulty level for the proponent, on the scale Low-Medium-High-Extreme, assuming that all opponent\u2019s actions are in place and that the set of difficulty levels {L, M, H, E} is linearly ordered L&lt;M&lt;H&lt;E";
        String vd = "<nobr>{L,M,H,E,\u221e}</nobr>";
        String[] operators = new String[]{"min(<i>x</i>,<i>y</i>)", "max(<i>x</i>,<i>y</i>)", "max(<i>x</i>,<i>y</i>)", "min(<i>x</i>,<i>y</i>)", "max(<i>x</i>,<i>y</i>)", "min(<i>x</i>,<i>y</i>)"};
        return DescriptionGenerator.generateDescription(this, "Minimal difficulty level for the proponent, on the scale Low-Medium-High-Extreme, assuming that all opponent\u2019s actions are in place and that the set of difficulty levels {L, M, H, E} is linearly ordered L&lt;M&lt;H&lt;E", "<nobr>{L,M,H,E,\u221e}</nobr>", operators);
    }

    @Override
    public final LMHEValue op(LMHEValue a, LMHEValue b) {
        return LMHEValue.min(a, b);
    }

    @Override
    public final LMHEValue ap(LMHEValue a, LMHEValue b) {
        return LMHEValue.max(a, b);
    }

    @Override
    public final LMHEValue oo(LMHEValue a, LMHEValue b) {
        return LMHEValue.max(a, b);
    }

    @Override
    public final LMHEValue ao(LMHEValue a, LMHEValue b) {
        return LMHEValue.min(a, b);
    }

    @Override
    public final LMHEValue cp(LMHEValue a, LMHEValue b) {
        return LMHEValue.max(a, b);
    }

    @Override
    public final LMHEValue co(LMHEValue a, LMHEValue b) {
        return LMHEValue.min(a, b);
    }
}

