/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.domains.predefined;

import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.domains.predefined.DescriptionGenerator;
import lu.uni.adtool.domains.predefined.Parametrized;
import lu.uni.adtool.domains.rings.BoundedInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntMinSum
implements Domain<BoundedInteger>,
Parametrized {
    static final long serialVersionUID = 154666564465361444L;
    private int bound = Integer.MAX_VALUE;

    @Override
    public final BoundedInteger getDefaultValue(boolean proponent) {
        if (proponent) {
            return new BoundedInteger(this.bound, this.bound);
        }
        return new BoundedInteger(this.bound, this.bound);
    }

    @Override
    public final boolean isValueModifiable(boolean proponent) {
        return proponent;
    }

    @Override
    public String getName() {
        return "Reachability of the proponent's goal in less than k units (sequential)";
    }

    @Override
    public final String getDescription() {
        String name = "Reachability of the proponent's goal in less than <i>k</i> units, assuming that all opponent's actions are in place and that actions cannot be executed in parallel";
        String vd = "{0,\u2026,k}";
        String[] operators = new String[]{"min(<i>x</i>,<i>y</i>)", "<i>x</i>+<i>y</i>", "<i>x</i>+<i>y</i>", "min(<i>x</i>,<i>y</i>)", "<i>x</i>+<i>y</i>", "min(<i>x</i>,<i>y</i>)"};
        return DescriptionGenerator.generateDescription(this, "Reachability of the proponent's goal in less than <i>k</i> units, assuming that all opponent's actions are in place and that actions cannot be executed in parallel", "{0,\u2026,k}", operators);
    }

    @Override
    public final BoundedInteger op(BoundedInteger a, BoundedInteger b) {
        return BoundedInteger.min(a, b);
    }

    @Override
    public final BoundedInteger ap(BoundedInteger a, BoundedInteger b) {
        return BoundedInteger.sum(a, b);
    }

    @Override
    public final BoundedInteger oo(BoundedInteger a, BoundedInteger b) {
        return BoundedInteger.sum(a, b);
    }

    @Override
    public final BoundedInteger ao(BoundedInteger a, BoundedInteger b) {
        return BoundedInteger.min(a, b);
    }

    @Override
    public final BoundedInteger cp(BoundedInteger a, BoundedInteger b) {
        return BoundedInteger.sum(a, b);
    }

    @Override
    public final BoundedInteger co(BoundedInteger a, BoundedInteger b) {
        return BoundedInteger.min(a, b);
    }

    public int getBound() {
        return this.bound;
    }

    @Override
    public void setParameter(Object parameter) {
        this.bound = (Integer)parameter;
    }

    @Override
    public Integer getParameter() {
        return new Integer(this.getBound());
    }
}

