/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.domains.predefined;

import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.domains.predefined.DescriptionGenerator;
import lu.uni.adtool.domains.rings.LMHValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkillDomain
implements Domain<LMHValue> {
    static final long serialVersionUID = 14645614725266844L;

    @Override
    public final LMHValue getDefaultValue(boolean proponent) {
        if (proponent) {
            return new LMHValue(3);
        }
        return new LMHValue(LMHValue.INF);
    }

    @Override
    public final boolean isValueModifiable(boolean proponent) {
        return proponent;
    }

    @Override
    public String getName() {
        return "Difficulty for the proponent (L,M,H)";
    }

    @Override
    public final String getDescription() {
        String name = "Minimal difficulty level for the proponent, on the scale Low-Medium-High, assuming that all opponent\u2019s actions are in place and that the set of difficulty levels {L, M, H} is linearly ordered L&lt;M&lt;H ";
        String vd = "<nobr>{L,M,H,\u221e}</nobr>";
        String[] operators = new String[]{"min(<i>x</i>,<i>y</i>)", "max(<i>x</i>,<i>y</i>)", "max(<i>x</i>,<i>y</i>)", "min(<i>x</i>,<i>y</i>)", "max(<i>x</i>,<i>y</i>)", "min(<i>x</i>,<i>y</i>)"};
        return DescriptionGenerator.generateDescription(this, "Minimal difficulty level for the proponent, on the scale Low-Medium-High, assuming that all opponent\u2019s actions are in place and that the set of difficulty levels {L, M, H} is linearly ordered L&lt;M&lt;H ", "<nobr>{L,M,H,\u221e}</nobr>", operators);
    }

    @Override
    public final LMHValue op(LMHValue a, LMHValue b) {
        return LMHValue.min(a, b);
    }

    @Override
    public final LMHValue ap(LMHValue a, LMHValue b) {
        return LMHValue.max(a, b);
    }

    @Override
    public final LMHValue oo(LMHValue a, LMHValue b) {
        return LMHValue.max(a, b);
    }

    @Override
    public final LMHValue ao(LMHValue a, LMHValue b) {
        return LMHValue.min(a, b);
    }

    @Override
    public final LMHValue cp(LMHValue a, LMHValue b) {
        return LMHValue.max(a, b);
    }

    @Override
    public final LMHValue co(LMHValue a, LMHValue b) {
        return LMHValue.min(a, b);
    }
}

