/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.domains.rings;

import java.io.Serializable;
import lu.uni.adtool.domains.rings.Ring;

public class LMHEValue
implements Serializable,
Ring {
    static final long serialVersionUID = 9446634255734462L;
    public static int INF = 5;
    private int value;

    public LMHEValue(int k) {
        this.value = k;
        if (this.value < 1) {
            this.value = 1;
        }
        if (this.value > 5) {
            this.value = 5;
        }
    }

    public Object clone() {
        return new LMHEValue(this.value);
    }

    public LMHEValue(String s) {
        this.value = this.translate(s);
    }

    public final boolean updateFromString(String s) {
        this.value = this.translate(s);
        return this.value != -1;
    }

    public final int getValue() {
        return this.value;
    }

    public static LMHEValue sum(LMHEValue a, LMHEValue b) {
        if (a.getValue() == INF || b.getValue() == INF) {
            return new LMHEValue(INF);
        }
        return new LMHEValue(Math.min(a.getValue() + b.getValue(), 4));
    }

    public static LMHEValue max(LMHEValue a, LMHEValue b) {
        return new LMHEValue(Math.max(a.getValue(), b.getValue()));
    }

    public static LMHEValue min(LMHEValue a, LMHEValue b) {
        return new LMHEValue(Math.min(a.getValue(), b.getValue()));
    }

    public final String toString() {
        if (this.getValue() == INF) {
            return "Infinity";
        }
        if (this.getValue() == 1) {
            return "L";
        }
        if (this.getValue() == 2) {
            return "M";
        }
        if (this.getValue() == 3) {
            return "H";
        }
        if (this.getValue() == 4) {
            return "E";
        }
        return "Unknown";
    }

    public final String toUnicode() {
        if (this.getValue() == INF) {
            return "\u221e";
        }
        if (this.getValue() == 1) {
            return "L";
        }
        if (this.getValue() == 2) {
            return "M";
        }
        if (this.getValue() == 3) {
            return "H";
        }
        if (this.getValue() == 4) {
            return "E";
        }
        return "Unknown";
    }

    private int translate(String s) {
        if (s.equals("L")) {
            return 1;
        }
        if (s.equals("M")) {
            return 2;
        }
        if (s.equals("H")) {
            return 3;
        }
        if (s.equals("E")) {
            return 4;
        }
        if (s.equals("\u221e") || s.equals("Infinity")) {
            return INF;
        }
        return -1;
    }

    public int compareTo(Object o) {
        if (o instanceof LMHEValue) {
            int val2 = ((LMHEValue)o).getValue();
            if (this.value == val2) {
                return 0;
            }
            if (this.value < val2) {
                return -1;
            }
            if (this.value > val2) {
                return 1;
            }
        }
        throw new ClassCastException("Unable to compare LMHEValue class with " + o);
    }
}

