/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.domains.rings;

import java.io.Serializable;
import lu.uni.adtool.domains.rings.Ring;

public class LMHValue
implements Serializable,
Ring {
    static final long serialVersionUID = 94246634254424462L;
    public static int INF = 4;
    private int value;

    public LMHValue(int k) {
        this.value = k;
        if (this.value < 1) {
            this.value = 1;
        }
        if (this.value > 4) {
            this.value = 4;
        }
    }

    public Object clone() {
        return new LMHValue(this.value);
    }

    public LMHValue(String s) {
        this.value = this.translate(s);
    }

    public final boolean updateFromString(String s) {
        this.value = this.translate(s);
        return this.value != -1;
    }

    public final int getValue() {
        return this.value;
    }

    public static LMHValue sum(LMHValue a, LMHValue b) {
        if (a.getValue() == INF || b.getValue() == INF) {
            return new LMHValue(INF);
        }
        return new LMHValue(Math.min(a.getValue() + b.getValue(), 3));
    }

    public static LMHValue max(LMHValue a, LMHValue b) {
        return new LMHValue(Math.max(a.getValue(), b.getValue()));
    }

    public static LMHValue min(LMHValue a, LMHValue b) {
        return new LMHValue(Math.min(a.getValue(), b.getValue()));
    }

    public final String toString() {
        if (this.getValue() == INF) {
            return "Infinity";
        }
        if (this.getValue() == 1) {
            return "L";
        }
        if (this.getValue() == 2) {
            return "M";
        }
        if (this.getValue() == 3) {
            return "H";
        }
        return "Unknown";
    }

    public final String toUnicode() {
        if (this.getValue() == INF) {
            return "\u221e";
        }
        if (this.getValue() == 1) {
            return "L";
        }
        if (this.getValue() == 2) {
            return "M";
        }
        if (this.getValue() == 3) {
            return "H";
        }
        return "Unknown";
    }

    private int translate(String s) {
        if (s.equals("L")) {
            return 1;
        }
        if (s.equals("M")) {
            return 2;
        }
        if (s.equals("H")) {
            return 3;
        }
        if (s.equals("\u221e") || s.equals("Infinity")) {
            return INF;
        }
        return -1;
    }

    public int compareTo(Object o) {
        if (o instanceof LMHValue) {
            int val2 = ((LMHValue)o).getValue();
            if (this.value == val2) {
                return 0;
            }
            if (this.value < val2) {
                return -1;
            }
            if (this.value > val2) {
                return 1;
            }
        }
        throw new ClassCastException("Unable to compare LMHValue class with " + o);
    }
}

