/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.domains.rings;

import java.io.Serializable;
import lu.uni.adtool.domains.rings.RealZeroOne;
import lu.uni.adtool.domains.rings.Ring;

public class RealG0
implements Serializable,
Ring {
    static final long serialVersionUID = 122132278985141212L;
    private double value;

    public RealG0() {
        this(0.0);
    }

    public RealG0(double d) {
        this.value = d;
        this.checkValue();
    }

    public Object clone() {
        return new RealG0(this.value);
    }

    public final boolean updateFromString(String s) {
        this.value = Double.parseDouble(s);
        return this.checkValue();
    }

    public final String toString() {
        return new Double(this.getValue()).toString();
    }

    public final String toUnicode() {
        if (this.getValue() == Double.POSITIVE_INFINITY) {
            return "\u221e";
        }
        return new Double(this.getValue()).toString();
    }

    public static final RealG0 min(RealG0 a, RealG0 b) {
        return new RealG0(Math.min(a.getValue(), b.getValue()));
    }

    public static final RealG0 max(RealG0 a, RealG0 b) {
        return new RealG0(Math.max(a.getValue(), b.getValue()));
    }

    public static final RealG0 sum(RealG0 a, RealG0 b) {
        return new RealG0(a.getValue() + b.getValue());
    }

    public double getValue() {
        return this.value;
    }

    private boolean checkValue() {
        if (this.value < 0.0) {
            this.value = 0.0;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        double val2;
        if (o instanceof RealG0) {
            val2 = ((RealG0)o).getValue();
            if (this.value == val2) {
                return 0;
            }
            if (this.value < val2) {
                return -1;
            }
            if (this.value > val2) {
                return 1;
            }
        }
        if (o instanceof RealZeroOne) {
            val2 = ((RealZeroOne)o).getValue();
            if (this.value == val2) {
                return 0;
            }
            if (this.value < val2) {
                return -1;
            }
            if (this.value > val2) {
                return 1;
            }
        }
        throw new ClassCastException("Unable to compare RealG0 class with " + o);
    }
}

