/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringReader;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import lu.uni.adtool.adtconverter.EulerTree;
import lu.uni.adtool.adtree.ADTNode;
import lu.uni.adtool.adtree.ADTParser;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.adtree.ParseException;
import lu.uni.adtool.adtree.TokenMgrError;
import lu.uni.adtool.ui.ADTreeCanvas;
import lu.uni.adtool.ui.TreeChangeListener;

public class ADTermView
extends JPanel
implements TreeChangeListener {
    static final long serialVersionUID = 17266535905153654L;
    public static ADTParser parser = null;
    private ADTNode terms;
    private ADTreeCanvas canvas;
    private JTextArea errorOutput;
    private JSplitPane splitPane;
    private JTextArea editTerms;
    private JButton validate;
    private JButton revert;

    public ADTermView(ADTreeCanvas canvas) {
        super(new BorderLayout());
        this.terms = canvas.getTerms();
        this.initLayout(this.terms.toString());
        this.canvas = canvas;
        canvas.getTree().addTreeChangeListener(this);
    }

    public void treeChanged() {
        this.setTerms(this.canvas.getTerms());
    }

    public void sizeChanged() {
    }

    public boolean validLabel(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() == 0) {
            return false;
        }
        ADTParser.ReInit(new StringReader(s.trim()));
        try {
            ADTParser.parse();
        }
        catch (ParseException e) {
            return false;
        }
        catch (TokenMgrError e) {
            return false;
        }
        return true;
    }

    public void setTerms(ADTNode terms) {
        this.terms = terms;
        this.editTerms.setText(terms.toString());
    }

    private void initLayout(String termString) {
        this.editTerms = new JTextArea(termString);
        this.editTerms.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ADTermView.this.editTerms.getHighlighter().removeAllHighlights();
            }

            public void removeUpdate(DocumentEvent e) {
                ADTermView.this.editTerms.getHighlighter().removeAllHighlights();
            }

            public void insertUpdate(DocumentEvent e) {
                ADTermView.this.editTerms.getHighlighter().removeAllHighlights();
            }
        });
        if (parser == null) {
            parser = new ADTParser(new StringReader(this.editTerms.getText()));
        } else {
            ADTParser.ReInit(new StringReader(this.editTerms.getText()));
        }
        this.errorOutput = new JTextArea();
        this.errorOutput.setEditable(false);
        JScrollPane errorScroll = new JScrollPane(this.errorOutput);
        this.splitPane = new JSplitPane(0, errorScroll, new JScrollPane(this.editTerms));
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setResizeWeight(0.0);
        this.splitPane.setDividerLocation(0.0);
        this.add(this.splitPane);
        this.add((Component)this.createButtonPane(), "Last");
    }

    private JPanel createButtonPane() {
        JPanel buttonPane = new JPanel();
        this.validate = new JButton("Validate");
        this.revert = new JButton("Revert");
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.add(this.validate);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(this.revert);
        this.revert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ADTermView.this.revert();
            }
        });
        this.validate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ADTermView.this.parse();
            }
        });
        this.revert.setEnabled(false);
        return buttonPane;
    }

    private void revert() {
        if (this.terms != null) {
            this.editTerms.setText(this.terms.toString());
            this.revert.setEnabled(false);
            this.splitPane.setDividerLocation(0.0);
            this.errorOutput.setText("");
        }
    }

    public void setFocus(ADTreeNode n) {
    }

    public void parse() {
        if (this.editTerms.getText().length() > 0) {
            ADTNode oldTerms = this.terms;
            ADTParser.ReInit(new StringReader(this.editTerms.getText()));
            try {
                this.terms = ADTParser.parse();
                this.editTerms.setText(this.terms.toString());
                this.revert.setEnabled(false);
                this.splitPane.setDividerLocation(0.0);
                this.errorOutput.setText("");
                EulerTree et = new EulerTree();
                et.transferLabels(this.terms, oldTerms);
                this.canvas.treeFromTerms(this.terms);
                this.canvas.getMainWindow().getStatusBar().report("Validation of terms was successful");
            }
            catch (ParseException e) {
                this.handleError(e.getMessage(), e.currentToken.endLine, e.currentToken.endColumn, e.currentToken.next.endLine, e.currentToken.next.endColumn);
            }
            catch (TokenMgrError e) {
                String m = e.getMessage();
                int line = Integer.parseInt(m.subSequence(22, m.indexOf(44, 22)).toString());
                int column = Integer.parseInt(m.subSequence(m.indexOf("n ", 23) + 2, m.indexOf(46, 23)).toString());
                this.handleError(m, line, column, line, column);
            }
        }
    }

    private void handleError(String m, int startLine, int startColumn, int endLine, int endColumn) {
        this.errorOutput.setText(m);
        this.canvas.getMainWindow().getStatusBar().reportError("Validation of terms was not possible: " + m);
        this.splitPane.setDividerLocation(Math.max(0.0, (this.errorOutput.getPreferredSize().getHeight() + 5.0) / (double)this.splitPane.getSize().height));
        try {
            int offset = this.editTerms.getLineStartOffset(startLine - 1) + startColumn - 1;
            int endOffset = this.editTerms.getLineStartOffset(endLine - 1) + endColumn - 1;
            this.editTerms.scrollRectToVisible(this.editTerms.modelToView(offset));
            this.editTerms.setCaretPosition(endOffset);
            this.highlight(offset, endOffset);
            this.editTerms.requestFocus();
        }
        catch (BadLocationException err) {
            this.canvas.getMainWindow().getStatusBar().reportError(err.getLocalizedMessage());
        }
        this.revert.setEnabled(true);
    }

    private void highlight(int startPos, int endPos) {
        if (startPos == endPos && startPos > 0) {
            --startPos;
        }
        DefaultHighlighter.DefaultHighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
        try {
            this.editTerms.getHighlighter().addHighlight(startPos, endPos, highlightPainter);
        }
        catch (BadLocationException err) {
            this.canvas.getMainWindow().getStatusBar().reportError(err.getLocalizedMessage());
        }
    }

    public ADTNode getTerms() {
        return this.terms;
    }
}

