/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PageRanges;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import lu.uni.adtool.Options;
import lu.uni.adtool.adtree.ADTLatexExport;
import lu.uni.adtool.adtree.ADTLocalTNExtendProvider;
import lu.uni.adtool.adtree.ADTNode;
import lu.uni.adtool.adtree.ADTParser;
import lu.uni.adtool.adtree.ADTXmlExport;
import lu.uni.adtool.adtree.ADTreeForGui;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.adtree.ParseException;
import lu.uni.adtool.adtree.TokenMgrError;
import lu.uni.adtool.ui.ADTreeCanvasHandler;
import lu.uni.adtool.ui.CanvasHandler;
import lu.uni.adtool.ui.DomainCanvas;
import lu.uni.adtool.ui.MainWindow;
import lu.uni.adtool.ui.TreeChangeListener;
import net.infonode.docking.View;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeForTreeLayout;
import org.abego.treelayout.TreeLayout;
import org.abego.treelayout.util.DefaultConfiguration;

public class ADTreeCanvas
extends JPanel
implements Scrollable,
TreeChangeListener,
Printable,
Pageable {
    static final long serialVersionUID = 702665011192502883L;
    protected ADTreeForGui tree;
    protected boolean localExtentProvider;
    protected CanvasHandler listener;
    private final BasicStroke basicStroke = new BasicStroke(Options.canv_LineWidth, 1, 1);
    private final BasicStroke selectionStroke = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{6.0f, 10.0f}, 0.0f);
    private final BasicStroke counterStroke = new BasicStroke(Options.canv_LineWidth, 1, 1, 0.0f, new float[]{0.0f, 6.0f}, 0.0f);
    private final int borderPad = 20;
    private double moveX = 0.0;
    private double moveY = 0.0;
    private final int focusPad = 10;
    private double scale = 1.0;
    private AffineTransform viewTransform = new AffineTransform();
    private double sizeX = 0.0;
    private double sizeY = 0.0;
    private JScrollPane scrollPane;
    protected Map<ADTreeNode, Rectangle2D.Double> bufferedLayout;
    private DefaultConfiguration<ADTreeNode> configuration;
    protected ADTreeNode focused;
    protected ADTreeNode lastFocused;
    protected PageFormat pageFormat;
    protected PrintRequestAttributeSet printAttr;
    private Dimension viewPortSize;
    protected MainWindow mainWindow;
    private int id;

    public ADTreeCanvas(ADTreeForGui newTree, MainWindow mw, int newId) {
        super(new BorderLayout());
        this.id = newId;
        this.mainWindow = mw;
        this.setBackground(Options.canv_BackgroundColor);
        this.scrollPane = null;
        this.printAttr = new HashPrintRequestAttributeSet();
        this.printAttr.add(MediaSizeName.ISO_A4);
        this.localExtentProvider = false;
        this.pageFormat = new PageFormat();
        this.addListener();
        this.tree = newTree;
        this.tree.setOwner(this);
        this.tree.addTreeChangeListener(this);
        this.configuration = new DefaultConfiguration((double)Options.canv_gapBetweenLevels, (double)Options.canv_gapBetweenNodes);
        this.setFocus(null);
        this.lastFocused = this.tree.getRoot(false);
        this.setFocusTraversalKeysEnabled(true);
        this.setScale(1.0);
        this.sizeX = 0.0;
        this.sizeY = 0.0;
        this.bufferedLayout = null;
        ADTLocalTNExtendProvider extentProvider = this.localExtentProvider ? new ADTLocalTNExtendProvider(this) : this.tree.getExtendProvider();
        TreeLayout treeLayout = new TreeLayout((TreeForTreeLayout)this.tree, (NodeExtentProvider)extentProvider, this.configuration);
        this.bufferedLayout = treeLayout.getNodeBounds();
        for (Rectangle2D.Double rect : this.bufferedLayout.values()) {
            this.sizeX = Math.max(this.sizeX, rect.getMaxX());
            this.sizeY = Math.max(this.sizeY, rect.getMaxY());
        }
        this.setScale(this.scale);
    }

    protected void addListener() {
        this.listener = new ADTreeCanvasHandler(this);
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
        this.addKeyListener(this.listener);
    }

    public void sizeChanged() {
        this.recalculateLayout();
    }

    public void treeChanged() {
        this.recalculateLayout();
    }

    public void newTree() {
        this.tree.newTree();
    }

    public void moveTree(double x, double y) {
        java.awt.Rectangle r = this.scrollPane.getViewport().getViewRect();
        this.setMoveX(this.moveX + x);
        this.setMoveY(this.moveY + y);
        this.updateSize();
        this.scrollPane.scrollRectToVisible(r);
        this.repaint();
    }

    private void updateSize() {
        Point2D.Double point = new Point2D.Double(this.sizeX + 10.0, this.sizeY + 10.0);
        this.viewTransform.transform(point, point);
        int x = 0;
        int y = 0;
        if (this.viewPortSize != null) {
            x = this.viewPortSize.width + x;
            y = this.viewPortSize.height + y;
        }
        Dimension dim = new Dimension(Math.max((int)point.getX(), x), Math.max((int)point.getY(), y));
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
        this.revalidate();
    }

    protected void recalculateLayout() {
        this.sizeX = 0.0;
        this.sizeY = 0.0;
        this.bufferedLayout = null;
        ADTLocalTNExtendProvider extentProvider = this.localExtentProvider ? new ADTLocalTNExtendProvider(this) : this.tree.getExtendProvider();
        TreeLayout treeLayout = new TreeLayout((TreeForTreeLayout)this.tree, (NodeExtentProvider)extentProvider, this.configuration);
        this.bufferedLayout = treeLayout.getNodeBounds();
        for (Rectangle2D.Double rect : this.bufferedLayout.values()) {
            this.sizeX = Math.max(this.sizeX, rect.getMaxX());
            this.sizeY = Math.max(this.sizeY, rect.getMaxY());
        }
        this.setScale(this.scale);
        this.repaint();
    }

    public int getScrollableUnitIncrement(java.awt.Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public int getScrollableBlockIncrement(java.awt.Rectangle visibleRect, int orientation, int direction) {
        int maxUnitIncrement = 1;
        if (orientation == 0) {
            return visibleRect.width - maxUnitIncrement;
        }
        return visibleRect.height - maxUnitIncrement;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics2D g2, ADTreeNode startNode) {
        g2.setStroke(this.basicStroke);
        if (Options.canv_DoAntialiasing) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.paintEdges(g2, startNode);
        this.paintBox(g2, startNode);
        if (this.focused != null) {
            this.paintFocus(g2, this.focused);
        }
    }

    public Point2D transform(Point2D point) {
        try {
            return this.viewTransform.inverseTransform(point, null);
        }
        catch (NoninvertibleTransformException e) {
            return point;
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Options.canv_BackgroundColor);
        java.awt.Rectangle r = g2.getClipBounds();
        if (r != null) {
            g2.fillRect(r.x, r.y, r.width, r.height);
        }
        g2.transform(this.viewTransform);
        this.paintComponent(g2, this.tree.getRoot(false));
    }

    public PageFormat getPageFormat(int pageIndex) {
        return this.pageFormat;
    }

    public Printable getPrintable(int pageIndex) {
        if (pageIndex >= Options.print_noPages) {
            throw new IndexOutOfBoundsException("No page with number " + pageIndex);
        }
        return this;
    }

    public int getNumberOfPages() {
        return Options.print_noPages;
    }

    public Point getColsRows(int noMaxPages) {
        PageFormat pf = this.getPageFormat(0);
        return this.getColsRows(pf.getImageableWidth(), pf.getImageableHeight(), noMaxPages);
    }

    public boolean showPrintDialog(boolean doPrint) {
        try {
            PrinterJob pjob = PrinterJob.getPrinterJob();
            pjob.setPageable(this);
            this.printAttr.add(new PageRanges(1, this.getNumberOfPages()));
            if (doPrint) {
                if (pjob.printDialog(this.printAttr)) {
                    this.pageFormat = pjob.getPageFormat(this.printAttr);
                    pjob.print();
                    this.mainWindow.getStatusBar().report("Printed window with title: " + ((View)this.getParent().getParent().getParent().getParent().getParent()).getTitle());
                    return true;
                }
            } else {
                PageFormat page = pjob.pageDialog(this.getPageFormat(0));
                if (page != this.getPageFormat(0)) {
                    this.setPageFormat(page);
                    this.mainWindow.getStatusBar().report("Printed window with title: " + ((View)this.getParent().getParent().getParent().getParent().getParent()).getTitle());
                    return true;
                }
            }
        }
        catch (PrinterException exc) {
            this.mainWindow.getStatusBar().reportError(exc.getLocalizedMessage());
        }
        return false;
    }

    public void createXml(FileOutputStream fileStream) {
        ADTXmlExport exporter = new ADTXmlExport(this.tree, this.mainWindow.getValuations());
        exporter.exportTo(fileStream);
    }

    public void createPdf(FileOutputStream fileStream) {
        double oldScale = this.getScale();
        Dimension dim = this.getPreferredSize();
        if (dim.width > 14399 || dim.height > 14399) {
            this.setScale(14000.0 / (double)Math.max(dim.width, dim.height) * oldScale);
            dim = this.getPreferredSize();
        }
        try {
            Document document = new Document(new Rectangle((float)dim.width, (float)dim.height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)fileStream);
            document.open();
            PdfContentByte canv = writer.getDirectContent();
            PdfGraphics2D g2 = new PdfGraphics2D(canv, (float)dim.width, (float)dim.height);
            this.paintComponent((Graphics)g2);
            g2.dispose();
            document.close();
            fileStream.close();
        }
        catch (DocumentException e) {
            System.err.println("Error while exporting to pdf:" + (Object)((Object)e));
        }
        catch (IOException e) {
            System.err.println("Error while exporting to pdf:" + e);
        }
        this.setScale(oldScale);
    }

    public void createLatex(FileOutputStream fileStream) {
        ADTLatexExport exporter = new ADTLatexExport(this);
        exporter.exportTo(fileStream);
    }

    public void createImage(FileOutputStream fileStream, String formatName) {
        Dimension dim = this.getPreferredSize();
        BufferedImage bufferedImage = new BufferedImage(dim.width, dim.height, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        this.paintComponent(g2d);
        g2d.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, formatName, fileStream);
            fileStream.close();
        }
        catch (IOException e) {
            System.err.println("Error while exporting to image:" + e);
        }
    }

    public int print(Graphics g, PageFormat pf, int page) {
        double pH;
        double pW = pf.getImageableWidth();
        Point p = this.getColsRows(pW, pH = pf.getImageableHeight(), this.getNumberOfPages());
        if (page >= (int)(p.getX() * p.getY())) {
            return 1;
        }
        ADTreeNode tFocus = this.focused;
        this.focused = null;
        double printScaleX = pW * p.getX() / (this.sizeX + (double)Options.canv_LineWidth);
        double printScaleY = pH * p.getY() / (this.sizeY + (double)Options.canv_LineWidth);
        if (Options.print_perserveAspectRatio) {
            if (printScaleX < printScaleY) {
                printScaleY = printScaleX;
            } else {
                printScaleX = printScaleY;
            }
        }
        int shiftX = page % (int)p.getX();
        int shiftY = page / (int)p.getX();
        g.translate((int)(pf.getImageableX() - (double)shiftX * pW), (int)(pf.getImageableY() - (double)shiftY * pH));
        ((Graphics2D)g).scale(printScaleX, printScaleY);
        g.translate(Options.canv_LineWidth, Options.canv_LineWidth);
        this.paintComponent((Graphics2D)g, this.tree.getRoot(false));
        this.focused = tFocus;
        return 0;
    }

    public Point scrollTo(double x, double y) {
        java.awt.Rectangle r = this.scrollPane.getViewport().getViewRect();
        Point p = r.getLocation();
        r.translate((int)x, (int)y);
        this.scrollRectToVisible(r);
        r = this.scrollPane.getViewport().getViewRect();
        p.translate((int)(-r.getX()), (int)(-r.getY()));
        return p;
    }

    public ADTreeNode getNode(double x, double y) {
        try {
            Point2D point = this.viewTransform.inverseTransform(new Point2D.Double(x, y), null);
            x = point.getX();
            y = point.getY();
        }
        catch (NoninvertibleTransformException e) {
            System.err.println("Cannot tranlate click point!!");
        }
        if (x > this.sizeX || y > this.sizeY || x < 0.0 || y < 0.0) {
            return null;
        }
        for (ADTreeNode node : this.bufferedLayout.keySet()) {
            RectangularShape shape;
            Rectangle2D rect = this.bufferedLayout.get(node);
            switch (Options.canv_ShapeDef) {
                case RECTANGLE: {
                    shape = rect;
                    break;
                }
                case OVAL: {
                    shape = new Ellipse2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
                    break;
                }
                default: {
                    shape = new RoundRectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), Options.canv_ArcSize, Options.canv_ArcSize);
                }
            }
            if (!shape.contains(x, y)) continue;
            return node;
        }
        return null;
    }

    public void setLabel(ADTreeNode node, String label) {
        this.tree.setLabel(node, label);
        this.tree.notifyTreeChanged();
        if (this.getMainWindow().getLastFocused() != null) {
            this.getMainWindow().getLastFocused().requestFocus();
        }
    }

    public void removeNode(ADTreeNode node) {
        if (!node.equals(this.tree.getRoot(true))) {
            if (this.lastFocused.equals(node)) {
                this.lastFocused = this.tree.getParent(node);
                if (this.lastFocused == null) {
                    this.lastFocused = this.tree.getRoot(true);
                }
            }
            if (this.focused != null && this.focused.equals(node)) {
                this.setFocus(this.tree.getParent(node));
            }
        }
        this.tree.removeNode(node);
        this.tree.notifyTreeChanged();
    }

    public void removeTree(ADTreeNode node) {
        if (!node.equals(this.tree.getRoot(true))) {
            if (this.lastFocused.equals(node)) {
                this.lastFocused = this.tree.getParent(node);
                if (this.lastFocused == null) {
                    this.lastFocused = this.tree.getRoot(true);
                }
            }
            if (this.focused != null && this.focused.equals(node)) {
                this.setFocus(this.tree.getParent(node));
            }
        }
        this.tree.removeTree(node);
        this.tree.notifyTreeChanged();
    }

    public void removeChildren(ADTreeNode node) {
        if (node.isFolded()) {
            this.tree.toggleFold(node);
        }
        this.tree.removeAllChildren(node);
        this.tree.notifyTreeChanged();
    }

    public boolean validLabel(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() == 0) {
            return false;
        }
        ADTParser.ReInit(new StringReader("aaaa" + s.trim()));
        try {
            ADTNode node = ADTParser.parse();
            return node.getType() == ADTNode.Type.LEAFP || node.getType() == ADTNode.Type.LEAFO;
        }
        catch (ParseException e) {
            return false;
        }
        catch (TokenMgrError e) {
            return false;
        }
    }

    public void addCounter(ADTreeNode node) {
        if (node.isCountered()) {
            return;
        }
        ADTreeNode child = new ADTreeNode(node.getType(), Options.tree_defRefType);
        child.changeType();
        this.tree.addCounter(node, child);
    }

    public void addChild(ADTreeNode node) {
        ADTreeNode child = new ADTreeNode(node.getType(), Options.tree_defRefType);
        this.tree.addChild(node, child);
    }

    public void addSibling(ADTreeNode node, boolean onLeft) {
        ADTreeNode parent = this.tree.getParent(node);
        if (parent == null) {
            return;
        }
        if (node.getType() == parent.getType()) {
            ADTreeNode sibling = new ADTreeNode(node.getType(), Options.tree_defRefType);
            this.tree.addSibling(node, sibling, onLeft);
        }
    }

    public ADTreeNode getRightSibling(ADTreeNode node) {
        return this.tree.getRightSibling(node);
    }

    public ADTreeNode getLeftSibling(ADTreeNode node) {
        return this.tree.getLeftSibling(node);
    }

    public ADTreeNode getMiddleChild(ADTreeNode node) {
        return this.tree.getMiddleChild(node);
    }

    public void changeOp(ADTreeNode node) {
        this.tree.changeOp(node);
    }

    public ADTNode getTerms() {
        return this.tree.getTerms();
    }

    public ADTreeForGui getTree() {
        return this.tree;
    }

    public void setLocalExtentProvider(boolean localExtentProvider) {
        this.localExtentProvider = localExtentProvider;
        if (localExtentProvider) {
            this.tree.deregisterSizeCanvas((DomainCanvas)this);
        } else {
            this.tree.registerSizeCanvas((DomainCanvas)this);
        }
    }

    public CanvasHandler getListener() {
        return this.listener;
    }

    public void setMoveX(double moveX) {
        if (moveX < 0.0) {
            moveX = 0.0;
        }
        this.viewTransform.translate(moveX - this.moveX, 0.0);
        this.moveX = moveX;
    }

    public double getMoveX() {
        return this.moveX;
    }

    public void setMoveY(double moveY) {
        if (moveY < 0.0) {
            moveY = 0.0;
        }
        this.viewTransform.translate(0.0, moveY - this.moveY);
        this.moveY = moveY;
    }

    public double getMoveY() {
        return this.moveY;
    }

    public void fitToWindow() {
        int x = this.viewPortSize.width;
        int y = this.viewPortSize.height;
        double sX = this.sizeX + 20.0;
        double sY = this.sizeY + 20.0;
        double newScale = this.getScale() * Math.min((double)x / (sX * this.getScale()), (double)y / (sY * this.getScale()));
        this.setScale(newScale);
        this.setMoveX(((double)x / this.getScale() - sX) / 2.0);
        this.setMoveY(((double)y / this.getScale() - sY) / 2.0);
        this.updateSize();
        this.repaint();
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.viewTransform = new AffineTransform();
        this.viewTransform.scale(scale, scale);
        this.viewTransform.translate(this.moveX, this.moveY);
        this.viewTransform.translate(10.0, 10.0);
        this.updateSize();
    }

    public void expandAllNodes() {
        ADTreeNode viewNode = this.tree.getRoot(false);
        while (viewNode.isAboveFolded()) {
            this.tree.toggleAboveFold(viewNode);
            viewNode = this.tree.getRoot(false);
        }
        this.tree.expandAllFold();
    }

    public void toggleAboveFold(ADTreeNode viewRoot) {
        if (this.getTree().getParent(viewRoot, true) != null) {
            this.tree.toggleAboveFold(viewRoot);
        }
    }

    public void zoomIn() {
        if (this.scale < 100.0) {
            this.setScale(this.scale * 1.1);
            this.repaint();
        }
    }

    public void resetZoom() {
        this.setScale(1.0);
        this.repaint();
    }

    public void zoomOut() {
        Point2D.Double point = new Point2D.Double(this.sizeX + 10.0, this.sizeY + 10.0);
        this.viewTransform.transform(point, point);
        if (Math.max(point.getX() - this.moveX * this.getScale(), point.getY() - this.moveY * this.getScale()) > 20.0) {
            this.setScale(this.scale / 1.1);
            this.repaint();
        }
    }

    public void setFocus(ADTreeNode focused) {
        if (this.focused != null) {
            this.lastFocused = this.focused;
        }
        if (focused != null) {
            this.tree.defocusAll();
        }
        this.focused = focused;
        if (focused != null) {
            Rectangle2D b2 = this.bufferedLayout.get(focused);
            if (b2 == null) {
                this.recalculateLayout();
                b2 = this.bufferedLayout.get(focused);
            }
            Point2D.Double p1 = new Point2D.Double(b2.getX() - 10.0, b2.getY() - 10.0);
            Point2D.Double p2 = new Point2D.Double((b2.getWidth() + 20.0) * this.scale, (b2.getHeight() + 20.0) * this.scale);
            this.viewTransform.transform(p1, p1);
            if (((Point2D)p1).getX() < 0.0) {
                this.setMoveX(this.getMoveX() - ((Point2D)p1).getX() / this.scale);
                ((Point2D)p1).setLocation(0.0, ((Point2D)p1).getY());
            }
            if (((Point2D)p1).getY() < 0.0) {
                this.setMoveY(this.getMoveY() - ((Point2D)p1).getY() / this.scale);
                ((Point2D)p1).setLocation(((Point2D)p1).getX(), 0.0);
            }
            this.updateSize();
            this.scrollRectToVisible(new java.awt.Rectangle((int)((Point2D)p1).getX(), (int)((Point2D)p1).getY(), (int)((Point2D)p2).getX(), (int)((Point2D)p2).getY()));
        }
        this.repaint();
    }

    public ADTreeNode getParentNode(ADTreeNode node) {
        return this.tree.getParent(node);
    }

    public ADTreeNode getRoot(boolean ignoreFold) {
        return this.tree.getRoot(ignoreFold);
    }

    public double getScale() {
        return this.scale;
    }

    public double getSizeX() {
        return this.sizeX;
    }

    public double getSizeY() {
        return this.sizeY;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        this.scrollPane.addMouseWheelListener(this.listener);
        this.scrollPane.addComponentListener(this.listener);
        this.viewPortSize = this.scrollPane.getViewport().getExtentSize();
        this.setScale(1.0);
    }

    public ADTreeNode getFocused() {
        return this.focused;
    }

    public ADTreeNode getLastFocused() {
        return this.lastFocused;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public void setViewPortSize(Dimension viewPortSize) {
        this.viewPortSize = viewPortSize;
        if (this.scrollPane.getHorizontalScrollBar().isVisible()) {
            this.viewPortSize.height += this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        }
        if (this.scrollPane.getVerticalScrollBar().isVisible()) {
            this.viewPortSize.width += this.scrollPane.getVerticalScrollBar().getPreferredSize().width;
        }
        this.updateSize();
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public String[] getLabelLines(ADTreeNode node) {
        return this.getLabel(node).split("\n");
    }

    public String getLabel(ADTreeNode node) {
        return node.getLabel();
    }

    public void treeFromTerms(ADTNode root) {
        this.tree.createFromTerms(root);
        this.tree.defocusAll();
    }

    protected void paintEdges(Graphics2D g2, ADTreeNode parent) {
        if (!this.tree.isLeaf(parent)) {
            Rectangle2D.Double b1 = this.bufferedLayout.get(parent);
            double x1 = b1.getCenterX();
            double y1 = b1.getCenterY();
            double maxX = 0.0;
            double minX = x1;
            int noChildren = 0;
            g2.setColor(Options.canv_EdgesColor);
            Rectangle2D.Double b2 = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            for (ADTreeNode child : this.tree.getChildrenList(parent, false)) {
                b2 = this.bufferedLayout.get(child);
                if (child.getType() != parent.getType()) {
                    g2.setStroke(this.counterStroke);
                } else {
                    g2.setStroke(this.basicStroke);
                }
                if (child.getType() == parent.getType()) {
                    maxX = Math.max(maxX, b2.getCenterX());
                    minX = Math.min(minX, b2.getCenterX());
                    ++noChildren;
                }
                g2.drawLine((int)x1, (int)y1, (int)b2.getCenterX(), (int)b2.getCenterY());
            }
            g2.setStroke(this.basicStroke);
            if (parent.getRefinmentType() == ADTreeNode.RefinementType.CONJUNCTIVE && noChildren > 1) {
                double shear;
                double tangens1 = (b2.getCenterY() - y1) / (minX - x1);
                double tangens2 = (b2.getCenterY() - y1) / (maxX - x1);
                int startAngle = -((int)Math.toDegrees(Math.atan(tangens2 * (shear = (b1.getWidth() + (double)Options.canv_ArcPadding) / (b1.getHeight() + (double)Options.canv_ArcPadding)))));
                if (startAngle > 0) {
                    startAngle -= 180;
                }
                int endAngle = -180 - (int)Math.toDegrees(Math.atan(tangens1 * shear));
                g2.drawArc((int)b1.getX() - Options.canv_ArcPadding / 2, (int)b1.getY() - Options.canv_ArcPadding / 2, (int)b1.getWidth() + Options.canv_ArcPadding, (int)b1.getHeight() + Options.canv_ArcPadding, startAngle - 1, endAngle - (startAngle - 2));
            }
            for (ADTreeNode child : this.tree.getChildrenList(parent, false)) {
                this.paintEdges(g2, child);
            }
        }
        g2.setStroke(this.basicStroke);
    }

    protected void paintFocus(Graphics2D g2, ADTreeNode node) {
        Rectangle2D.Double box = this.bufferedLayout.get(node);
        if (box == null) {
            return;
        }
        int x = (int)box.x - 5;
        int y = (int)box.y - 5;
        g2.setColor(Color.blue);
        g2.setStroke(this.selectionStroke);
        Options.ShapeType shape = node.getType() == Options.canv_Defender ? Options.canv_ShapeDef : Options.canv_ShapeAtt;
        switch (shape) {
            case RECTANGLE: {
                g2.drawRect(x, y, (int)box.width + 10 - 1, (int)box.height + 10 - 1);
                break;
            }
            case OVAL: {
                g2.drawOval(x, y, (int)box.width + 10 - 1, (int)box.height + 10 - 1);
                break;
            }
            default: {
                g2.drawRoundRect(x, y, (int)box.width + 10 - 1, (int)box.height + 10 - 1, Options.canv_ArcSize + 1, Options.canv_ArcSize + 1);
            }
        }
    }

    protected void paintLabels(Graphics2D g, ADTreeNode node, Color textCol) {
        Rectangle2D.Double box = this.bufferedLayout.get(node);
        int x = (int)box.x;
        int y = (int)box.y;
        String[] lines = this.getLabelLines(node);
        FontMetrics m = this.getFontMetrics(Options.canv_Font);
        y = (int)((double)y + box.height / 2.0 - (double)(lines.length * m.getHeight() / 2)) - 1;
        x += (int)(box.width / 2.0);
        y += m.getAscent() + m.getLeading() + 1;
        g.setColor(textCol);
        g.setFont(Options.canv_Font);
        for (int i = 0; i < lines.length; ++i) {
            g.drawString(lines[i], x - m.stringWidth(lines[i]) / 2, y);
            y += m.getHeight();
        }
    }

    protected Color getFillColor(ADTreeNode node) {
        if (node.getType() == ADTreeNode.Type.PROPONENT) {
            return Options.canv_FillColorDef;
        }
        return Options.canv_FillColorAtt;
    }

    protected String getFillColorS(ADTreeNode node) {
        if (node.getType() == ADTreeNode.Type.PROPONENT) {
            return "attFill";
        }
        return "defFill";
    }

    public String[] getLatex(ADTreeNode node, int level) {
        String spaces = "";
        for (int i = 0; i < level; ++i) {
            spaces = spaces + "  ";
        }
        boolean countered = false;
        ADTreeNode parent = this.tree.getParent(node);
        if (parent != null && node.getType() != parent.getType()) {
            countered = true;
        }
        String fillCol = this.getFillColorS(node);
        String shape = node.getType() == Options.canv_Defender ? (!countered ? "\\NNodeA[fillcolor=" + fillCol + "]{ID" + node.getId() + "}" : "\\NNodeAC[fillcolor=" + fillCol + "]{ID" + node.getId() + "}") : (!countered ? "\\NNodeB[fillcolor=" + fillCol + "]{ID" + node.getId() + "}" : "\\NNodeBC[fillcolor=" + fillCol + "]{ID" + node.getId() + "}");
        shape = shape + "{" + ADTLatexExport.escape(this.getLabel(node)) + "}\n";
        String[] result = new String[]{spaces + "\\pstree{\n", ""};
        result[0] = result[0] + spaces + shape + spaces + "}\n";
        if (!node.isFolded()) {
            result[0] = result[0] + spaces + "{";
            for (ADTreeNode child : this.tree.getChildrenList(node, false)) {
                String[] r = this.getLatex(child, level + 1);
                result[0] = result[0] + r[0];
                result[1] = result[1] + r[1];
            }
            if (this.tree.getChildrenList(node, false).size() > 1 && node.getRefinmentType() == ADTreeNode.RefinementType.CONJUNCTIVE) {
                ADTreeNode child1 = this.tree.getChildrenList(node, false).get(0);
                int last = this.tree.getChildrenList(node, false).size() - 1;
                if (node.isCountered()) {
                    --last;
                }
                ADTreeNode child2 = this.tree.getChildrenList(node, false).get(last);
                result[1] = result[1] + "\\Bogen{ID" + node.getId() + "}{ID" + child1.getId() + "}{ID" + child2.getId() + "}\n";
            }
            result[0] = result[0] + spaces + "}\n";
        } else {
            result[0] = result[0] + "{\\pstree[thislevelsep=-.1,linestyle=none]{\\Tfan[cornersize=absolute,cornersize=1,linewidth=" + Options.canv_LineWidth + ", linecolor=black,fansize=7]}{}}\n";
        }
        return result;
    }

    protected void paintBox(Graphics2D g, ADTreeNode node) {
        Polygon triangle;
        Options.ShapeType shape;
        Color textCol;
        Color borderCol;
        Color fillCol = this.getFillColor(node);
        if (node.getType() == Options.canv_Defender) {
            borderCol = Options.canv_BorderColorDef;
            textCol = Options.canv_TextColorDef;
            shape = Options.canv_ShapeDef;
        } else {
            borderCol = Options.canv_BorderColorAtt;
            textCol = Options.canv_TextColorAtt;
            shape = Options.canv_ShapeAtt;
        }
        Rectangle2D.Double box = this.bufferedLayout.get(node);
        int x = (int)box.x;
        int y = (int)box.y;
        g.setColor(Options.canv_EdgesColor);
        if (node.isFolded()) {
            triangle = new Polygon();
            triangle.addPoint(x + (int)(box.width / 2.0), y);
            triangle.addPoint(x, y + (int)box.height + 6);
            triangle.addPoint(x + (int)box.width, y + (int)box.height + 6);
            g.fillPolygon(triangle);
        }
        if (node.isAboveFolded()) {
            triangle = new Polygon();
            triangle.addPoint(x + (int)(box.width / 2.0), y - 10);
            triangle.addPoint(x + (int)(box.width / 2.0) - 6, y);
            triangle.addPoint(x + (int)(box.width / 2.0) + 6, y);
            g.fillPolygon(triangle);
        }
        g.setColor(fillCol);
        g.setStroke(this.basicStroke);
        switch (shape) {
            case RECTANGLE: {
                g.fillRect(x, y, (int)box.width - 1, (int)box.height - 1);
                g.setColor(borderCol);
                g.drawRect(x, y, (int)box.width - 1, (int)box.height - 1);
                break;
            }
            case OVAL: {
                g.fillOval(x, y, (int)box.width - 1, (int)box.height - 1);
                g.setColor(borderCol);
                g.drawOval(x, y, (int)box.width - 1, (int)box.height - 1);
                break;
            }
            default: {
                g.fillRoundRect(x, y, (int)box.width - 1, (int)box.height - 1, Options.canv_ArcSize, Options.canv_ArcSize);
                g.setColor(borderCol);
                g.drawRoundRect(x, y, (int)box.width - 1, (int)box.height - 1, Options.canv_ArcSize, Options.canv_ArcSize);
            }
        }
        this.paintLabels(g, node, textCol);
        for (ADTreeNode child : this.tree.getChildrenList(node, false)) {
            this.paintBox(g, child);
        }
    }

    public void toggleFold(ADTreeNode node) {
        if (this.getTree().getChildrenList(node, true).size() > 0 && !node.isFolded()) {
            this.getTree().toggleFold(node);
        } else if (this.getTree().getChildrenList(node, false).size() == 0 && node.isFolded()) {
            this.getTree().toggleFold(node);
        }
    }

    private Point getColsRows(double pageHeight, double pageWidth, int noPages) {
        double ratio = pageWidth / pageHeight / (this.sizeY / this.sizeX);
        int rows = 1;
        int cols = 1;
        while (true) {
            if (ratio * ((double)rows / (double)cols) > 1.0) {
                if (++cols * rows <= noPages) continue;
                return new Point(--cols, rows);
            }
            if (cols * ++rows > noPages) break;
        }
        return new Point(cols, --rows);
    }

    public int getId() {
        return this.id;
    }
}

