/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import lu.uni.adtool.adtree.ADTreeNode;
import lu.uni.adtool.ui.ADTreeCanvas;
import lu.uni.adtool.ui.AbstractCanvasHandler;
import lu.uni.adtool.ui.MultilineInput;

public class ADTreeCanvasHandler
extends AbstractCanvasHandler {
    private JPopupMenu pmenu;
    private JMenuItem toggleAboveFold;
    private JMenuItem toggleFold;
    private JMenuItem addCounter;
    private JMenuItem addLeft;
    private JMenuItem addRight;
    private JMenuItem remove;
    private JMenuItem removeChild;
    private ADTreeNode menuNode;

    public ADTreeCanvasHandler(ADTreeCanvas canvas) {
        super(canvas);
        this.initPopupMenu();
    }

    public void keyPressed(KeyEvent e) {
        boolean consume;
        block22: {
            ADTreeNode node;
            block23: {
                block24: {
                    block21: {
                        consume = true;
                        node = this.canvas.getFocused();
                        if (!e.isControlDown()) break block21;
                        if (node != null) {
                            switch (e.getKeyCode()) {
                                case 74: {
                                    this.canvas.changeOp(node);
                                    break;
                                }
                                case 73: {
                                    this.canvas.addCounter(node);
                                    break;
                                }
                                case 78: {
                                    this.canvas.addChild(node);
                                    break;
                                }
                                case 76: {
                                    this.menuNode = node;
                                    this.changeLabelActionPerformed();
                                    break;
                                }
                                case 82: {
                                    this.canvas.removeTree(node);
                                    break;
                                }
                                case 83: {
                                    this.canvas.addSibling(node, !e.isShiftDown());
                                    break;
                                }
                                default: {
                                    consume = false;
                                    break;
                                }
                            }
                        } else {
                            consume = false;
                        }
                        break block22;
                    }
                    if (!e.isShiftDown()) break block23;
                    if (node == null) break block24;
                    switch (e.getKeyCode()) {
                        case 32: {
                            if (node != null) {
                                this.menuNode = node;
                                this.canvas.toggleAboveFold(this.menuNode);
                                break;
                            }
                            break block22;
                        }
                        case 82: {
                            if (node != null) {
                                this.menuNode = node;
                                this.canvas.removeChildren(node);
                                break;
                            }
                            break block22;
                        }
                        default: {
                            consume = false;
                            break;
                        }
                    }
                    break block22;
                }
                consume = false;
                break block22;
            }
            switch (e.getKeyCode()) {
                case 10: {
                    if (node == null) break;
                    this.menuNode = node;
                    this.changeLabelActionPerformed();
                    this.canvas.setFocus(this.menuNode);
                    break;
                }
                case 32: {
                    if (node == null) break;
                    this.menuNode = node;
                    this.canvas.toggleFold(this.menuNode);
                    break;
                }
                default: {
                    consume = false;
                }
            }
        }
        if (!consume) {
            super.keyPressed(e);
        }
    }

    public final void mouseClicked(MouseEvent e) {
        this.canvas.requestFocusInWindow();
        ADTreeNode node = this.canvas.getNode(e.getX(), e.getY());
        if (node != null) {
            if (e.getModifiers() == 4 || e.getModifiers() == 2) {
                this.menuNode = node;
                this.pmenu.show(e.getComponent(), e.getX(), e.getY());
                this.setFocus(node);
            } else if (node.equals(this.canvas.getFocused())) {
                this.menuNode = node;
                this.changeLabelActionPerformed();
            } else {
                this.setFocus(node);
            }
        }
    }

    public void setFocus(ADTreeNode node) {
        if (node != null) {
            boolean canFoldAbove;
            boolean canFold;
            boolean canAddSibling;
            ADTreeNode parent = this.canvas.getParentNode(node);
            if (parent == null) {
                canAddSibling = false;
            } else {
                boolean bl = canAddSibling = parent.getType() == node.getType();
            }
            if (node.isFolded()) {
                this.toggleFold.setText("Expand Below");
                canFold = true;
            } else {
                this.toggleFold.setText("Fold Below");
                boolean bl = canFold = this.canvas.getTree().getChildrenList(node, false).size() > 0;
            }
            if (node.isAboveFolded()) {
                this.toggleAboveFold.setText("Expand Above");
                canFoldAbove = true;
            } else {
                this.toggleAboveFold.setText("Fold Above");
                canFoldAbove = this.canvas.getTree().getParent(node, false) != null;
            }
            this.toggleAboveFold.setVisible(canFoldAbove);
            this.toggleFold.setVisible(canFold);
            this.addCounter.setVisible(!node.isCountered());
            this.addLeft.setVisible(canAddSibling);
            this.addRight.setVisible(canAddSibling);
            this.remove.setVisible(parent != null);
            this.removeChild.setVisible(this.canvas.getMiddleChild(node) != null);
            this.pmenu.pack();
        }
        super.setFocus(node);
    }

    private void initPopupMenu() {
        this.pmenu = new JPopupMenu();
        this.menuNode = null;
        JMenuItem menuItem = new JMenuItem("Change Label");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ADTreeCanvasHandler.this.changeLabelActionPerformed();
            }
        });
        this.pmenu.add(menuItem);
        menuItem = new JMenuItem("Change Operator");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ADTreeCanvasHandler.this.menuNode != null) {
                    ADTreeCanvasHandler.this.canvas.changeOp(ADTreeCanvasHandler.this.menuNode);
                }
            }
        });
        this.pmenu.add(menuItem);
        this.toggleAboveFold = new JMenuItem("Fold Above");
        this.toggleAboveFold.setAccelerator(KeyStroke.getKeyStroke(32, 1));
        this.toggleAboveFold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ADTreeCanvasHandler.this.menuNode != null) {
                    ADTreeCanvasHandler.this.canvas.toggleAboveFold(ADTreeCanvasHandler.this.menuNode);
                }
            }
        });
        this.pmenu.add(this.toggleAboveFold);
        this.toggleFold = new JMenuItem("Fold Below");
        this.toggleFold.setAccelerator(KeyStroke.getKeyStroke(32, 0, true));
        this.toggleFold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ADTreeCanvasHandler.this.menuNode != null) {
                    ADTreeCanvasHandler.this.canvas.toggleFold(ADTreeCanvasHandler.this.menuNode);
                }
            }
        });
        this.pmenu.add(this.toggleFold);
        this.pmenu.addSeparator();
        menuItem = new JMenuItem("Add Child");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ADTreeCanvasHandler.this.menuNode != null) {
                    ADTreeCanvasHandler.this.canvas.addChild(ADTreeCanvasHandler.this.menuNode);
                }
            }
        });
        this.pmenu.add(menuItem);
        this.addCounter = new JMenuItem("Add Countermeasure");
        this.addCounter.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.addCounter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ADTreeCanvasHandler.this.menuNode != null) {
                    ADTreeCanvasHandler.this.canvas.addCounter(ADTreeCanvasHandler.this.menuNode);
                }
            }
        });
        this.pmenu.add(this.addCounter);
        this.addLeft = new JMenuItem("Add Left Sibling");
        this.addLeft.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.addLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ADTreeCanvasHandler.this.menuNode != null) {
                    ADTreeCanvasHandler.this.canvas.addSibling(ADTreeCanvasHandler.this.menuNode, true);
                }
            }
        });
        this.pmenu.add(this.addLeft);
        this.addRight = new JMenuItem("Add Right Sibling");
        this.addRight.setAccelerator(KeyStroke.getKeyStroke("shift control S"));
        this.addRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ADTreeCanvasHandler.this.menuNode != null) {
                    ADTreeCanvasHandler.this.canvas.addSibling(ADTreeCanvasHandler.this.menuNode, false);
                }
            }
        });
        this.pmenu.add(this.addRight);
        this.pmenu.addSeparator();
        this.remove = new JMenuItem("Remove Subtree");
        this.remove.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ADTreeCanvasHandler.this.menuNode != null) {
                    ADTreeCanvasHandler.this.canvas.removeTree(ADTreeCanvasHandler.this.menuNode);
                }
            }
        });
        this.pmenu.add(this.remove);
        this.removeChild = new JMenuItem("Remove Children");
        this.removeChild.setAccelerator(KeyStroke.getKeyStroke(82, 1));
        this.removeChild.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ADTreeCanvasHandler.this.menuNode != null) {
                    ADTreeCanvasHandler.this.canvas.removeChildren(ADTreeCanvasHandler.this.menuNode);
                }
            }
        });
        this.pmenu.add(this.removeChild);
    }

    private boolean validLabel(String s) {
        return this.canvas.validLabel(s);
    }

    private void changeLabelActionPerformed() {
        if (this.menuNode != null) {
            String s = MultilineInput.showInputDialog("Enter new label:", "Change Label Dialog", this.menuNode.getLabel());
            if (s == null) {
                return;
            }
            while (!this.validLabel(s.replaceAll("^ +| +$| +\n|\n +|(\n)[ \t]*\n|( )+", "$1"))) {
                if ((s = MultilineInput.showInputDialog("<html><body><font color=\"red\">Invalid Label Format.</font> Enter new label:</body></html>", "Change Label Dialog", s.trim())) != null) continue;
                return;
            }
            s = s.replaceAll("(?m)^ +| +$|^[ \t]*\r?\n|( )+", "$1");
            this.menuNode.setLabel(s);
            this.canvas.setLabel(this.menuNode, s);
            this.canvas.setFocus(this.menuNode);
        }
    }
}

