/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adtool.ui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import lu.uni.adtool.Main;

class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public AboutDialog() {
        this.initCloseListener();
        this.initUI();
    }

    private ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public final void initUI() {
        JPanel mainPane = new JPanel();
        Border paneEdge = BorderFactory.createEmptyBorder(20, 20, 20, 20);
        mainPane.setBorder(paneEdge);
        mainPane.setBackground(Color.white);
        mainPane.setOpaque(true);
        mainPane.setLayout(new BoxLayout(mainPane, 1));
        JLabel name = new JLabel("ADTool " + AboutDialog.getVersionInfo());
        name.setFont(new Font("Serif", 1, 13));
        name.setAlignmentX(0.5f);
        mainPane.add(name);
        mainPane.add(Box.createRigidArea(new Dimension(0, 10)));
        ImageIcon icon = this.createImageIcon("/icons/ADToolVer2.png", "ADTree Tool");
        JLabel label = new JLabel(icon);
        label.setAlignmentX(0.5f);
        mainPane.add(label);
        mainPane.add(Box.createRigidArea(new Dimension(0, 10)));
        name = new JLabel("<html>Supported by the Fonds National de la Recherche, Luxembourg<br>under grants C08/IS/26 and PHD-09-167 and the European<br>Commission's Seventh Framework Programme (FP7/2007-2013)<br>under grant 318003 (TREsPASS)</html>");
        name.setFont(new Font("Serif", 0, 13));
        name.setAlignmentX(0.5f);
        mainPane.add(name);
        mainPane.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel p = new JPanel();
        BoxLayout b = new BoxLayout(p, 0);
        p.setLayout(b);
        p.add(Box.createRigidArea(new Dimension(5, 0)));
        icon = this.createImageIcon("/icons/fnr_logo.png", "FNR logo");
        p.add(new JLabel(icon));
        p.add(Box.createRigidArea(new Dimension(25, 0)));
        icon = this.createImageIcon("/icons/2eulogos.png", "EU logo");
        p.add(new JLabel(icon));
        p.add(Box.createRigidArea(new Dimension(5, 0)));
        p.setBackground(Color.white);
        p.setOpaque(true);
        mainPane.add(p);
        mainPane.add(Box.createRigidArea(new Dimension(0, 10)));
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AboutDialog.this.dispose();
            }
        });
        close.setAlignmentX(0.5f);
        mainPane.add(close);
        this.add(mainPane);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("About ADTool");
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.pack();
    }

    private void initCloseListener() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){
            private static final long serialVersionUID = 2143956335533214473L;

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
    }

    public static String getVersionInfo() {
        String result = "";
        try {
            Class<Main> clazz = Main.class;
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                return "No version info";
            }
            String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes mainAttribs = manifest.getMainAttributes();
            result = result + mainAttribs.getValue("Implementation-Version") + " (";
            result = result + mainAttribs.getValue("Date-Build") + ")";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

